/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AgeRestriction;
import org.gotson.komga.domain.model.AllowExclude;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.UserRoles;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.main.KomgaUserDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.AnnouncementsRead;
import org.gotson.komga.jooq.main.tables.User;
import org.gotson.komga.jooq.main.tables.UserApiKey;
import org.gotson.komga.jooq.main.tables.UserLibrarySharing;
import org.gotson.komga.jooq.main.tables.UserRole;
import org.gotson.komga.jooq.main.tables.UserSharing;
import org.gotson.komga.jooq.main.tables.records.UserApiKeyRecord;
import org.gotson.komga.jooq.main.tables.records.UserLibrarySharingRecord;
import org.gotson.komga.jooq.main.tables.records.UserRecord;
import org.gotson.komga.jooq.main.tables.records.UserSharingRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u001f\u0010 \u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\"0\"0!\u00a2\u0006\u0002\b#*\u00020\u0004H\u0012J \u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%*\b\u0012\u0004\u0012\u00020\"0&2\u0006\u0010'\u001a\u00020\u0004H\u0012J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019H\u0017J\u0010\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019H\u0017J\u001e\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0/H\u0016J\u0014\u00100\u001a\u00020)*\u00020\u00042\u0006\u0010*\u001a\u00020\u0019H\u0012J\u0014\u00101\u001a\u00020)*\u00020\u00042\u0006\u0010*\u001a\u00020\u0019H\u0012J\u0014\u00102\u001a\u00020)*\u00020\u00042\u0006\u0010*\u001a\u00020\u0019H\u0012J\u0010\u00103\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\b\u00104\u001a\u00020)H\u0017J\u0018\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00107\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001dH\u0016J\u0018\u0010<\u001a\u00020:2\u0006\u00106\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u00192\u0006\u0010;\u001a\u00020\u001dH\u0016J\u001e\u0010@\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b\u0018\u00010A2\u0006\u0010+\u001a\u00020\u001dH\u0016J\f\u0010B\u001a\u00020\u001b*\u00020CH\u0012R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \n*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \n*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/KomgaUserDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;)V", "u", "Lorg/gotson/komga/jooq/main/tables/User;", "kotlin.jvm.PlatformType", "ur", "Lorg/gotson/komga/jooq/main/tables/UserRole;", "ul", "Lorg/gotson/komga/jooq/main/tables/UserLibrarySharing;", "us", "Lorg/gotson/komga/jooq/main/tables/UserSharing;", "ar", "Lorg/gotson/komga/jooq/main/tables/AnnouncementsRead;", "uak", "Lorg/gotson/komga/jooq/main/tables/UserApiKey;", "count", "", "findAll", "", "Lorg/gotson/komga/domain/model/KomgaUser;", "findApiKeyByUserId", "Lorg/gotson/komga/domain/model/ApiKey;", "userId", "", "findByIdOrNull", "id", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "fetchAndMap", "", "Lorg/jooq/ResultQuery;", "dsl", "insert", "", "user", "apiKey", "update", "saveAnnouncementIdsRead", "announcementIds", "", "insertRoles", "insertSharedLibraries", "insertSharingRestrictions", "delete", "deleteAll", "deleteApiKeyByIdAndUserId", "apiKeyId", "deleteApiKeyByUserId", "findAnnouncementIdsReadByUserId", "existsByEmailIgnoreCase", "", "email", "existsApiKeyByIdAndUserId", "existsApiKeyByCommentAndUserId", "comment", "findByEmailIgnoreCaseOrNull", "findByApiKeyOrNull", "Lkotlin/Pair;", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/UserApiKeyRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaUserDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaUserDao.kt\norg/gotson/komga/infrastructure/jooq/main/KomgaUserDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n126#2:323\n153#2,2:324\n155#2:353\n1617#3,9:326\n1869#3:335\n1870#3:337\n1626#3:338\n774#3:339\n865#3,2:340\n1563#3:342\n1634#3,3:343\n827#3:346\n855#3,2:347\n1563#3:349\n1634#3,3:350\n1563#3:354\n1634#3,3:355\n1869#3,2:358\n1869#3,2:360\n1869#3,2:362\n1869#3,2:364\n1#4:336\n*S KotlinDebug\n*F\n+ 1 KomgaUserDao.kt\norg/gotson/komga/infrastructure/jooq/main/KomgaUserDao\n*L\n69#1:323\n69#1:324,2\n69#1:353\n85#1:326,9\n85#1:335\n85#1:337\n85#1:338\n94#1:339\n94#1:340,2\n94#1:342\n94#1:343,3\n95#1:346\n95#1:347,2\n95#1:349\n95#1:350,3\n181#1:354\n181#1:355,3\n188#1:358,2\n198#1:360,2\n208#1:362,2\n216#1:364,2\n85#1:336\n*E\n"})
public class KomgaUserDao
extends SplitDslDaoBase
implements KomgaUserRepository {
    private final User u;
    private final UserRole ur;
    private final UserLibrarySharing ul;
    private final UserSharing us;
    private final AnnouncementsRead ar;
    private final UserApiKey uak;

    public KomgaUserDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.u = Tables.USER;
        this.ur = Tables.USER_ROLE;
        this.ul = Tables.USER_LIBRARY_SHARING;
        this.us = Tables.USER_SHARING;
        this.ar = Tables.ANNOUNCEMENTS_READ;
        this.uak = Tables.USER_API_KEY;
    }

    public long count() {
        return this.getDslRO().fetchCount((Table)this.u);
    }

    @NotNull
    public Collection<KomgaUser> findAll() {
        return this.fetchAndMap((ResultQuery)this.selectBase(this.getDslRO()), this.getDslRO());
    }

    @NotNull
    public Collection<ApiKey> findApiKeyByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        List list = this.getDslRO().selectFrom((TableLike)this.uak).where(this.uak.USER_ID.eq((Object)userId)).fetchInto((Table)this.uak).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Nullable
    public KomgaUser findByIdOrNull(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SelectConditionStep selectConditionStep = this.selectBase(this.getDslRO()).where(this.u.ID.equal((Object)id));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep, this.getDslRO()));
    }

    private @NotNull SelectOnConditionStep<Record> selectBase(DSLContext $this$selectBase) {
        Field[] fieldArray = this.u.fields();
        SelectSelectStep selectSelectStep = $this$selectBase.select((SelectFieldOrAsterisk[])Arrays.copyOf(fieldArray, fieldArray.length));
        fieldArray = new SelectFieldOrAsterisk[]{this.ul.LIBRARY_ID};
        SelectOnConditionStep selectOnConditionStep = selectSelectStep.select((SelectFieldOrAsterisk[])fieldArray).from((TableLike)this.u).leftJoin((TableLike)this.ul).onKey();
        Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep, (String)"onKey(...)");
        return selectOnConditionStep;
    }

    /*
     * WARNING - void declaration
     */
    private List<KomgaUser> fetchAndMap(ResultQuery<Record> $this$fetchAndMap, DSLContext dsl) {
        void $this$mapTo$iv$iv;
        Map map = $this$fetchAndMap.fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Iterable $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            UserSharingRecord it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            AgeRestriction ageRestriction;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            List roles;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserRecord userRecord = (UserRecord)entry.getKey();
            List ulr = (List)entry.getValue();
            SelectConditionStep selectConditionStep = dsl.selectFrom((TableLike)this.us).where(this.us.USER_ID.eq((Object)userRecord.getId()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
            List usr = CollectionsKt.toList((Iterable)((Iterable)selectConditionStep));
            Intrinsics.checkNotNullExpressionValue((Object)dsl.select((SelectField)this.ur.ROLE).from((TableLike)this.ur).where(this.ur.USER_ID.eq((Object)userRecord.getId())).fetch((Field)this.ur.ROLE), (String)"fetch(...)");
            String string2 = userRecord.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmail(...)");
            String string3 = userRecord.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPassword(...)");
            Set set = UserRoles.Companion.valuesOf((Iterable)roles);
            Intrinsics.checkNotNull((Object)ulr);
            Iterable iterable = ulr;
            Set set2 = set;
            String string4 = string3;
            String string5 = string2;
            boolean $i$f$mapNotNull = false;
            void var21_21 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                UserLibrarySharingRecord it2 = (UserLibrarySharingRecord)element$iv$iv;
                boolean bl3 = false;
                if (it2.getLibraryId() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv2;
            Set set3 = CollectionsKt.toSet((Iterable)collection2);
            Boolean bl5 = userRecord.getSharedAllLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"getSharedAllLibraries(...)");
            boolean bl6 = bl5;
            if (userRecord.getAgeRestriction() != null && userRecord.getAgeRestrictionAllowOnly() != null) {
                Integer n = userRecord.getAgeRestriction();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getAgeRestriction(...)");
                ageRestriction = new AgeRestriction(((Number)n).intValue(), userRecord.getAgeRestrictionAllowOnly() != false ? AllowExclude.ALLOW_ONLY : AllowExclude.EXCLUDE);
            } else {
                ageRestriction = null;
            }
            $this$mapNotNull$iv = usr;
            AgeRestriction ageRestriction2 = ageRestriction;
            boolean bl7 = bl6;
            collection2 = set3;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UserSharingRecord)element$iv$iv;
                boolean bl8 = false;
                Boolean bl9 = it.getAllow();
                Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"getAllow(...)");
                if (!bl9.booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<String> collection3 = (List)destination$iv$iv2;
            $this$filter$iv = collection3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (UserSharingRecord)item$iv$iv2;
                collection3 = destination$iv$iv2;
                boolean bl10 = false;
                collection3.add(it.getLabel());
            }
            collection3 = (List)destination$iv$iv2;
            $this$map$iv2 = usr;
            collection3 = CollectionsKt.toSet((Iterable)collection3);
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv2 = $this$filterNot$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (UserSharingRecord)element$iv$iv;
                boolean bl11 = false;
                Boolean bl12 = it.getAllow();
                Intrinsics.checkNotNullExpressionValue((Object)bl12, (String)"getAllow(...)");
                if (bl12.booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<String> collection4 = (List)destination$iv$iv2;
            $this$filterNot$iv = collection4;
            $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                it = (UserSharingRecord)item$iv$iv3;
                collection4 = destination$iv$iv2;
                boolean bl13 = false;
                collection4.add(it.getLabel());
            }
            collection4 = (List)destination$iv$iv2;
            Set set4 = CollectionsKt.toSet((Iterable)collection4);
            Collection<String> collection5 = collection3;
            AgeRestriction ageRestriction3 = ageRestriction2;
            ContentRestrictions contentRestrictions = new ContentRestrictions(ageRestriction3, collection5, set4);
            Intrinsics.checkNotNullExpressionValue((Object)userRecord.getId(), (String)"getId(...)");
            LocalDateTime localDateTime = userRecord.getCreatedDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
            LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
            LocalDateTime localDateTime3 = userRecord.getLastModifiedDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
            LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
            LocalDateTime localDateTime5 = localDateTime2;
            ContentRestrictions contentRestrictions2 = contentRestrictions;
            boolean bl14 = bl7;
            Collection collection6 = collection2;
            Set set5 = set2;
            String string6 = string4;
            String string7 = string5;
            collection.add(new KomgaUser(string7, string6, set5, (Set)collection6, bl14, contentRestrictions2, string, localDateTime5, localDateTime4));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    public void insert(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        AgeRestriction ageRestriction = user.getRestrictions().getAgeRestriction();
        InsertSetMoreStep insertSetMoreStep = this.getDslRW().insertInto((Table)this.u).set((Field)this.u.ID, (Object)user.getId()).set((Field)this.u.EMAIL, (Object)user.getEmail()).set((Field)this.u.PASSWORD, (Object)user.getPassword()).set((Field)this.u.SHARED_ALL_LIBRARIES, (Object)user.getSharedAllLibraries()).set((Field)this.u.AGE_RESTRICTION, (Object)(ageRestriction != null ? Integer.valueOf(ageRestriction.getAge()) : null));
        Field field = (Field)this.u.AGE_RESTRICTION_ALLOW_ONLY;
        AgeRestriction ageRestriction2 = user.getRestrictions().getAgeRestriction();
        Object object = ageRestriction2 != null ? ageRestriction2.getRestriction() : null;
        insertSetMoreStep.set(field, (Object)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        })).execute();
        this.insertRoles(this.getDslRW(), user);
        this.insertSharedLibraries(this.getDslRW(), user);
        this.insertSharingRestrictions(this.getDslRW(), user);
    }

    public void insert(@NotNull ApiKey apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.getDslRW().insertInto((Table)this.uak).set((Field)this.uak.ID, (Object)apiKey.getId()).set((Field)this.uak.USER_ID, (Object)apiKey.getUserId()).set((Field)this.uak.API_KEY, (Object)apiKey.getKey()).set((Field)this.uak.COMMENT, (Object)apiKey.getComment()).execute();
    }

    @Transactional
    public void update(@NotNull KomgaUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        AgeRestriction ageRestriction = user.getRestrictions().getAgeRestriction();
        UpdateSetMoreStep updateSetMoreStep = this.getDslRW().update((Table)this.u).set((Field)this.u.EMAIL, (Object)user.getEmail()).set((Field)this.u.PASSWORD, (Object)user.getPassword()).set((Field)this.u.SHARED_ALL_LIBRARIES, (Object)user.getSharedAllLibraries()).set((Field)this.u.AGE_RESTRICTION, (Object)(ageRestriction != null ? Integer.valueOf(ageRestriction.getAge()) : null));
        Field field = (Field)this.u.AGE_RESTRICTION_ALLOW_ONLY;
        AgeRestriction ageRestriction2 = user.getRestrictions().getAgeRestriction();
        Object object = ageRestriction2 != null ? ageRestriction2.getRestriction() : null;
        updateSetMoreStep.set(field, (Object)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        })).set((Field)this.u.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.u.ID.eq((Object)user.getId())).execute();
        this.getDslRW().deleteFrom((Table)this.ur).where(this.ur.USER_ID.eq((Object)user.getId())).execute();
        this.getDslRW().deleteFrom((Table)this.ul).where(this.ul.USER_ID.eq((Object)user.getId())).execute();
        this.getDslRW().deleteFrom((Table)this.us).where(this.us.USER_ID.eq((Object)user.getId())).execute();
        this.insertRoles(this.getDslRW(), user);
        this.insertSharedLibraries(this.getDslRW(), user);
        this.insertSharingRestrictions(this.getDslRW(), user);
    }

    /*
     * WARNING - void declaration
     */
    public void saveAnnouncementIdsRead(@NotNull KomgaUser user, @NotNull Set<String> announcementIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(announcementIds, (String)"announcementIds");
        Iterable iterable = announcementIds;
        DSLContext dSLContext = this.getDslRW();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{user.getId(), it};
            collection.add(this.getDslRW().insertInto((Table)this.ar).values(objectArray).onDuplicateKeyIgnore());
        }
        dSLContext.batch((Collection)((List)destination$iv$iv)).execute();
    }

    private void insertRoles(DSLContext $this$insertRoles, KomgaUser user) {
        Iterable $this$forEach$iv = user.getRoles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserRoles it = (UserRoles)element$iv;
            boolean bl = false;
            $this$insertRoles.insertInto((Table)this.ur).columns((Field)this.ur.USER_ID, (Field)this.ur.ROLE).values((Object)user.getId(), (Object)it.name()).execute();
        }
    }

    private void insertSharedLibraries(DSLContext $this$insertSharedLibraries, KomgaUser user) {
        Iterable $this$forEach$iv = user.getSharedLibrariesIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            $this$insertSharedLibraries.insertInto((Table)this.ul).columns((Field)this.ul.USER_ID, (Field)this.ul.LIBRARY_ID).values((Object)user.getId(), (Object)it).execute();
        }
    }

    private void insertSharingRestrictions(DSLContext $this$insertSharingRestrictions, KomgaUser user) {
        String label;
        Iterable $this$forEach$iv = user.getRestrictions().getLabelsAllow();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            label = (String)element$iv;
            boolean bl = false;
            $this$insertSharingRestrictions.insertInto((Table)this.us).columns((Field)this.us.USER_ID, (Field)this.us.ALLOW, (Field)this.us.LABEL).values((Object)user.getId(), (Object)true, (Object)label).execute();
        }
        $this$forEach$iv = user.getRestrictions().getLabelsExclude();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            label = (String)element$iv;
            boolean bl = false;
            $this$insertSharingRestrictions.insertInto((Table)this.us).columns((Field)this.us.USER_ID, (Field)this.us.ALLOW, (Field)this.us.LABEL).values((Object)user.getId(), (Object)false, (Object)label).execute();
        }
    }

    @Transactional
    public void delete(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.getDslRW().deleteFrom((Table)this.uak).where(this.uak.USER_ID.equal((Object)userId)).execute();
        this.getDslRW().deleteFrom((Table)this.ar).where(this.ar.USER_ID.equal((Object)userId)).execute();
        this.getDslRW().deleteFrom((Table)this.us).where(this.us.USER_ID.equal((Object)userId)).execute();
        this.getDslRW().deleteFrom((Table)this.ul).where(this.ul.USER_ID.equal((Object)userId)).execute();
        this.getDslRW().deleteFrom((Table)this.ur).where(this.ur.USER_ID.equal((Object)userId)).execute();
        this.getDslRW().deleteFrom((Table)this.u).where(this.u.ID.equal((Object)userId)).execute();
    }

    @Transactional
    public void deleteAll() {
        this.getDslRW().deleteFrom((Table)this.uak).execute();
        this.getDslRW().deleteFrom((Table)this.ar).execute();
        this.getDslRW().deleteFrom((Table)this.us).execute();
        this.getDslRW().deleteFrom((Table)this.ul).execute();
        this.getDslRW().deleteFrom((Table)this.ur).execute();
        this.getDslRW().deleteFrom((Table)this.u).execute();
    }

    public void deleteApiKeyByIdAndUserId(@NotNull String apiKeyId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.getDslRW().deleteFrom((Table)this.uak).where(this.uak.ID.eq((Object)apiKeyId)).and(this.uak.USER_ID.eq((Object)userId)).execute();
    }

    public void deleteApiKeyByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.getDslRW().deleteFrom((Table)this.uak).where(this.uak.USER_ID.eq((Object)userId)).execute();
    }

    @NotNull
    public Set<String> findAnnouncementIdsReadByUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Set set = this.getDslRO().select((SelectField)this.ar.ANNOUNCEMENT_ID).from((TableLike)this.ar).where(this.ar.USER_ID.eq((Object)userId)).fetchSet((Field)this.ar.ANNOUNCEMENT_ID);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    public boolean existsByEmailIgnoreCase(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return this.getDslRO().fetchExists((Select)this.getDslRO().selectFrom((TableLike)this.u).where(this.u.EMAIL.equalIgnoreCase(email)));
    }

    public boolean existsApiKeyByIdAndUserId(@NotNull String apiKeyId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.getDslRO().fetchExists((Table)this.uak, this.uak.ID.eq((Object)apiKeyId).and(this.uak.USER_ID.eq((Object)userId)));
    }

    public boolean existsApiKeyByCommentAndUserId(@NotNull String comment, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.getDslRO().fetchExists((Table)this.uak, this.uak.COMMENT.equalIgnoreCase(comment).and(this.uak.USER_ID.eq((Object)userId)));
    }

    @Nullable
    public KomgaUser findByEmailIgnoreCaseOrNull(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        SelectConditionStep selectConditionStep = this.selectBase(this.getDslRO()).where(this.u.EMAIL.equalIgnoreCase(email));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep, this.getDslRO()));
    }

    @Nullable
    public Pair<KomgaUser, ApiKey> findByApiKeyOrNull(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        SelectConditionStep selectConditionStep = this.selectBase(this.getDslRO()).leftJoin((TableLike)this.uak).on(this.u.ID.eq((Field)this.uak.USER_ID)).where(this.uak.API_KEY.eq((Object)apiKey));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        KomgaUser komgaUser = (KomgaUser)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep, this.getDslRO()));
        if (komgaUser == null) {
            return null;
        }
        KomgaUser user = komgaUser;
        List list = this.getDslRO().selectFrom((TableLike)this.uak).where(this.uak.API_KEY.eq((Object)apiKey)).fetchInto((Table)this.uak).map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        ApiKey apiKey2 = (ApiKey)CollectionsKt.firstOrNull((List)list);
        if (apiKey2 == null) {
            return null;
        }
        ApiKey key2 = apiKey2;
        return new Pair((Object)user, (Object)key2);
    }

    private ApiKey toDomain(UserApiKeyRecord $this$toDomain) {
        String string = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$toDomain.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserId(...)");
        String string3 = $this$toDomain.getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getApiKey(...)");
        String string4 = $this$toDomain.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getComment(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        return new ApiKey(string, string2, string3, string4, localDateTime2, LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3));
    }

    public static final /* synthetic */ ApiKey access$toDomain(KomgaUserDao $this, UserApiKeyRecord $receiver) {
        return $this.toDomain($receiver);
    }

    public static final /* synthetic */ User access$getU$p(KomgaUserDao $this) {
        return $this.u;
    }

    public static final /* synthetic */ UserLibrarySharing access$getUl$p(KomgaUserDao $this) {
        return $this.ul;
    }
}

