/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Library;
import org.gotson.komga.jooq.main.tables.LibraryExclusions;
import org.gotson.komga.jooq.main.tables.UserLibrarySharing;
import org.gotson.komga.jooq.main.tables.records.LibraryExclusionsRecord;
import org.gotson.komga.jooq.main.tables.records.LibraryRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0014\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0016J\u001f\u0010\u001c\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00160\u00160\u001d\u00a2\u0006\u0002\b\u0017*\u00020\u0004H\u0012J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019*\b\u0012\u0004\u0012\u00020\u00160\u001fH\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\"\u001a\u00020!H\u0017J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0010H\u0017J\u0010\u0010%\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0010H\u0017J\b\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u00020!*\u00020\u00042\u0006\u0010$\u001a\u00020\u0010H\u0012J\u001a\u0010)\u001a\u00020\u0010*\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,H\u0012R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/LibraryDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;)V", "l", "Lorg/gotson/komga/jooq/main/tables/Library;", "kotlin.jvm.PlatformType", "ul", "Lorg/gotson/komga/jooq/main/tables/UserLibrarySharing;", "le", "Lorg/gotson/komga/jooq/main/tables/LibraryExclusions;", "findByIdOrNull", "Lorg/gotson/komga/domain/model/Library;", "libraryId", "", "findById", "findOne", "Lorg/jooq/SelectConditionStep;", "Lorg/jooq/Record;", "Lorg/jetbrains/annotations/NotNull;", "findAll", "", "findAllByIds", "libraryIds", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "fetchAndMap", "Lorg/jooq/ResultQuery;", "delete", "", "deleteAll", "insert", "library", "update", "count", "", "insertDirectoryExclusions", "toDomain", "Lorg/gotson/komga/jooq/main/tables/records/LibraryRecord;", "directoryExclusions", "", "komga"})
@SourceDebugExtension(value={"SMAP\nLibraryDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDao.kt\norg/gotson/komga/infrastructure/jooq/main/LibraryDao\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n126#2:214\n153#2,2:215\n155#2:230\n1617#3,9:217\n1869#3:226\n1870#3:228\n1626#3:229\n1869#3,2:231\n1#4:227\n*S KotlinDebug\n*F\n+ 1 LibraryDao.kt\norg/gotson/komga/infrastructure/jooq/main/LibraryDao\n*L\n64#1:214\n64#1:215,2\n64#1:230\n65#1:217,9\n65#1:226\n65#1:228\n65#1:229\n170#1:231,2\n65#1:227\n*E\n"})
public class LibraryDao
extends SplitDslDaoBase
implements LibraryRepository {
    private final Library l;
    private final UserLibrarySharing ul;
    private final LibraryExclusions le;

    public LibraryDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.l = Tables.LIBRARY;
        this.ul = Tables.USER_LIBRARY_SHARING;
        this.le = Tables.LIBRARY_EXCLUSIONS;
    }

    @Nullable
    public org.gotson.komga.domain.model.Library findByIdOrNull(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return (org.gotson.komga.domain.model.Library)CollectionsKt.firstOrNull((Iterable)this.fetchAndMap((ResultQuery)this.findOne(libraryId)));
    }

    @NotNull
    public org.gotson.komga.domain.model.Library findById(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return (org.gotson.komga.domain.model.Library)CollectionsKt.first((Iterable)this.fetchAndMap((ResultQuery)this.findOne(libraryId)));
    }

    private @NotNull SelectConditionStep<Record> findOne(String libraryId) {
        SelectConditionStep selectConditionStep = this.selectBase(this.getDslRO()).where(this.l.ID.eq((Object)libraryId));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return selectConditionStep;
    }

    @NotNull
    public Collection<org.gotson.komga.domain.model.Library> findAll() {
        return this.fetchAndMap((ResultQuery)this.selectBase(this.getDslRO()));
    }

    @NotNull
    public Collection<org.gotson.komga.domain.model.Library> findAllByIds(@NotNull Collection<String> libraryIds) {
        Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
        SelectConditionStep selectConditionStep = this.selectBase(this.getDslRO()).where(this.l.ID.in(libraryIds));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return this.fetchAndMap((ResultQuery)selectConditionStep);
    }

    private @NotNull SelectOnConditionStep<Record> selectBase(DSLContext $this$selectBase) {
        SelectOnConditionStep selectOnConditionStep = $this$selectBase.select(new SelectFieldOrAsterisk[0]).from((TableLike)this.l).leftJoin((TableLike)this.le).onKey();
        Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep, (String)"onKey(...)");
        return selectOnConditionStep;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<org.gotson.komga.domain.model.Library> fetchAndMap(ResultQuery<Record> $this$fetchAndMap) {
        void $this$mapTo$iv$iv;
        Map map = $this$fetchAndMap.fetchGroups((RecordMapper)new /* Unavailable Anonymous Inner Class!! */, (RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fetchGroups(...)");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LibraryRecord lr = (LibraryRecord)entry.getKey();
            List ler = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)lr);
            Intrinsics.checkNotNull((Object)ler);
            Iterable iterable = ler;
            LibraryRecord libraryRecord = lr;
            LibraryDao libraryDao = this;
            boolean $i$f$mapNotNull = false;
            void var17_17 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                LibraryExclusionsRecord it = (LibraryExclusionsRecord)element$iv$iv;
                boolean bl3 = false;
                if (it.getExclusion() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            collection.add(libraryDao.toDomain(libraryRecord, CollectionsKt.toSet((Iterable)list)));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    public void delete(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.getDslRW().deleteFrom((Table)this.le).where(this.le.LIBRARY_ID.eq((Object)libraryId)).execute();
        this.getDslRW().deleteFrom((Table)this.ul).where(this.ul.LIBRARY_ID.eq((Object)libraryId)).execute();
        this.getDslRW().deleteFrom((Table)this.l).where(this.l.ID.eq((Object)libraryId)).execute();
    }

    @Transactional
    public void deleteAll() {
        this.getDslRW().deleteFrom((Table)this.le).execute();
        this.getDslRW().deleteFrom((Table)this.ul).execute();
        this.getDslRW().deleteFrom((Table)this.l).execute();
    }

    @Transactional
    public void insert(@NotNull org.gotson.komga.domain.model.Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.getDslRW().insertInto((Table)this.l).set((Field)this.l.ID, (Object)library.getId()).set((Field)this.l.NAME, (Object)library.getName()).set((Field)this.l.ROOT, (Object)library.getRoot().toString()).set((Field)this.l.IMPORT_COMICINFO_BOOK, (Object)library.getImportComicInfoBook()).set((Field)this.l.IMPORT_COMICINFO_SERIES, (Object)library.getImportComicInfoSeries()).set((Field)this.l.IMPORT_COMICINFO_COLLECTION, (Object)library.getImportComicInfoCollection()).set((Field)this.l.IMPORT_COMICINFO_READLIST, (Object)library.getImportComicInfoReadList()).set((Field)this.l.IMPORT_COMICINFO_SERIES_APPEND_VOLUME, (Object)library.getImportComicInfoSeriesAppendVolume()).set((Field)this.l.IMPORT_EPUB_BOOK, (Object)library.getImportEpubBook()).set((Field)this.l.IMPORT_EPUB_SERIES, (Object)library.getImportEpubSeries()).set((Field)this.l.IMPORT_MYLAR_SERIES, (Object)library.getImportMylarSeries()).set((Field)this.l.IMPORT_LOCAL_ARTWORK, (Object)library.getImportLocalArtwork()).set((Field)this.l.IMPORT_BARCODE_ISBN, (Object)library.getImportBarcodeIsbn()).set((Field)this.l.SCAN_FORCE_MODIFIED_TIME, (Object)library.getScanForceModifiedTime()).set((Field)this.l.SCAN_CBX, (Object)library.getScanCbx()).set((Field)this.l.SCAN_PDF, (Object)library.getScanPdf()).set((Field)this.l.SCAN_EPUB, (Object)library.getScanEpub()).set((Field)this.l.SCAN_STARTUP, (Object)library.getScanOnStartup()).set((Field)this.l.SCAN_INTERVAL, (Object)library.getScanInterval().toString()).set((Field)this.l.REPAIR_EXTENSIONS, (Object)library.getRepairExtensions()).set((Field)this.l.CONVERT_TO_CBZ, (Object)library.getConvertToCbz()).set((Field)this.l.EMPTY_TRASH_AFTER_SCAN, (Object)library.getEmptyTrashAfterScan()).set((Field)this.l.SERIES_COVER, (Object)library.getSeriesCover().toString()).set((Field)this.l.HASH_FILES, (Object)library.getHashFiles()).set((Field)this.l.HASH_PAGES, (Object)library.getHashPages()).set((Field)this.l.HASH_KOREADER, (Object)library.getHashKoreader()).set((Field)this.l.ANALYZE_DIMENSIONS, (Object)library.getAnalyzeDimensions()).set((Field)this.l.ONESHOTS_DIRECTORY, (Object)library.getOneshotsDirectory()).set((Field)this.l.UNAVAILABLE_DATE, (Object)library.getUnavailableDate()).execute();
        this.insertDirectoryExclusions(this.getDslRW(), library);
    }

    @Transactional
    public void update(@NotNull org.gotson.komga.domain.model.Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.getDslRW().update((Table)this.l).set((Field)this.l.NAME, (Object)library.getName()).set((Field)this.l.ROOT, (Object)library.getRoot().toString()).set((Field)this.l.IMPORT_COMICINFO_BOOK, (Object)library.getImportComicInfoBook()).set((Field)this.l.IMPORT_COMICINFO_SERIES, (Object)library.getImportComicInfoSeries()).set((Field)this.l.IMPORT_COMICINFO_COLLECTION, (Object)library.getImportComicInfoCollection()).set((Field)this.l.IMPORT_COMICINFO_READLIST, (Object)library.getImportComicInfoReadList()).set((Field)this.l.IMPORT_COMICINFO_SERIES_APPEND_VOLUME, (Object)library.getImportComicInfoSeriesAppendVolume()).set((Field)this.l.IMPORT_EPUB_BOOK, (Object)library.getImportEpubBook()).set((Field)this.l.IMPORT_EPUB_SERIES, (Object)library.getImportEpubSeries()).set((Field)this.l.IMPORT_MYLAR_SERIES, (Object)library.getImportMylarSeries()).set((Field)this.l.IMPORT_LOCAL_ARTWORK, (Object)library.getImportLocalArtwork()).set((Field)this.l.IMPORT_BARCODE_ISBN, (Object)library.getImportBarcodeIsbn()).set((Field)this.l.SCAN_FORCE_MODIFIED_TIME, (Object)library.getScanForceModifiedTime()).set((Field)this.l.SCAN_CBX, (Object)library.getScanCbx()).set((Field)this.l.SCAN_PDF, (Object)library.getScanPdf()).set((Field)this.l.SCAN_EPUB, (Object)library.getScanEpub()).set((Field)this.l.SCAN_STARTUP, (Object)library.getScanOnStartup()).set((Field)this.l.SCAN_INTERVAL, (Object)library.getScanInterval().toString()).set((Field)this.l.REPAIR_EXTENSIONS, (Object)library.getRepairExtensions()).set((Field)this.l.CONVERT_TO_CBZ, (Object)library.getConvertToCbz()).set((Field)this.l.EMPTY_TRASH_AFTER_SCAN, (Object)library.getEmptyTrashAfterScan()).set((Field)this.l.SERIES_COVER, (Object)library.getSeriesCover().toString()).set((Field)this.l.HASH_FILES, (Object)library.getHashFiles()).set((Field)this.l.HASH_PAGES, (Object)library.getHashPages()).set((Field)this.l.HASH_KOREADER, (Object)library.getHashKoreader()).set((Field)this.l.ANALYZE_DIMENSIONS, (Object)library.getAnalyzeDimensions()).set((Field)this.l.ONESHOTS_DIRECTORY, (Object)library.getOneshotsDirectory()).set((Field)this.l.UNAVAILABLE_DATE, (Object)library.getUnavailableDate()).set((Field)this.l.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.l.ID.eq((Object)library.getId())).execute();
        this.getDslRW().deleteFrom((Table)this.le).where(this.le.LIBRARY_ID.eq((Object)library.getId())).execute();
        this.insertDirectoryExclusions(this.getDslRW(), library);
    }

    public long count() {
        return this.getDslRO().fetchCount((Table)this.l);
    }

    private void insertDirectoryExclusions(DSLContext $this$insertDirectoryExclusions, org.gotson.komga.domain.model.Library library) {
        if (!((Collection)library.getScanDirectoryExclusions()).isEmpty()) {
            BatchBindStep batchBindStep;
            BatchBindStep step = batchBindStep = $this$insertDirectoryExclusions.batch((Query)$this$insertDirectoryExclusions.insertInto((Table)this.le, (Field)this.le.LIBRARY_ID, (Field)this.le.EXCLUSION).values(null, null));
            boolean bl = false;
            Iterable $this$forEach$iv = library.getScanDirectoryExclusions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{library.getId(), it};
                step.bind(objectArray);
            }
            batchBindStep.execute();
        }
    }

    private org.gotson.komga.domain.model.Library toDomain(LibraryRecord $this$toDomain, Set<String> directoryExclusions) {
        String string = $this$toDomain.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        URL uRL = new URL($this$toDomain.getRoot());
        Boolean bl = $this$toDomain.getImportComicinfoBook();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getImportComicinfoBook(...)");
        boolean bl2 = bl;
        Boolean bl3 = $this$toDomain.getImportComicinfoSeries();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"getImportComicinfoSeries(...)");
        boolean bl4 = bl3;
        Boolean bl5 = $this$toDomain.getImportComicinfoCollection();
        Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"getImportComicinfoCollection(...)");
        boolean bl6 = bl5;
        Boolean bl7 = $this$toDomain.getImportComicinfoReadlist();
        Intrinsics.checkNotNullExpressionValue((Object)bl7, (String)"getImportComicinfoReadlist(...)");
        boolean bl8 = bl7;
        Boolean bl9 = $this$toDomain.getImportComicinfoSeriesAppendVolume();
        Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"getImportComicinfoSeriesAppendVolume(...)");
        boolean bl10 = bl9;
        Boolean bl11 = $this$toDomain.getImportEpubBook();
        Intrinsics.checkNotNullExpressionValue((Object)bl11, (String)"getImportEpubBook(...)");
        boolean bl12 = bl11;
        Boolean bl13 = $this$toDomain.getImportEpubSeries();
        Intrinsics.checkNotNullExpressionValue((Object)bl13, (String)"getImportEpubSeries(...)");
        boolean bl14 = bl13;
        Boolean bl15 = $this$toDomain.getImportMylarSeries();
        Intrinsics.checkNotNullExpressionValue((Object)bl15, (String)"getImportMylarSeries(...)");
        boolean bl16 = bl15;
        Boolean bl17 = $this$toDomain.getImportLocalArtwork();
        Intrinsics.checkNotNullExpressionValue((Object)bl17, (String)"getImportLocalArtwork(...)");
        boolean bl18 = bl17;
        Boolean bl19 = $this$toDomain.getImportBarcodeIsbn();
        Intrinsics.checkNotNullExpressionValue((Object)bl19, (String)"getImportBarcodeIsbn(...)");
        boolean bl20 = bl19;
        Boolean bl21 = $this$toDomain.getScanForceModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)bl21, (String)"getScanForceModifiedTime(...)");
        boolean bl22 = bl21;
        Boolean bl23 = $this$toDomain.getScanCbx();
        Intrinsics.checkNotNullExpressionValue((Object)bl23, (String)"getScanCbx(...)");
        boolean bl24 = bl23;
        Boolean bl25 = $this$toDomain.getScanPdf();
        Intrinsics.checkNotNullExpressionValue((Object)bl25, (String)"getScanPdf(...)");
        boolean bl26 = bl25;
        Boolean bl27 = $this$toDomain.getScanEpub();
        Intrinsics.checkNotNullExpressionValue((Object)bl27, (String)"getScanEpub(...)");
        boolean bl28 = bl27;
        Boolean bl29 = $this$toDomain.getScanStartup();
        Intrinsics.checkNotNullExpressionValue((Object)bl29, (String)"getScanStartup(...)");
        boolean bl30 = bl29;
        String string3 = $this$toDomain.getScanInterval();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getScanInterval(...)");
        Library.ScanInterval scanInterval = Library.ScanInterval.valueOf((String)string3);
        Boolean bl31 = $this$toDomain.getRepairExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)bl31, (String)"getRepairExtensions(...)");
        boolean bl32 = bl31;
        Boolean bl33 = $this$toDomain.getConvertToCbz();
        Intrinsics.checkNotNullExpressionValue((Object)bl33, (String)"getConvertToCbz(...)");
        boolean bl34 = bl33;
        Boolean bl35 = $this$toDomain.getEmptyTrashAfterScan();
        Intrinsics.checkNotNullExpressionValue((Object)bl35, (String)"getEmptyTrashAfterScan(...)");
        boolean bl36 = bl35;
        String string4 = $this$toDomain.getSeriesCover();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSeriesCover(...)");
        Library.SeriesCover seriesCover = Library.SeriesCover.valueOf((String)string4);
        Boolean bl37 = $this$toDomain.getHashFiles();
        Intrinsics.checkNotNullExpressionValue((Object)bl37, (String)"getHashFiles(...)");
        boolean bl38 = bl37;
        Boolean bl39 = $this$toDomain.getHashPages();
        Intrinsics.checkNotNullExpressionValue((Object)bl39, (String)"getHashPages(...)");
        boolean bl40 = bl39;
        Boolean bl41 = $this$toDomain.getHashKoreader();
        Intrinsics.checkNotNullExpressionValue((Object)bl41, (String)"getHashKoreader(...)");
        boolean bl42 = bl41;
        Boolean bl43 = $this$toDomain.getAnalyzeDimensions();
        Intrinsics.checkNotNullExpressionValue((Object)bl43, (String)"getAnalyzeDimensions(...)");
        boolean bl44 = bl43;
        String string5 = $this$toDomain.getOneshotsDirectory();
        LocalDateTime localDateTime = $this$toDomain.getUnavailableDate();
        String string6 = $this$toDomain.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getId(...)");
        String string7 = string6;
        LocalDateTime localDateTime2 = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime3 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime2);
        LocalDateTime localDateTime4 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime4, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime5 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime4);
        return new org.gotson.komga.domain.model.Library(string2, uRL, bl2, bl4, bl6, bl8, bl10, bl12, bl14, bl16, bl18, bl20, bl22, bl30, scanInterval, bl24, bl26, bl28, directoryExclusions, bl32, bl34, bl36, seriesCover, bl38, bl40, bl42, bl44, string5, localDateTime, string7, localDateTime3, localDateTime5);
    }

    public static final /* synthetic */ Library access$getL$p(LibraryDao $this) {
        return $this.l;
    }

    public static final /* synthetic */ LibraryExclusions access$getLe$p(LibraryDao $this) {
        return $this.le;
    }
}

