/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.main.ReadProgressDtoDao;
import org.gotson.komga.interfaces.api.persistence.ReadProgressDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.TachiyomiReadProgressV2Dto;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Book;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.ReadProgress;
import org.gotson.komga.jooq.main.tables.ReadlistBook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.AggregateFunction;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002:\u00011B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u001d\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0012J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0012J \u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0012J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0019H\u0012J+\u0010+\u001a\u0004\u0018\u0001H,\"\u0004\b\u0000\u0010,*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020/0.0-H\u0012\u00a2\u0006\u0002\u00100R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/ReadProgressDtoDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/interfaces/api/persistence/ReadProgressDtoRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;)V", "rlb", "Lorg/gotson/komga/jooq/main/tables/ReadlistBook;", "kotlin.jvm.PlatformType", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "r", "Lorg/gotson/komga/jooq/main/tables/ReadProgress;", "countUnread", "Lorg/jooq/AggregateFunction;", "Ljava/math/BigDecimal;", "countRead", "countInProgress", "findProgressV2BySeries", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressV2Dto;", "seriesId", "", "userId", "getSeriesBooksCount", "Lorg/gotson/komga/infrastructure/jooq/main/ReadProgressDtoDao$BooksCount;", "Lorg/jetbrains/annotations/NotNull;", "findProgressByReadList", "Lorg/gotson/komga/interfaces/api/rest/dto/TachiyomiReadProgressDto;", "readListId", "booksCountToDto", "booksCount", "lastReadContinuousIndex", "", "booksCountToDtoV2", "lastReadContinuousNumberSort", "", "maxNumberSort", "readProgressCondition", "Lorg/jooq/Condition;", "lastRead", "T", "", "Lorg/jooq/Record2;", "", "(Ljava/util/List;)Ljava/lang/Object;", "BooksCount", "komga"})
@SourceDebugExtension(value={"SMAP\nReadProgressDtoDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadProgressDtoDao.kt\norg/gotson/komga/infrastructure/jooq/main/ReadProgressDtoDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n967#2,7:178\n*S KotlinDebug\n*F\n+ 1 ReadProgressDtoDao.kt\norg/gotson/komga/infrastructure/jooq/main/ReadProgressDtoDao\n*L\n164#1:178,7\n*E\n"})
public class ReadProgressDtoDao
extends SplitDslDaoBase
implements ReadProgressDtoRepository {
    private final ReadlistBook rlb;
    private final Book b;
    private final BookMetadata d;
    private final ReadProgress r;
    @NotNull
    private final AggregateFunction<BigDecimal> countUnread;
    @NotNull
    private final AggregateFunction<BigDecimal> countRead;
    @NotNull
    private final AggregateFunction<BigDecimal> countInProgress;

    public ReadProgressDtoDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.rlb = Tables.READLIST_BOOK;
        this.b = Tables.BOOK;
        this.d = Tables.BOOK_METADATA;
        this.r = Tables.READ_PROGRESS;
        AggregateFunction aggregateFunction = DSL.sum((Field)DSL.when((Condition)this.r.COMPLETED.isNull(), (Object)1).otherwise((Object)0));
        Intrinsics.checkNotNullExpressionValue((Object)aggregateFunction, (String)"sum(...)");
        this.countUnread = aggregateFunction;
        AggregateFunction aggregateFunction2 = DSL.sum((Field)DSL.when((Condition)this.r.COMPLETED.isTrue(), (Object)1).otherwise((Object)0));
        Intrinsics.checkNotNullExpressionValue((Object)aggregateFunction2, (String)"sum(...)");
        this.countRead = aggregateFunction2;
        AggregateFunction aggregateFunction3 = DSL.sum((Field)DSL.when((Condition)this.r.COMPLETED.isFalse(), (Object)1).otherwise((Object)0));
        Intrinsics.checkNotNullExpressionValue((Object)aggregateFunction3, (String)"sum(...)");
        this.countInProgress = aggregateFunction3;
    }

    @NotNull
    public TachiyomiReadProgressV2Dto findProgressV2BySeries(@NotNull String seriesId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Result result = this.getDslRO().select((SelectField)this.d.NUMBER_SORT, (SelectField)this.r.COMPLETED).from((TableLike)this.b).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.SERIES_ID.eq((Object)seriesId)).orderBy((OrderField)this.d.NUMBER_SORT).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        List numberSortReadProgress = CollectionsKt.toList((Iterable)((Iterable)result));
        Float f = (Float)this.getDslRO().select((SelectField)DSL.max((Field)((Field)this.d.NUMBER_SORT))).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.SERIES_ID.eq((Object)seriesId)).fetchOne((Field)DSL.max((Field)((Field)this.d.NUMBER_SORT)));
        float maxNumberSort = f != null ? f.floatValue() : 0.0f;
        BooksCount booksCount = this.getSeriesBooksCount(seriesId, userId);
        Float f2 = (Float)this.lastRead(numberSortReadProgress);
        return this.booksCountToDtoV2(booksCount, f2 != null ? f2.floatValue() : 0.0f, maxNumberSort);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ReadProgressDtoDao.BooksCount getSeriesBooksCount(String seriesId, String userId) {
        SelectFieldOrAsterisk[] selectFieldOrAsteriskArray = new SelectFieldOrAsterisk[]{this.countRead.as("booksReadCount")};
        SelectSelectStep selectSelectStep = this.getDslRO().select((SelectField)this.countUnread.as("booksUnreadCount")).select(selectFieldOrAsteriskArray);
        selectFieldOrAsteriskArray = new SelectFieldOrAsterisk[]{this.countInProgress.as("booksInProgressCount")};
        Result result = selectSelectStep.select(selectFieldOrAsteriskArray).from((TableLike)this.b).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).where(this.b.SERIES_ID.eq((Object)seriesId)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        Object object = ((Record)CollectionsKt.first((List)((List)result))).map(ReadProgressDtoDao::getSeriesBooksCount$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map(...)");
        return (BooksCount)object;
    }

    @NotNull
    public TachiyomiReadProgressDto findProgressByReadList(@NotNull String readListId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)readListId, (String)"readListId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        OrderField[] orderFieldArray = new OrderField[]{this.rlb.NUMBER};
        Result result = this.getDslRO().select((SelectField)DSL.rowNumber().over().orderBy(orderFieldArray), (SelectField)this.r.COMPLETED).from((TableLike)this.b).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID)).where(this.rlb.READLIST_ID.eq((Object)readListId)).orderBy((OrderField)this.rlb.NUMBER).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        List indexedReadProgress = CollectionsKt.toList((Iterable)((Iterable)result));
        SelectFieldOrAsterisk[] selectFieldOrAsteriskArray = new SelectFieldOrAsterisk[]{this.countRead.as("booksReadCount")};
        SelectSelectStep selectSelectStep = this.getDslRO().select((SelectField)this.countUnread.as("booksUnreadCount")).select(selectFieldOrAsteriskArray);
        selectFieldOrAsteriskArray = new SelectFieldOrAsterisk[]{this.countInProgress.as("booksInProgressCount")};
        Result result2 = selectSelectStep.select(selectFieldOrAsteriskArray).from((TableLike)this.b).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID)).where(this.rlb.READLIST_ID.eq((Object)readListId)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"fetch(...)");
        Record booksCountRecord = (Record)CollectionsKt.first((List)((List)result2));
        Object object = booksCountRecord.get("booksUnreadCount", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int n = ((Number)object).intValue();
        Object object2 = booksCountRecord.get("booksReadCount", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int n2 = ((Number)object2).intValue();
        Object object3 = booksCountRecord.get("booksInProgressCount", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        BooksCount booksCount = new BooksCount(n, n2, ((Number)object3).intValue());
        Integer n3 = (Integer)this.lastRead(indexedReadProgress);
        return this.booksCountToDto(booksCount, n3 != null ? n3 : 0);
    }

    private TachiyomiReadProgressDto booksCountToDto(BooksCount booksCount, int lastReadContinuousIndex) {
        int n = booksCount.getTotalCount();
        int n2 = booksCount.getUnreadCount();
        int n3 = booksCount.getInProgressCount();
        int n4 = booksCount.getReadCount();
        return new TachiyomiReadProgressDto(n, n4, n2, n3, lastReadContinuousIndex);
    }

    private TachiyomiReadProgressV2Dto booksCountToDtoV2(BooksCount booksCount, float lastReadContinuousNumberSort, float maxNumberSort) {
        int n = booksCount.getTotalCount();
        int n2 = booksCount.getUnreadCount();
        int n3 = booksCount.getInProgressCount();
        int n4 = booksCount.getReadCount();
        return new TachiyomiReadProgressV2Dto(n, n4, n2, n3, lastReadContinuousNumberSort, maxNumberSort);
    }

    private Condition readProgressCondition(String userId) {
        Condition condition = this.r.USER_ID.eq((Object)userId).or(this.r.USER_ID.isNull());
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"or(...)");
        return condition;
    }

    private <T> T lastRead(List<? extends Record2<T, Boolean>> $this$lastRead) {
        Record2 record2;
        Iterable $this$takeWhile$iv = $this$lastRead;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Record2 it = (Record2)item$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.component2(), (Object)true)) break;
            list$iv.add(item$iv);
        }
        return (T)((record2 = (Record2)CollectionsKt.lastOrNull((List)list$iv)) != null ? record2.component1() : null);
    }

    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ReadProgressDtoDao.BooksCount getSeriesBooksCount$lambda$0(Record it) {
        Object object = it.get("booksUnreadCount", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int n = ((Number)object).intValue();
        Object object2 = it.get("booksReadCount", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int n2 = ((Number)object2).intValue();
        Object object3 = it.get("booksInProgressCount", Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        return new BooksCount(n, n2, ((Number)object3).intValue());
    }
}

