/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.io.Closeable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.model.AlternateTitle;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.WebLink;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.TempTable;
import org.gotson.komga.infrastructure.jooq.main.SeriesMetadataDao;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.SeriesMetadata;
import org.gotson.komga.jooq.main.tables.SeriesMetadataAlternateTitle;
import org.gotson.komga.jooq.main.tables.SeriesMetadataGenre;
import org.gotson.komga.jooq.main.tables.SeriesMetadataLink;
import org.gotson.komga.jooq.main.tables.SeriesMetadataSharing;
import org.gotson.komga.jooq.main.tables.SeriesMetadataTag;
import org.gotson.komga.jooq.main.tables.records.SeriesMetadataRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.RecordMapper;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001b\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001e*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J@\u0010\u001f\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a0\"\u00a2\u0006\u0002\b!0 \u00a2\u0006\u0002\b!*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J@\u0010#\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a0\"\u00a2\u0006\u0002\b!0 \u00a2\u0006\u0002\b!*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J@\u0010$\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u001a0\u001a0\"\u00a2\u0006\u0002\b!0 \u00a2\u0006\u0002\b!*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J@\u0010%\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010'0' \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010'0'0(\u00a2\u0006\u0002\b!0&\u00a2\u0006\u0002\b!*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J@\u0010)\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010*0* \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010*0*0(\u00a2\u0006\u0002\b!0&\u00a2\u0006\u0002\b!*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0018H\u0017J\u0010\u0010.\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0018H\u0017J\u0014\u0010/\u001a\u00020,*\u00020\u00042\u0006\u0010-\u001a\u00020\u0018H\u0012J\u0014\u00100\u001a\u00020,*\u00020\u00042\u0006\u0010-\u001a\u00020\u0018H\u0012J\u0014\u00101\u001a\u00020,*\u00020\u00042\u0006\u0010-\u001a\u00020\u0018H\u0012J\u0014\u00102\u001a\u00020,*\u00020\u00042\u0006\u0010-\u001a\u00020\u0018H\u0012J\u0014\u00103\u001a\u00020,*\u00020\u00042\u0006\u0010-\u001a\u00020\u0018H\u0012J\u0010\u00104\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0016\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001a06H\u0017J\b\u00107\u001a\u000208H\u0016JR\u00109\u001a\u00020\u0018*\u00020\u001d2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020'0(2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020*0(H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u00160\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/SeriesMetadataDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "batchSize", "", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;I)V", "d", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadata;", "kotlin.jvm.PlatformType", "g", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadataGenre;", "st", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadataTag;", "sl", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadataSharing;", "slk", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadataLink;", "sat", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadataAlternateTitle;", "findById", "Lorg/gotson/komga/domain/model/SeriesMetadata;", "seriesId", "", "findByIdOrNull", "findOne", "Lorg/gotson/komga/jooq/main/tables/records/SeriesMetadataRecord;", "Lorg/jetbrains/annotations/Nullable;", "findGenres", "", "Lorg/jetbrains/annotations/NotNull;", "", "findTags", "findSharingLabels", "findLinks", "", "Lorg/gotson/komga/domain/model/WebLink;", "", "findAlternateTitles", "Lorg/gotson/komga/domain/model/AlternateTitle;", "insert", "", "metadata", "update", "insertGenres", "insertTags", "insertSharingLabels", "insertLinks", "insertAlternateTitles", "delete", "seriesIds", "", "count", "", "toDomain", "genres", "tags", "sharingLabels", "links", "alternateTitles", "komga"})
@SourceDebugExtension(value={"SMAP\nSeriesMetadataDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesMetadataDao.kt\norg/gotson/komga/infrastructure/jooq/main/SeriesMetadataDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n1869#2:335\n1869#2,2:336\n1870#2:338\n1869#2:339\n1869#2,2:340\n1870#2:342\n1869#2:343\n1869#2,2:344\n1870#2:346\n1869#2:347\n1869#2,2:348\n1870#2:350\n1869#2:351\n1869#2,2:352\n1870#2:354\n*S KotlinDebug\n*F\n+ 1 SeriesMetadataDao.kt\norg/gotson/komga/infrastructure/jooq/main/SeriesMetadataDao\n*L\n184#1:335\n191#1:336,2\n184#1:338\n201#1:339\n208#1:340,2\n201#1:342\n218#1:343\n225#1:344,2\n218#1:346\n235#1:347\n242#1:348,2\n235#1:350\n252#1:351\n259#1:352,2\n252#1:354\n*E\n"})
public class SeriesMetadataDao
extends SplitDslDaoBase
implements SeriesMetadataRepository {
    private final int batchSize;
    private final SeriesMetadata d;
    private final SeriesMetadataGenre g;
    private final SeriesMetadataTag st;
    private final SeriesMetadataSharing sl;
    private final SeriesMetadataLink slk;
    private final SeriesMetadataAlternateTitle sat;

    public SeriesMetadataDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        super(dslRW, dslRO);
        this.batchSize = batchSize;
        this.d = Tables.SERIES_METADATA;
        this.g = Tables.SERIES_METADATA_GENRE;
        this.st = Tables.SERIES_METADATA_TAG;
        this.sl = Tables.SERIES_METADATA_SHARING;
        this.slk = Tables.SERIES_METADATA_LINK;
        this.sat = Tables.SERIES_METADATA_ALTERNATE_TITLE;
    }

    @NotNull
    public org.gotson.komga.domain.model.SeriesMetadata findById(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        SeriesMetadataRecord seriesMetadataRecord = this.findOne(this.getDslRO(), seriesId);
        Intrinsics.checkNotNull((Object)seriesMetadataRecord);
        return this.toDomain(seriesMetadataRecord, this.findGenres(this.getDslRO(), seriesId), this.findTags(this.getDslRO(), seriesId), this.findSharingLabels(this.getDslRO(), seriesId), this.findLinks(this.getDslRO(), seriesId), this.findAlternateTitles(this.getDslRO(), seriesId));
    }

    @Nullable
    public org.gotson.komga.domain.model.SeriesMetadata findByIdOrNull(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        SeriesMetadataRecord seriesMetadataRecord = this.findOne(this.getDslRO(), seriesId);
        return seriesMetadataRecord != null ? this.toDomain(seriesMetadataRecord, this.findGenres(this.getDslRO(), seriesId), this.findTags(this.getDslRO(), seriesId), this.findSharingLabels(this.getDslRO(), seriesId), this.findLinks(this.getDslRO(), seriesId), this.findAlternateTitles(this.getDslRO(), seriesId)) : null;
    }

    private @Nullable SeriesMetadataRecord findOne(DSLContext $this$findOne, String seriesId) {
        return (SeriesMetadataRecord)$this$findOne.selectFrom((TableLike)this.d).where(this.d.SERIES_ID.eq((Object)seriesId)).fetchOneInto((Table)this.d);
    }

    private @NotNull Set<String> findGenres(DSLContext $this$findGenres, String seriesId) {
        Set set = $this$findGenres.select((SelectField)this.g.GENRE).from((TableLike)this.g).where(this.g.SERIES_ID.eq((Object)seriesId)).fetchSet((Field)this.g.GENRE);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    private @NotNull Set<String> findTags(DSLContext $this$findTags, String seriesId) {
        Set set = $this$findTags.select((SelectField)this.st.TAG).from((TableLike)this.st).where(this.st.SERIES_ID.eq((Object)seriesId)).fetchSet((Field)this.st.TAG);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    private @NotNull Set<String> findSharingLabels(DSLContext $this$findSharingLabels, String seriesId) {
        Set set = $this$findSharingLabels.select((SelectField)this.sl.LABEL).from((TableLike)this.sl).where(this.sl.SERIES_ID.eq((Object)seriesId)).fetchSet((Field)this.sl.LABEL);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fetchSet(...)");
        return set;
    }

    private @NotNull List<WebLink> findLinks(DSLContext $this$findLinks, String seriesId) {
        List list = $this$findLinks.select((SelectField)this.slk.LABEL, (SelectField)this.slk.URL).from((TableLike)this.slk).where(this.slk.SERIES_ID.eq((Object)seriesId)).fetchInto((Table)this.slk).map((RecordMapper)findLinks.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    private @NotNull List<AlternateTitle> findAlternateTitles(DSLContext $this$findAlternateTitles, String seriesId) {
        List list = $this$findAlternateTitles.select((SelectField)this.sat.LABEL, (SelectField)this.sat.TITLE).from((TableLike)this.sat).where(this.sat.SERIES_ID.eq((Object)seriesId)).fetchInto((Table)this.sat).map((RecordMapper)findAlternateTitles.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    @Transactional
    public void insert(@NotNull org.gotson.komga.domain.model.SeriesMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        SeriesMetadata.ReadingDirection readingDirection = metadata.getReadingDirection();
        this.getDslRW().insertInto((Table)this.d).set((Field)this.d.SERIES_ID, (Object)metadata.getSeriesId()).set((Field)this.d.STATUS, (Object)metadata.getStatus().toString()).set((Field)this.d.TITLE, (Object)metadata.getTitle()).set((Field)this.d.TITLE_SORT, (Object)metadata.getTitleSort()).set((Field)this.d.SUMMARY, (Object)metadata.getSummary()).set((Field)this.d.READING_DIRECTION, (Object)(readingDirection != null ? readingDirection.toString() : null)).set((Field)this.d.PUBLISHER, (Object)metadata.getPublisher()).set((Field)this.d.AGE_RATING, (Object)metadata.getAgeRating()).set((Field)this.d.LANGUAGE, (Object)metadata.getLanguage()).set((Field)this.d.STATUS_LOCK, (Object)metadata.getStatusLock()).set((Field)this.d.TITLE_LOCK, (Object)metadata.getTitleLock()).set((Field)this.d.TITLE_SORT_LOCK, (Object)metadata.getTitleSortLock()).set((Field)this.d.SUMMARY_LOCK, (Object)metadata.getSummaryLock()).set((Field)this.d.READING_DIRECTION_LOCK, (Object)metadata.getReadingDirectionLock()).set((Field)this.d.PUBLISHER_LOCK, (Object)metadata.getPublisherLock()).set((Field)this.d.AGE_RATING_LOCK, (Object)metadata.getAgeRatingLock()).set((Field)this.d.LANGUAGE_LOCK, (Object)metadata.getLanguageLock()).set((Field)this.d.GENRES_LOCK, (Object)metadata.getGenresLock()).set((Field)this.d.TAGS_LOCK, (Object)metadata.getTagsLock()).set((Field)this.d.TOTAL_BOOK_COUNT, (Object)metadata.getTotalBookCount()).set((Field)this.d.TOTAL_BOOK_COUNT_LOCK, (Object)metadata.getTotalBookCountLock()).set((Field)this.d.SHARING_LABELS_LOCK, (Object)metadata.getSharingLabelsLock()).set((Field)this.d.LINKS_LOCK, (Object)metadata.getLinksLock()).set((Field)this.d.ALTERNATE_TITLES_LOCK, (Object)metadata.getAlternateTitlesLock()).execute();
        this.insertGenres(this.getDslRW(), metadata);
        this.insertTags(this.getDslRW(), metadata);
        this.insertSharingLabels(this.getDslRW(), metadata);
        this.insertLinks(this.getDslRW(), metadata);
        this.insertAlternateTitles(this.getDslRW(), metadata);
    }

    @Transactional
    public void update(@NotNull org.gotson.komga.domain.model.SeriesMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        SeriesMetadata.ReadingDirection readingDirection = metadata.getReadingDirection();
        this.getDslRW().update((Table)this.d).set((Field)this.d.STATUS, (Object)metadata.getStatus().toString()).set((Field)this.d.TITLE, (Object)metadata.getTitle()).set((Field)this.d.TITLE_SORT, (Object)metadata.getTitleSort()).set((Field)this.d.SUMMARY, (Object)metadata.getSummary()).set((Field)this.d.READING_DIRECTION, (Object)(readingDirection != null ? readingDirection.toString() : null)).set((Field)this.d.PUBLISHER, (Object)metadata.getPublisher()).set((Field)this.d.AGE_RATING, (Object)metadata.getAgeRating()).set((Field)this.d.LANGUAGE, (Object)metadata.getLanguage()).set((Field)this.d.STATUS_LOCK, (Object)metadata.getStatusLock()).set((Field)this.d.TITLE_LOCK, (Object)metadata.getTitleLock()).set((Field)this.d.TITLE_SORT_LOCK, (Object)metadata.getTitleSortLock()).set((Field)this.d.SUMMARY_LOCK, (Object)metadata.getSummaryLock()).set((Field)this.d.READING_DIRECTION_LOCK, (Object)metadata.getReadingDirectionLock()).set((Field)this.d.PUBLISHER_LOCK, (Object)metadata.getPublisherLock()).set((Field)this.d.AGE_RATING_LOCK, (Object)metadata.getAgeRatingLock()).set((Field)this.d.LANGUAGE_LOCK, (Object)metadata.getLanguageLock()).set((Field)this.d.GENRES_LOCK, (Object)metadata.getGenresLock()).set((Field)this.d.TAGS_LOCK, (Object)metadata.getTagsLock()).set((Field)this.d.TOTAL_BOOK_COUNT, (Object)metadata.getTotalBookCount()).set((Field)this.d.TOTAL_BOOK_COUNT_LOCK, (Object)metadata.getTotalBookCountLock()).set((Field)this.d.SHARING_LABELS_LOCK, (Object)metadata.getSharingLabelsLock()).set((Field)this.d.LINKS_LOCK, (Object)metadata.getLinksLock()).set((Field)this.d.ALTERNATE_TITLES_LOCK, (Object)metadata.getAlternateTitlesLock()).set((Field)this.d.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z"))).where(this.d.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.g).where(this.g.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.st).where(this.st.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.sl).where(this.sl.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.slk).where(this.slk.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.getDslRW().deleteFrom((Table)this.sat).where(this.sat.SERIES_ID.eq((Object)metadata.getSeriesId())).execute();
        this.insertGenres(this.getDslRW(), metadata);
        this.insertTags(this.getDslRW(), metadata);
        this.insertSharingLabels(this.getDslRW(), metadata);
        this.insertLinks(this.getDslRW(), metadata);
        this.insertAlternateTitles(this.getDslRW(), metadata);
    }

    private void insertGenres(DSLContext $this$insertGenres, org.gotson.komga.domain.model.SeriesMetadata metadata) {
        if (!((Collection)metadata.getGenres()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getGenres(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertGenres.batch((Query)$this$insertGenres.insertInto((Table)this.g, (Field)this.g.SERIES_ID, (Field)this.g.GENRE).values(null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertTags(DSLContext $this$insertTags, org.gotson.komga.domain.model.SeriesMetadata metadata) {
        if (!((Collection)metadata.getTags()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getTags(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertTags.batch((Query)$this$insertTags.insertInto((Table)this.st, (Field)this.st.SERIES_ID, (Field)this.st.TAG).values(null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertSharingLabels(DSLContext $this$insertSharingLabels, org.gotson.komga.domain.model.SeriesMetadata metadata) {
        if (!((Collection)metadata.getSharingLabels()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getSharingLabels(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertSharingLabels.batch((Query)$this$insertSharingLabels.insertInto((Table)this.sl, (Field)this.sl.SERIES_ID, (Field)this.sl.LABEL).values(null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertLinks(DSLContext $this$insertLinks, org.gotson.komga.domain.model.SeriesMetadata metadata) {
        if (!((Collection)metadata.getLinks()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getLinks(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertLinks.batch((Query)$this$insertLinks.insertInto((Table)this.slk, (Field)this.slk.SERIES_ID, (Field)this.slk.LABEL, (Field)this.slk.URL).values(null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    WebLink it = (WebLink)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it.getLabel(), it.getUrl().toString()};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    private void insertAlternateTitles(DSLContext $this$insertAlternateTitles, org.gotson.komga.domain.model.SeriesMetadata metadata) {
        if (!((Collection)metadata.getAlternateTitles()).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)metadata.getAlternateTitles(), (int)this.batchSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BatchBindStep batchBindStep;
                List chunk = (List)element$iv;
                boolean bl = false;
                BatchBindStep step = batchBindStep = $this$insertAlternateTitles.batch((Query)$this$insertAlternateTitles.insertInto((Table)this.sat, (Field)this.sat.SERIES_ID, (Field)this.sat.LABEL, (Field)this.sat.TITLE).values(null, null, null));
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AlternateTitle it = (AlternateTitle)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{metadata.getSeriesId(), it.getLabel(), it.getTitle()};
                    step.bind(objectArray);
                }
                batchBindStep.execute();
            }
        }
    }

    @Transactional
    public void delete(@NotNull String seriesId) {
        Intrinsics.checkNotNullParameter((Object)seriesId, (String)"seriesId");
        this.getDslRW().deleteFrom((Table)this.g).where(this.g.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.st).where(this.st.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.sl).where(this.sl.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.slk).where(this.slk.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.sat).where(this.sat.SERIES_ID.eq((Object)seriesId)).execute();
        this.getDslRW().deleteFrom((Table)this.d).where(this.d.SERIES_ID.eq((Object)seriesId)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void delete(@NotNull Collection<String> seriesIds) {
        Intrinsics.checkNotNullParameter(seriesIds, (String)"seriesIds");
        Closeable closeable = (Closeable)TempTable.Companion.withTempTable(this.getDslRW(), this.batchSize, seriesIds);
        Throwable throwable = null;
        try {
            TempTable it = (TempTable)closeable;
            boolean bl = false;
            this.getDslRW().deleteFrom((Table)this.g).where(this.g.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            this.getDslRW().deleteFrom((Table)this.st).where(this.st.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            this.getDslRW().deleteFrom((Table)this.sl).where(this.sl.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            this.getDslRW().deleteFrom((Table)this.slk).where(this.slk.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            this.getDslRW().deleteFrom((Table)this.sat).where(this.sat.SERIES_ID.in((Select)it.selectTempStrings())).execute();
            int n = this.getDslRW().deleteFrom((Table)this.d).where(this.d.SERIES_ID.in((Select)it.selectTempStrings())).execute();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public long count() {
        return this.getDslRO().fetchCount((Table)this.d);
    }

    private org.gotson.komga.domain.model.SeriesMetadata toDomain(SeriesMetadataRecord $this$toDomain, Set<String> genres, Set<String> tags, Set<String> sharingLabels, List<WebLink> links, List<AlternateTitle> alternateTitles) {
        SeriesMetadata.ReadingDirection readingDirection;
        String string = $this$toDomain.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatus(...)");
        SeriesMetadata.Status status = SeriesMetadata.Status.valueOf((String)string);
        String string2 = $this$toDomain.getTitle();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
        String string4 = $this$toDomain.getTitleSort();
        String string5 = string4;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getTitleSort(...)");
        String string6 = $this$toDomain.getSummary();
        String string7 = string6;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getSummary(...)");
        String string8 = $this$toDomain.getReadingDirection();
        if (string8 != null) {
            String string9 = string8;
            String string10 = string7;
            String string11 = string5;
            String string12 = string3;
            SeriesMetadata.Status status2 = status;
            boolean bl = false;
            String string13 = $this$toDomain.getReadingDirection();
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getReadingDirection(...)");
            SeriesMetadata.ReadingDirection readingDirection2 = SeriesMetadata.ReadingDirection.valueOf((String)string13);
            status = status2;
            string3 = string12;
            string5 = string11;
            string7 = string10;
            readingDirection = readingDirection2;
        } else {
            readingDirection = null;
        }
        String string14 = $this$toDomain.getPublisher();
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"getPublisher(...)");
        Integer n = $this$toDomain.getAgeRating();
        String string15 = $this$toDomain.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getLanguage(...)");
        Integer n2 = $this$toDomain.getTotalBookCount();
        Boolean bl = $this$toDomain.getStatusLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getStatusLock(...)");
        boolean bl2 = bl;
        Boolean bl3 = $this$toDomain.getTitleLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"getTitleLock(...)");
        boolean bl4 = bl3;
        Boolean bl5 = $this$toDomain.getTitleSortLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"getTitleSortLock(...)");
        boolean bl6 = bl5;
        Boolean bl7 = $this$toDomain.getSummaryLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl7, (String)"getSummaryLock(...)");
        boolean bl8 = bl7;
        Boolean bl9 = $this$toDomain.getReadingDirectionLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"getReadingDirectionLock(...)");
        boolean bl10 = bl9;
        Boolean bl11 = $this$toDomain.getPublisherLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl11, (String)"getPublisherLock(...)");
        boolean bl12 = bl11;
        Boolean bl13 = $this$toDomain.getAgeRatingLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl13, (String)"getAgeRatingLock(...)");
        boolean bl14 = bl13;
        Boolean bl15 = $this$toDomain.getLanguageLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl15, (String)"getLanguageLock(...)");
        boolean bl16 = bl15;
        Boolean bl17 = $this$toDomain.getGenresLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl17, (String)"getGenresLock(...)");
        boolean bl18 = bl17;
        Boolean bl19 = $this$toDomain.getTagsLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl19, (String)"getTagsLock(...)");
        boolean bl20 = bl19;
        Boolean bl21 = $this$toDomain.getTotalBookCountLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl21, (String)"getTotalBookCountLock(...)");
        boolean bl22 = bl21;
        Boolean bl23 = $this$toDomain.getSharingLabelsLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl23, (String)"getSharingLabelsLock(...)");
        boolean bl24 = bl23;
        Boolean bl25 = $this$toDomain.getLinksLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl25, (String)"getLinksLock(...)");
        boolean bl26 = bl25;
        Boolean bl27 = $this$toDomain.getAlternateTitlesLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl27, (String)"getAlternateTitlesLock(...)");
        boolean bl28 = bl27;
        String string16 = $this$toDomain.getSeriesId();
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"getSeriesId(...)");
        LocalDateTime localDateTime = $this$toDomain.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime);
        LocalDateTime localDateTime3 = $this$toDomain.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toCurrentTimeZone((LocalDateTime)localDateTime3);
        LocalDateTime localDateTime5 = localDateTime2;
        String string17 = string16;
        boolean bl29 = bl28;
        boolean bl30 = bl26;
        boolean bl31 = bl24;
        boolean bl32 = bl22;
        boolean bl33 = bl20;
        boolean bl34 = bl18;
        boolean bl35 = bl16;
        boolean bl36 = bl14;
        boolean bl37 = bl12;
        boolean bl38 = bl10;
        boolean bl39 = bl8;
        boolean bl40 = bl6;
        boolean bl41 = bl4;
        boolean bl42 = bl2;
        List<AlternateTitle> list = alternateTitles;
        List<WebLink> list2 = links;
        Set<String> set = sharingLabels;
        Integer n3 = n2;
        Set<String> set2 = tags;
        Set<String> set3 = genres;
        String string18 = string15;
        Integer n4 = n;
        String string19 = string14;
        SeriesMetadata.ReadingDirection readingDirection3 = readingDirection;
        String string20 = string7;
        String string21 = string5;
        String string22 = string3;
        SeriesMetadata.Status status3 = status;
        return new org.gotson.komga.domain.model.SeriesMetadata(status3, string22, string21, string20, readingDirection3, string19, n4, string18, set3, set2, n3, set, list2, list, bl42, bl41, bl40, bl39, bl38, bl37, bl36, bl35, bl34, bl33, bl32, bl31, bl30, bl29, string17, localDateTime5, localDateTime4);
    }
}

