/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gotson.komga.application.tasks.Task;
import org.gotson.komga.application.tasks.TasksRepository;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.tasks.TasksDaoKt;
import org.gotson.komga.jooq.tasks.Tables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@DependsOn(value={"flywaySecondaryMigrationInitializer"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0016J\u001c\u0010\u001a\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00190\u001bH\u0016JW\u0010\u001c\u001aM\u0012D\u0012B\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00170\u0017 \u000e* \u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u001e0\u001e0\u001d\u00a2\u0006\u0002\b\u0011*\u00020\u0004H\u0012J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001eH\u0012J\b\u0010 \u001a\u00020\u0007H\u0016J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u001bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0016\u0010\"\u001a\u00020#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&H\u0016J\b\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0017H\u0016J\b\u0010*\u001a\u00020#H\u0016J\b\u0010+\u001a\u00020\u0007H\u0016J\u0014\u0010,\u001a\u00020-*\u00020\u00152\u0006\u0010.\u001a\u00020\u0004H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gotson/komga/infrastructure/jooq/tasks/TasksDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/application/tasks/TasksRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "batchSize", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;ILcom/fasterxml/jackson/databind/ObjectMapper;)V", "t", "Lorg/gotson/komga/jooq/tasks/tables/Task;", "kotlin.jvm.PlatformType", "tasksAvailableCondition", "Lorg/jooq/Condition;", "Lorg/jetbrains/annotations/NotNull;", "hasAvailable", "", "takeFirst", "Lorg/gotson/komga/application/tasks/Task;", "owner", "", "findAll", "", "findAllGroupedByOwner", "", "selectBase", "Lorg/jooq/SelectJoinStep;", "Lorg/jooq/Record2;", "toDomain", "count", "countBySimpleType", "save", "", "task", "tasks", "", "disown", "delete", "taskId", "deleteAll", "deleteAllWithoutOwner", "toQuery", "Lorg/jooq/Query;", "dsl", "komga"})
@SourceDebugExtension(value={"SMAP\nTasksDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDao.kt\norg/gotson/komga/infrastructure/jooq/tasks/TasksDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,171:1\n1617#2,9:172\n1869#2:181\n1870#2:183\n1626#2:184\n1617#2,9:185\n1869#2:194\n1870#2:197\n1626#2:198\n1504#2:199\n1534#2,3:200\n1537#2,3:210\n1193#2,2:213\n1267#2,4:215\n1563#2:219\n1634#2,3:220\n1869#2,2:223\n1#3:182\n1#3:195\n1#3:196\n382#4,7:203\n*S KotlinDebug\n*F\n+ 1 TasksDao.kt\norg/gotson/komga/infrastructure/jooq/tasks/TasksDao\n*L\n84#1:172,9\n84#1:181\n84#1:183\n84#1:184\n91#1:185,9\n91#1:194\n91#1:197\n91#1:198\n93#1:199\n93#1:200,3\n93#1:210,3\n116#1:213,2\n116#1:215,4\n124#1:219\n124#1:220,3\n126#1:223,2\n84#1:182\n91#1:196\n93#1:203,7\n*E\n"})
public class TasksDao
extends SplitDslDaoBase
implements TasksRepository {
    private final int batchSize;
    @NotNull
    private final ObjectMapper objectMapper;
    private final org.gotson.komga.jooq.tasks.tables.Task t;
    @NotNull
    private final Condition tasksAvailableCondition;

    public TasksDao(@Qualifier(value="tasksDslContextRW") @NotNull DSLContext dslRW, @Qualifier(value="tasksDslContextRO") @NotNull DSLContext dslRO, @Value(value="#{@komgaProperties.tasksDb.batchChunkSize}") int batchSize, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        super(dslRW, dslRO);
        this.batchSize = batchSize;
        this.objectMapper = objectMapper;
        this.t = Tables.TASK;
        Condition condition = this.t.OWNER.isNull().and(this.t.GROUP_ID.notIn((Select)DSL.select((SelectField)((SelectField)this.t.GROUP_ID)).from((TableLike)this.t).where(this.t.OWNER.isNotNull()).and(this.t.GROUP_ID.isNotNull())).or(this.t.GROUP_ID.isNull()));
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(...)");
        this.tasksAvailableCondition = condition;
    }

    public boolean hasAvailable() {
        return this.getDslRO().fetchExists((Table)this.t, this.tasksAvailableCondition);
    }

    @Transactional
    @Nullable
    public Task takeFirst(@NotNull String owner) {
        Task task;
        block5: {
            block4: {
                Task task2;
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Record2 record2 = (Record2)this.selectBase(this.getDslRW()).where(this.tasksAvailableCondition).orderBy((OrderField)this.t.PRIORITY.desc(), (OrderField)this.t.LAST_MODIFIED_DATE).limit((Number)1).fetchOne();
                if (record2 == null) break block4;
                Record2 it = record2;
                boolean bl = false;
                try {
                    Object object = this.objectMapper.readValue((String)it.value2(), Class.forName((String)it.value1()));
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gotson.komga.application.tasks.Task");
                    task2 = (Task)object;
                }
                catch (Exception e) {
                    TasksDaoKt.access$getLogger$p().error((Throwable)e, () -> TasksDao.takeFirst$lambda$1$lambda$0(it));
                    task2 = null;
                }
                task = task2;
                if (task != null) break block5;
            }
            return null;
        }
        Task task3 = task;
        this.getDslRW().update((Table)this.t).set((Field)this.t.OWNER, (Object)owner).where(this.t.ID.eq((Object)task3.getUniqueId())).execute();
        return task3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Task> findAll() {
        void $this$mapNotNullTo$iv$iv;
        Result result = this.selectBase(this.getDslRO()).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = (Iterable)result;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Task it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Record2 it = (Record2)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.toDomain(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, List<Task>> findAllGroupedByOwner() {
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Result result = this.getDslRO().select((SelectField)this.t.OWNER, (SelectField)this.t.CLASS, (SelectField)this.t.PAYLOAD).from((TableLike)this.t).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = (Iterable)result;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Record3 it = (Record3)element$iv$iv;
            boolean bl2 = false;
            Record2 record2 = it.into((Field)this.t.CLASS, (Field)this.t.PAYLOAD);
            Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"into(...)");
            if (this.toDomain(record2) != null) {
                Task task;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)it.value1(), (Object)task);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-TasksDao$findAllGroupedByOwner$42 = false;
            String key$iv$iv = (String)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-TasksDao$findAllGroupedByOwner$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((Task)it.getSecond());
        }
        return destination$iv$iv;
    }

    private @NotNull SelectJoinStep<Record2<String, String>> selectBase(DSLContext $this$selectBase) {
        SelectJoinStep selectJoinStep = $this$selectBase.select((SelectField)this.t.CLASS, (SelectField)this.t.PAYLOAD).from((TableLike)this.t);
        Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep, (String)"from(...)");
        return selectJoinStep;
    }

    private Task toDomain(Record2<String, String> $this$toDomain) {
        Task task;
        try {
            Object object = this.objectMapper.readValue((String)$this$toDomain.value2(), Class.forName((String)$this$toDomain.value1()));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gotson.komga.application.tasks.Task");
            task = (Task)object;
        }
        catch (Exception e) {
            TasksDaoKt.access$getLogger$p().error((Throwable)e, () -> TasksDao.toDomain$lambda$7($this$toDomain));
            task = null;
        }
        return task;
    }

    public int count() {
        return this.getDslRO().fetchCount((Table)this.t);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Integer> countBySimpleType() {
        void $this$associateTo$iv$iv;
        GroupField[] groupFieldArray = new GroupField[]{this.t.SIMPLE_TYPE};
        Result result = this.getDslRO().select((SelectField)this.t.SIMPLE_TYPE, (SelectField)DSL.count((Field)((Field)this.t.SIMPLE_TYPE))).from((TableLike)this.t).groupBy(groupFieldArray).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        Iterable $this$associate$iv = (Iterable)result;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Record2 it = (Record2)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.value1(), (Object)it.value2());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public void save(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.toQuery(task, this.getDslRW()).execute();
    }

    /*
     * WARNING - void declaration
     */
    public void save(@NotNull Collection<? extends Task> tasks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Iterable $this$map$iv = tasks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Task task = (Task)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toQuery((Task)it, this.getDslRW()));
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)this.batchSize);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            this.getDslRW().batch((Collection)chunk).execute();
        }
    }

    public int disown() {
        return this.getDslRW().update((Table)this.t).set((Field)this.t.OWNER, null).where(this.t.OWNER.isNotNull()).execute();
    }

    public void delete(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this.getDslRW().deleteFrom((Table)this.t).where(this.t.ID.eq((Object)taskId)).execute();
    }

    public void deleteAll() {
        this.getDslRW().deleteFrom((Table)this.t).execute();
    }

    public int deleteAllWithoutOwner() {
        return this.getDslRW().deleteFrom((Table)this.t).where(this.t.OWNER.isNull()).execute();
    }

    private Query toQuery(Task $this$toQuery, DSLContext dsl) {
        InsertOnDuplicateSetMoreStep insertOnDuplicateSetMoreStep = dsl.insertInto((Table)this.t, (Field)this.t.ID, (Field)this.t.PRIORITY, (Field)this.t.GROUP_ID, (Field)this.t.CLASS, (Field)this.t.SIMPLE_TYPE, (Field)this.t.PAYLOAD).values((Object)$this$toQuery.getUniqueId(), (Object)$this$toQuery.getPriority(), (Object)$this$toQuery.getGroupId(), (Object)$this$toQuery.getClass().getTypeName(), (Object)$this$toQuery.getClass().getSimpleName(), (Object)this.objectMapper.writeValueAsString((Object)$this$toQuery)).onDuplicateKeyUpdate().set((Field)this.t.GROUP_ID, (Object)$this$toQuery.getGroupId()).set((Field)this.t.PRIORITY, (Object)$this$toQuery.getPriority()).set((Field)this.t.CLASS, (Object)$this$toQuery.getClass().getTypeName()).set((Field)this.t.SIMPLE_TYPE, (Object)$this$toQuery.getClass().getSimpleName()).set((Field)this.t.PAYLOAD, (Object)this.objectMapper.writeValueAsString((Object)$this$toQuery)).set((Field)this.t.LAST_MODIFIED_DATE, (Object)LocalDateTime.now(ZoneId.of("Z")));
        Intrinsics.checkNotNullExpressionValue((Object)insertOnDuplicateSetMoreStep, (String)"set(...)");
        return (Query)insertOnDuplicateSetMoreStep;
    }

    private static final Object takeFirst$lambda$1$lambda$0(@Nullable Record2 $it) {
        return "Could not deserialize object of type: " + $it.value1();
    }

    private static final Object toDomain$lambda$7(Record2 $this_toDomain) {
        return "Could not deserialize object of type: " + $this_toDomain.value1();
    }
}

