/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.kobo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.KomgaSyncToken;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGeneratorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR#\u0010\r\u001a\n \b*\u0004\u0018\u00010\u000e0\u000e8RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "base64Encoder", "Ljava/util/Base64$Encoder;", "kotlin.jvm.PlatformType", "getBase64Encoder", "()Ljava/util/Base64$Encoder;", "base64Encoder$delegate", "Lkotlin/Lazy;", "base64Decoder", "Ljava/util/Base64$Decoder;", "getBase64Decoder", "()Ljava/util/Base64$Decoder;", "base64Decoder$delegate", "fromBase64", "Lorg/gotson/komga/domain/model/KomgaSyncToken;", "base64Token", "", "toBase64", "token", "fromRequestHeaders", "request", "Ljakarta/servlet/http/HttpServletRequest;", "komga"})
@SourceDebugExtension(value={"SMAP\nKomgaSyncTokenGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KomgaSyncTokenGenerator.kt\norg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n139#2:67\n54#2:68\n140#2:69\n61#2,8:70\n71#2:79\n1#3:78\n*S KotlinDebug\n*F\n+ 1 KomgaSyncTokenGenerator.kt\norg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator\n*L\n34#1:67\n34#1:68\n34#1:69\n34#1:70,8\n34#1:79\n34#1:78\n*E\n"})
public class KomgaSyncTokenGenerator {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy base64Encoder$delegate;
    @NotNull
    private final Lazy base64Decoder$delegate;

    public KomgaSyncTokenGenerator(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
        this.base64Encoder$delegate = LazyKt.lazy(KomgaSyncTokenGenerator::base64Encoder_delegate$lambda$0);
        this.base64Decoder$delegate = LazyKt.lazy(KomgaSyncTokenGenerator::base64Decoder_delegate$lambda$1);
    }

    private Base64.Encoder getBase64Encoder() {
        Lazy lazy = this.base64Encoder$delegate;
        return (Base64.Encoder)lazy.getValue();
    }

    private Base64.Decoder getBase64Decoder() {
        Lazy lazy = this.base64Decoder$delegate;
        return (Base64.Decoder)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KomgaSyncToken fromBase64(@NotNull String base64Token) {
        Intrinsics.checkNotNullParameter((Object)base64Token, (String)"base64Token");
        try {
            if (StringsKt.startsWith$default((String)base64Token, (String)"KOMGA.", (boolean)false, (int)2, null)) {
                void $this$checkTypeMismatch$iv$iv;
                void $this$readValue$iv;
                ObjectMapper objectMapper = this.objectMapper;
                byte[] byArray = this.getBase64Decoder().decode(StringsKt.removePrefix((String)base64Token, (CharSequence)"KOMGA."));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                byte[] src$iv = byArray;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef22 = false;
                Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(src$iv, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                boolean $i$f$checkTypeMismatch = false;
                if (!($this$checkTypeMismatch$iv$iv instanceof KomgaSyncToken)) {
                    String string;
                    String nullability$iv$iv = "(non-null)";
                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(KomgaSyncToken.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                    void v2 = $this$checkTypeMismatch$iv$iv;
                    if (v2 != null) {
                        void it$iv$iv;
                        void var8_13 = v2;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                        stringBuilder = stringBuilder2;
                    } else {
                        string = null;
                    }
                    String string2 = stringBuilder.append(string).toString();
                    throw new RuntimeJsonMappingException(string2);
                }
                return (KomgaSyncToken)$this$checkTypeMismatch$iv$iv;
            }
            if (!StringsKt.contains$default((CharSequence)base64Token, (char)'.', (boolean)false, (int)2, null)) {
                try {
                    JsonNode json = this.objectMapper.readTree(this.getBase64Decoder().decode(base64Token));
                    String koboToken = json.get("data").get("raw_kobo_store_token").asText();
                    Intrinsics.checkNotNull((Object)koboToken);
                    return new KomgaSyncToken(0, koboToken, null, null, 13, null);
                }
                catch (Exception e) {
                    KomgaSyncTokenGeneratorKt.access$getLogger$p().warn(KomgaSyncTokenGenerator::fromBase64$lambda$2);
                }
            }
            if (StringsKt.contains$default((CharSequence)base64Token, (char)'.', (boolean)false, (int)2, null)) {
                return new KomgaSyncToken(0, base64Token, null, null, 13, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new KomgaSyncToken(0, null, null, null, 15, null);
    }

    @NotNull
    public String toBase64(@NotNull KomgaSyncToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Base64.Encoder encoder = this.getBase64Encoder();
        String string = this.objectMapper.writeValueAsString((Object)token);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return "KOMGA." + encoder.encodeToString(byArray);
    }

    @Nullable
    public KomgaSyncToken fromRequestHeaders(@NotNull HttpServletRequest request) {
        String syncTokenB64;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = syncTokenB64 = request.getHeader("x-kobo-synctoken");
        return string != null ? this.fromBase64(string) : null;
    }

    private static final Base64.Encoder base64Encoder_delegate$lambda$0() {
        return Base64.getEncoder().withoutPadding();
    }

    private static final Base64.Decoder base64Decoder_delegate$lambda$1() {
        return Base64.getDecoder();
    }

    private static final Object fromBase64$lambda$2() {
        return "Failed to parse potential CalibreWeb token";
    }
}

