/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "", "tika", "Lorg/apache/tika/config/TikaConfig;", "<init>", "(Lorg/apache/tika/config/TikaConfig;)V", "detectMediaType", "", "path", "Ljava/nio/file/Path;", "stream", "Ljava/io/InputStream;", "isImage", "", "mediaType", "mediaTypeToExtension", "komga"})
public class ContentDetector {
    @NotNull
    private final TikaConfig tika;

    public ContentDetector(@NotNull TikaConfig tika) {
        Intrinsics.checkNotNullParameter((Object)tika, (String)"tika");
        this.tika = tika;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String detectMediaType(@NotNull Path path) {
        String string;
        Metadata metadata;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Metadata it = metadata = new Metadata();
        boolean bl = false;
        it.set("tika.mime.file", PathsKt.getName((Path)path));
        Metadata metadata2 = metadata;
        Closeable closeable = (Closeable)TikaInputStream.get((Path)path);
        Throwable throwable = null;
        try {
            TikaInputStream it2 = (TikaInputStream)closeable;
            boolean bl2 = false;
            MediaType mediaType = this.tika.getDetector().detect((InputStream)it2, metadata2);
            String string2 = mediaType.toString();
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    @NotNull
    public String detectMediaType(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        String string = this.tika.getDetector().detect(stream, new Metadata()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean isImage(@NotNull String mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        return StringsKt.startsWith$default((String)mediaType, (String)"image/", (boolean)false, (int)2, null);
    }

    @Nullable
    public String mediaTypeToExtension(@NotNull String mediaType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        try {
            string = this.tika.getMimeRepository().forName(mediaType).getExtension();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }
}

