/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.divina;

import com.github.gotson.nightcompress.Archive;
import com.github.gotson.nightcompress.ArchiveEntry;
import com.github.gotson.nightcompress.ReadSupportCompression;
import com.github.gotson.nightcompress.ReadSupportFilter;
import com.github.gotson.nightcompress.ReadSupportFormat;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.greypanther.natsort.CaseInsensitiveSimpleNaturalComparator;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.MediaContainerEntry;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.divina.DivinaExtractor;
import org.gotson.komga.infrastructure.mediacontainer.divina.Rar5ExtractorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/divina/Rar5Extractor;", "Lorg/gotson/komga/infrastructure/mediacontainer/divina/DivinaExtractor;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "<init>", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;)V", "natSortComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "mediaTypes", "", "getEntries", "Lorg/gotson/komga/domain/model/MediaContainerEntry;", "path", "Ljava/nio/file/Path;", "analyzeDimensions", "", "getEntryStream", "", "entryName", "komga"})
@SourceDebugExtension(value={"SMAP\nRar5Extractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rar5Extractor.kt\norg/gotson/komga/infrastructure/mediacontainer/divina/Rar5Extractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class Rar5Extractor
implements DivinaExtractor {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final Comparator<String> natSortComparator;

    public Rar5Extractor(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        Comparator comparator = CaseInsensitiveSimpleNaturalComparator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getInstance(...)");
        this.natSortComparator = comparator;
    }

    @NotNull
    public List<String> mediaTypes() {
        return CollectionsKt.listOf((Object)MediaType.RAR_5.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<MediaContainerEntry> getEntries(@NotNull Path path, boolean analyzeDimensions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = (Closeable)new Archive(path, SetsKt.setOf((Object)ReadSupportCompression.NONE), SetsKt.setOf((Object)ReadSupportFilter.NONE), SetsKt.setOf((Object)ReadSupportFormat.RAR5));
        Throwable throwable = null;
        try {
            Archive rar = (Archive)closeable;
            boolean bl = false;
            Comparator comparator = this.natSortComparator;
            list = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence(() -> Rar5Extractor.getEntries$lambda$7$lambda$0(rar)), arg_0 -> Rar5Extractor.getEntries$lambda$7$lambda$5(rar, analyzeDimensions, this, arg_0)), (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] getEntryStream(@NotNull Path path, @NotNull String entryName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        Closeable closeable = Archive.getInputStream((Path)path, (Set)SetsKt.setOf((Object)ReadSupportCompression.NONE), (Set)SetsKt.setOf((Object)ReadSupportFilter.NONE), (Set)SetsKt.setOf((Object)ReadSupportFormat.RAR5), (String)entryName);
        Throwable throwable = null;
        try {
            Object object2;
            block9: {
                block8: {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    object2 = it;
                    if (object2 == null) break block8;
                    byte[] byArray = ByteStreamsKt.readBytes((InputStream)object2);
                    object2 = byArray;
                    if (byArray != null) break block9;
                }
                object2 = new byte[0];
            }
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    private static final ArchiveEntry getEntries$lambda$7$lambda$0(Archive $rar) {
        return $rar.getNextEntry();
    }

    private static final Object getEntries$lambda$7$lambda$5$lambda$4(ArchiveEntry $entry) {
        return "Could not analyze entry: " + $entry.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MediaContainerEntry getEntries$lambda$7$lambda$5(Archive $rar, boolean $analyzeDimensions, Rar5Extractor this$0, ArchiveEntry entry) {
        MediaContainerEntry mediaContainerEntry;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        try {
            Dimension dimension;
            Object object;
            Object it;
            Closeable closeable = $rar.getInputStream();
            Object object2 = null;
            try {
                it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                it = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            Object buffer = it;
            object2 = new ByteArrayInputStream((byte[])buffer);
            it = null;
            try {
                ByteArrayInputStream it2 = (ByteArrayInputStream)object2;
                boolean bl = false;
                object = this$0.contentDetector.detectMediaType((InputStream)it2);
            }
            catch (Throwable bl) {
                it = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)it);
            }
            String mediaType = object;
            if ($analyzeDimensions && this$0.contentDetector.isImage(mediaType)) {
                it = new ByteArrayInputStream((byte[])buffer);
                object = null;
                try {
                    ByteArrayInputStream it3 = (ByteArrayInputStream)it;
                    boolean bl = false;
                    Dimension dimension2 = this$0.imageAnalyzer.getDimension((InputStream)it3);
                    dimension = dimension2;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)it, (Throwable)object);
                }
            } else {
                dimension = null;
            }
            Dimension dimension3 = dimension;
            Long fileSize = entry.getSize();
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            mediaContainerEntry = new MediaContainerEntry(string, mediaType, null, dimension3, fileSize, 4, null);
        }
        catch (Exception e) {
            Rar5ExtractorKt.access$getLogger$p().warn((Throwable)e, () -> Rar5Extractor.getEntries$lambda$7$lambda$5$lambda$4(entry));
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            mediaContainerEntry = new MediaContainerEntry(string, null, e.getMessage(), null, null, 26, null);
        }
        return mediaContainerEntry;
    }
}

