/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.mediacontainer.epub;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.EpubTocEntry;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.R2Locator;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.kobo.KepubConverter;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub2Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.Epub3Nav;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractorKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage;
import org.gotson.komga.infrastructure.mediacontainer.epub.ManifestItem;
import org.gotson.komga.infrastructure.mediacontainer.epub.NavKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.NcxKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.OpfKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.ResourceContent;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J<\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0016JL\u0010$\u001a\"\u0012\u0004\u0012\u00020\u0011\u0012\u0018\u0012\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&\u0018\u00010\u00170%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110*H\u0012J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020,0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;", "", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "kepubConverter", "Lorg/gotson/komga/infrastructure/kobo/KepubConverter;", "letterCountThreshold", "", "<init>", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/kobo/KepubConverter;I)V", "getEntryStream", "", "path", "Ljava/nio/file/Path;", "entryName", "", "isEpub", "", "getCover", "Lorg/gotson/komga/domain/model/TypedBytes;", "getResources", "", "Lorg/gotson/komga/domain/model/MediaFile;", "epub", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubPackage;", "getDivinaPages", "Lorg/gotson/komga/domain/model/BookPage;", "analyzeDimensions", "isKepub", "resources", "computePageCount", "isFixedLayout", "computePositions", "Lorg/gotson/komga/domain/model/R2Locator;", "computePositionsFromKoboSpan", "", "Lkotlin/Pair;", "", "readingOrder", "resourceSupplier", "Lkotlin/Function1;", "getToc", "Lorg/gotson/komga/domain/model/EpubTocEntry;", "getPageList", "getLandmarks", "komga"})
@SourceDebugExtension(value={"SMAP\nEpubExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor\n+ 2 Epub.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubKt\n+ 3 ZipFileUtils.kt\norg/gotson/komga/infrastructure/util/ZipFileUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n21#2:363\n22#2,2:365\n24#2,2:368\n26#2:375\n8#3:364\n1#4:367\n1#4:372\n1#4:390\n1#4:409\n1#4:425\n1#4:446\n1#4:483\n1#4:490\n1#4:506\n1#4:515\n1#4:562\n1#4:566\n295#5,2:370\n295#5,2:373\n1563#5:376\n1634#5,3:377\n1617#5,9:380\n1869#5:389\n1870#5:391\n1626#5:392\n1563#5:393\n1634#5,3:394\n827#5:397\n855#5,2:398\n1563#5:400\n1634#5,3:401\n1563#5:404\n1634#5,2:405\n295#5,2:407\n1636#5:410\n1563#5:411\n1634#5,3:412\n1617#5,9:415\n1869#5:424\n1870#5:426\n1626#5:427\n1788#5,4:428\n1563#5:432\n1634#5,3:433\n1617#5,9:436\n1869#5:445\n1870#5:447\n1626#5:448\n1563#5:449\n1634#5,2:450\n1563#5:452\n1634#5,3:453\n1563#5:456\n1634#5,3:457\n1563#5:460\n1634#5,3:461\n1636#5:464\n1374#5:465\n1460#5,5:466\n1617#5,9:471\n1869#5:480\n295#5,2:481\n1870#5:484\n1626#5:485\n774#5:486\n865#5,2:487\n1869#5:489\n1870#5:491\n1563#5:492\n1634#5,3:493\n1617#5,9:496\n1869#5:505\n1870#5:507\n1626#5:508\n774#5:509\n865#5,2:510\n774#5:512\n865#5,2:513\n1563#5:516\n1634#5,3:517\n1374#5:520\n1460#5,2:521\n1563#5:523\n1634#5,2:524\n2423#5,14:526\n1636#5:540\n1462#5,3:541\n1563#5:544\n1634#5,3:545\n1193#5,2:548\n1267#5,2:550\n1617#5,9:552\n1869#5:561\n1870#5:563\n1626#5:564\n1270#5:565\n*S KotlinDebug\n*F\n+ 1 EpubExtractor.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor\n*L\n57#1:363\n57#1:365,2\n57#1:368,2\n57#1:375\n57#1:364\n57#1:367\n89#1:390\n125#1:425\n136#1:446\n175#1:483\n225#1:506\n326#1:562\n60#1:370,2\n68#1:373,2\n88#1:376\n88#1:377,3\n89#1:380,9\n89#1:389\n89#1:391\n89#1:392\n92#1:393\n92#1:394,3\n101#1:397\n101#1:398,2\n101#1:400\n101#1:401,3\n110#1:404\n110#1:405,2\n111#1:407,2\n110#1:410\n124#1:411\n124#1:412,3\n125#1:415,9\n125#1:424\n125#1:426\n125#1:427\n129#1:428,4\n135#1:432\n135#1:433,3\n136#1:436,9\n136#1:445\n136#1:447\n136#1:448\n139#1:449\n139#1:450,2\n152#1:452\n152#1:453,3\n157#1:456\n157#1:457,3\n159#1:460\n159#1:461,3\n139#1:464\n168#1:465\n168#1:466,5\n175#1:471,9\n175#1:480\n178#1:481,2\n175#1:484\n175#1:485\n204#1:486\n204#1:487,2\n206#1:489\n206#1:491\n224#1:492\n224#1:493,3\n225#1:496,9\n225#1:505\n225#1:507\n225#1:508\n229#1:509\n229#1:510,2\n244#1:512\n244#1:513,2\n275#1:516\n275#1:517,3\n286#1:520\n286#1:521,2\n288#1:523\n288#1:524,2\n295#1:526,14\n288#1:540\n286#1:541,3\n309#1:544\n309#1:545,3\n323#1:548,2\n323#1:550,2\n326#1:552,9\n326#1:561\n326#1:563\n326#1:564\n323#1:565\n*E\n"})
public class EpubExtractor {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final KepubConverter kepubConverter;
    private final int letterCountThreshold;

    public EpubExtractor(@NotNull ContentDetector contentDetector, @NotNull ImageAnalyzer imageAnalyzer, @NotNull KepubConverter kepubConverter, @Value(value="#{@komgaProperties.epubDivinaLetterCountThreshold}") int letterCountThreshold) {
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)kepubConverter, (String)"kepubConverter");
        this.contentDetector = contentDetector;
        this.imageAnalyzer = imageAnalyzer;
        this.kepubConverter = kepubConverter;
        this.letterCountThreshold = letterCountThreshold;
    }

    @NotNull
    public byte[] getEntryStream(@NotNull Path path, @NotNull String entryName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        return ZipFileUtilsKt.getZipEntryBytes((Path)path, (String)entryName);
    }

    public boolean isEpub(@NotNull Path path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)StringsKt.decodeToString((byte[])this.getEntryStream(path, "mimetype")))).toString(), (Object)"application/epub+zip");
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public TypedBytes getCover(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        $this$epub$iv = path;
        $i$f$epub = false;
        v0 = ZipFile.builder().setPath($this$epub$iv);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"setPath(...)");
        $this$use$iv$iv = (ZipFile.Builder)v0;
        $i$f$use = false;
        var6_6 = (Closeable)$this$use$iv$iv.get();
        var7_7 = null;
        try {
            block31: {
                block26: {
                    block30: {
                        block29: {
                            zip$iv = (ZipFile)var6_6;
                            $i$a$-use-EpubKt$epub$1$iv = false;
                            opfFile$iv = EpubKt.getPackagePath((ZipFile)zip$iv);
                            v1 = ZipFileUtilsKt.getEntryInputStream((ZipFile)zip$iv, (String)opfFile$iv);
                            if (v1 == null) break block29;
                            var11_13 = v1;
                            var12_14 = null;
                            try {
                                it$iv = (InputStream)var11_13;
                                $i$a$-use-EpubKt$epub$1$opfDoc$1$iv = false;
                                var13_15 = Jsoup.parse((InputStream)it$iv, null, (String)"", (Parser)Parser.xmlParser());
                                v2 = var13_15;
                            }
                            catch (Throwable var14_17) {
                                var12_14 = var14_17;
                                throw var14_17;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var11_13, (Throwable)var12_14);
                            }
                            v1 = v2;
                            if (v2 != null) break block30;
                        }
                        throw new MediaUnsupportedException("Could not open OPF resource", null, 2, null);
                    }
                    opfDoc$iv = v1;
                    opfDir$iv = Paths.get(opfFile$iv, new String[0]).getParent();
                    var17_21 = new EpubPackage(zip$iv, (Document)opfDoc$iv, opfDir$iv, OpfKt.getManifest((Document)opfDoc$iv));
                    $i$a$-epub-EpubExtractor$getCover$1 = false;
                    zip = var17_21.component1();
                    opfDoc = var17_21.component2();
                    opfDir = var17_21.component3();
                    manifest = var17_21.component4();
                    $this$firstOrNull$iv = manifest.values();
                    $i$f$firstOrNull = false;
                    var25_31 = $this$firstOrNull$iv.iterator();
                    while (var25_31.hasNext()) {
                        element$iv = var25_31.next();
                        it /* !! */  = (ManifestItem)element$iv;
                        $i$a$-firstOrNull-EpubExtractor$getCover$1$coverManifestItem$1 = false;
                        if (!it /* !! */ .getProperties().contains("cover-image")) continue;
                        v3 = element$iv;
                        break block26;
                    }
                    v3 = null;
                }
                if ((v4 = (ManifestItem)v3) != null) break block31;
                $i$f$firstOrNull = opfDoc.selectFirst("*|metadata > *|meta[name=cover]");
                if ($i$f$firstOrNull == null || (var25_31 = $i$f$firstOrNull.attr("content")) == null) ** GOTO lbl-1000
                it /* !! */  = (CharSequence)var25_31;
                if (StringsKt.isBlank((CharSequence)it /* !! */ )) {
                    $i$a$-ifBlank-EpubExtractor$getCover$1$coverManifestItem$2 = false;
                    v5 /* !! */  = null;
                } else {
                    v5 /* !! */  = it /* !! */ ;
                }
                var26_33 = (String)v5 /* !! */ ;
                if (var26_33 != null) {
                    it = var26_33;
                    $i$a$-let-EpubExtractor$getCover$1$coverManifestItem$3 = false;
                    v6 = (ManifestItem)manifest.get(it);
                } else lbl-1000:
                // 2 sources

                {
                    v6 = v4 = null;
                }
                if (v6 == null) {
                    block27: {
                        $this$firstOrNull$iv = manifest.values();
                        $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            it = (ManifestItem)element$iv;
                            $i$a$-firstOrNull-EpubExtractor$getCover$1$coverManifestItem$4 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)"cover-image")) continue;
                            v7 = element$iv;
                            break block27;
                        }
                        v7 = null;
                    }
                    v4 = v7;
                }
            }
            if ((coverManifestItem = v4) != null) {
                href = URLDecoder.decode(coverManifestItem.getHref(), Charsets.UTF_8);
                mediaType = coverManifestItem.getMediaType();
                Intrinsics.checkNotNull((Object)href);
                coverPath = OpfKt.normalizeHref((Path)opfDir, (String)href);
                v8 = ZipFileUtilsKt.getEntryBytes((ZipFile)zip, (String)coverPath);
                if (v8 != null) {
                    coverBytes = v8;
                    $i$a$-let-EpubExtractor$getCover$1$1 = false;
                    v9 = new TypedBytes(coverBytes, mediaType);
                } else {
                    v9 = null;
                }
            } else {
                v9 = null;
            }
            var8_8 = v9;
        }
        catch (Throwable var9_10) {
            var7_7 = var9_10;
            throw var9_10;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var6_6, (Throwable)var7_7);
        }
        return var8_8;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MediaFile> getResources(@NotNull EpubPackage epub) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$mapNotNullTo$iv$iv;
        Iterator it;
        Collection collection;
        Iterable $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Elements elements = epub.getOpfDoc().select("*|spine > *|itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$map$iv2 = (Iterable)elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable<ManifestItem> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Element element = (Element)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("idref"));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv4 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ManifestItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((ManifestItem)epub.getManifest().get(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List spine = (List)destination$iv$iv;
        Iterable $this$map$iv3 = spine;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void page;
            ManifestItem element$iv$iv$iv = (ManifestItem)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Path path = epub.getOpfDir();
            String string = URLDecoder.decode(page.getHref(), Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            collection.add(new MediaFile(OpfKt.normalizeHref((Path)path, (String)string), page.getMediaType(), MediaFile.SubType.EPUB_PAGE, null, 8, null));
        }
        List pages = (List)destination$iv$iv2;
        Iterable $this$filterNot$iv = epub.getManifest().values();
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ManifestItem it3 = (ManifestItem)element$iv$iv;
            boolean bl = false;
            if (spine.contains(it3)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ManifestItem it3 = (ManifestItem)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Path path = epub.getOpfDir();
            String string = URLDecoder.decode(it3.getHref(), Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            collection.add(new MediaFile(OpfKt.normalizeHref((Path)path, (String)string), it3.getMediaType(), MediaFile.SubType.EPUB_ASSET, null, 8, null));
        }
        List assets = (List)destination$iv$iv3;
        Enumeration enumeration = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        List zipEntries = arrayList;
        Iterable $this$map$iv4 = CollectionsKt.plus((Collection)pages, (Iterable)assets);
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Long l;
            Long l2;
            void var19_47;
            String string;
            String string2;
            MediaFile.SubType subType;
            block9: {
                void $this$firstOrNull$iv;
                void resource;
                MediaFile bl = (MediaFile)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                Iterable bl2 = zipEntries;
                subType = null;
                string2 = null;
                string = null;
                var19_47 = resource;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ZipArchiveEntry it4 = (ZipArchiveEntry)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it4.getName(), (Object)resource.getFileName())) continue;
                    l2 = (Long)element$iv;
                    break block9;
                }
                l2 = null;
            }
            Long l3 = l2;
            void v8 = var19_47;
            String string3 = string;
            String string4 = string2;
            MediaFile.SubType subType2 = subType;
            if ((ZipArchiveEntry)l3 != null) {
                void it5;
                subType = subType2;
                string2 = string4;
                string = string3;
                var19_47 = v8;
                boolean bl = false;
                l3 = it5.getSize() == -1L ? null : Long.valueOf(it5.getSize());
                v8 = var19_47;
                string3 = string;
                string4 = string2;
                subType2 = subType;
                l = l3;
            } else {
                l = null;
            }
            collection.add(MediaFile.copy$default((MediaFile)v8, string3, string4, subType2, l, (int)7, null));
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public List<BookPage> getDivinaPages(@NotNull EpubPackage epub, boolean analyzeDimensions) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        $this$getDivinaPages_u24lambda_u2418 /* !! */  = this;
        $i$a$-run-EpubExtractor$getDivinaPages$pageCount$1 = false;
        v0 = epub.getOpfDoc().select("*|spine > *|itemref");
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"select(...)");
        var7_6 = (Iterable)v0;
        $i$f$map = false;
        var9_12 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var14_32 = (Element)item$iv$iv;
            var15_35 = destination$iv$iv;
            $i$a$-map-EpubExtractor$getDivinaPages$pageCount$1$spine$1 = false;
            var15_35.add(it.attr("idref"));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = element$iv$iv$iv = it.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            idref = (String)element$iv$iv;
            $i$a$-mapNotNull-EpubExtractor$getDivinaPages$pageCount$1$spine$2 = false;
            v1 /* !! */  = (ManifestItem)epub.getManifest().get(idref);
            if (v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getHref()) != null) {
                it /* !! */  = v1 /* !! */ ;
                $i$a$-let-EpubExtractor$getDivinaPages$pageCount$1$spine$2$1 = false;
                v2 = OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it /* !! */ );
            } else {
                v2 = null;
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        spine = (List)destination$iv$iv;
        v3 = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getEntries(...)");
        v4 = Collections.list(v3);
        Intrinsics.checkNotNullExpressionValue(v4, (String)"list(...)");
        $this$mapNotNull$iv = v4;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v5 = 0;
        } else {
            count$iv = 0;
            for (E element$iv : $this$count$iv) {
                it = (ZipArchiveEntry)element$iv;
                $i$a$-count-EpubExtractor$getDivinaPages$pageCount$1$1 = false;
                if (!spine.contains(it.getName()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v5 = count$iv;
        }
        pageCount = v5;
        v6 = epub.getOpfDoc().select("*|spine > *|itemref");
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"select(...)");
        $this$getDivinaPages_u24lambda_u2418 /* !! */  = (Iterable)v6;
        $i$f$map = false;
        $this$count$iv = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            var30_81 = destination$iv$iv /* !! */ ;
            $i$a$-map-EpubExtractor$getDivinaPages$pagesWithImages$1 = false;
            var30_81.add(it.attr("idref"));
        }
        $this$map$iv = (List)destination$iv$iv /* !! */ ;
        $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = element$iv$iv$iv = it.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            idref = (String)element$iv$iv;
            $i$a$-mapNotNull-EpubExtractor$getDivinaPages$pagesWithImages$2 = false;
            if (((ManifestItem)epub.getManifest().get(idref) == null ? null : TuplesKt.to((Object)OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)manifestItem.getHref()), (Object)manifestItem.getMediaType())) == null) continue;
            it$iv$iv = it$iv$iv;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv /* !! */ .add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv /* !! */ ;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block35: {
                block34: {
                    it = (Pair)item$iv$iv;
                    var30_81 = destination$iv$iv /* !! */ ;
                    $i$a$-map-EpubExtractor$getDivinaPages$pagesWithImages$3 = false;
                    pagePath = (String)it.component1();
                    mediaType = (String)it.component2();
                    if (!StringsKt.startsWith((String)mediaType, (String)"image", (boolean)true)) break block34;
                    v7 = Paths.get(pagePath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"get(...)");
                    v8 = v7.normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"normalize(...)");
                    v9 = CollectionsKt.listOf((Object)PathsKt.getInvariantSeparatorsPathString((Path)v8));
                    break block35;
                }
                v10 = ZipFileUtilsKt.getEntryInputStream((ZipFile)epub.getZip(), (String)pagePath);
                if (v10 == null) ** GOTO lbl-1000
                idref = v10;
                $i$a$-mapNotNull-EpubExtractor$getDivinaPages$pagesWithImages$2 = null;
                try {
                    it = (InputStream)idref;
                    $i$a$-use-EpubExtractor$getDivinaPages$pagesWithImages$3$doc$1 = false;
                    it = Jsoup.parse((InputStream)it, null, (String)"");
                    v11 = it;
                }
                catch (Throwable $i$a$-use-EpubExtractor$getDivinaPages$pagesWithImages$3$doc$1) {
                    $i$a$-mapNotNull-EpubExtractor$getDivinaPages$pagesWithImages$2 = $i$a$-use-EpubExtractor$getDivinaPages$pagesWithImages$3$doc$1;
                    throw $i$a$-use-EpubExtractor$getDivinaPages$pagesWithImages$3$doc$1;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)idref, (Throwable)$i$a$-mapNotNull-EpubExtractor$getDivinaPages$pagesWithImages$2);
                }
                v10 = v11;
                if (v11 == null) lbl-1000:
                // 2 sources

                {
                    v9 = CollectionsKt.emptyList();
                } else {
                    doc = v10;
                    if (doc.body().text().length() > this.letterCountThreshold) {
                        return CollectionsKt.emptyList();
                    }
                    v12 = doc.getElementsByTag("img");
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getElementsByTag(...)");
                    it /* !! */  = (Iterable)v12;
                    $i$f$map = false;
                    $i$a$-mapNotNull-EpubExtractor$getDivinaPages$pagesWithImages$2 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = (Element)item$iv$iv;
                        spine = destination$iv$iv;
                        $i$a$-map-EpubExtractor$getDivinaPages$pagesWithImages$3$img$1 = false;
                        spine.add(it.attr("src"));
                    }
                    img = (List)destination$iv$iv;
                    v13 = doc.select("svg > image[xlink:href]");
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"select(...)");
                    $i$f$map = (Iterable)v13;
                    $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        $i$a$-map-EpubExtractor$getDivinaPages$pagesWithImages$3$img$1 = (Element)item$iv$iv;
                        spine = destination$iv$iv;
                        $i$a$-map-EpubExtractor$getDivinaPages$pagesWithImages$3$svg$1 = false;
                        spine.add(it.attr("xlink:href"));
                    }
                    svg = (List)destination$iv$iv;
                    $this$map$iv = CollectionsKt.plus((Collection)img, (Iterable)svg);
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    item$iv$iv = $this$mapTo$iv$iv.iterator();
                    while (item$iv$iv.hasNext()) {
                        item$iv$iv = item$iv$iv.next();
                        it = (String)item$iv$iv;
                        spine = destination$iv$iv;
                        $i$a$-map-EpubExtractor$getDivinaPages$pagesWithImages$3$1 = false;
                        v14 = Paths.get(pagePath, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"get(...)");
                        v15 = v14.getParent();
                        if (v15 == null) {
                            v16 = Paths.get("", new String[0]);
                            v15 = v16;
                            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"get(...)");
                        }
                        v17 = v15.resolve(it).normalize();
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"normalize(...)");
                        spine.add(PathsKt.getInvariantSeparatorsPathString((Path)v17));
                    }
                    v9 = (List)destination$iv$iv;
                }
            }
            var30_81.add(v9);
        }
        pagesWithImages = (List)destination$iv$iv /* !! */ ;
        if (pagesWithImages.size() != pageCount) {
            EpubExtractorKt.access$getLogger$p().info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getDivinaPages$lambda$26(java.util.List int ), ()Ljava/lang/Object;)((List)pagesWithImages, (int)pageCount));
            return CollectionsKt.emptyList();
        }
        $this$flatMap$iv = pagesWithImages;
        $i$f$flatMap = false;
        destination$iv$iv /* !! */  = $this$flatMap$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            $i$a$-flatMap-EpubExtractor$getDivinaPages$imagesPath$1 = false;
            list$iv$iv = CollectionsKt.distinct((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv /* !! */ , (Iterable)list$iv$iv);
        }
        imagesPath = (List)destination$iv$iv /* !! */ ;
        if (imagesPath.size() != pageCount) {
            EpubExtractorKt.access$getLogger$p().info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getDivinaPages$lambda$28(java.util.List int ), ()Ljava/lang/Object;)((List)imagesPath, (int)pageCount));
            return CollectionsKt.emptyList();
        }
        $this$mapNotNull$iv = imagesPath;
        $i$f$mapNotNull = false;
        destination$iv$iv /* !! */  = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_34 = $this$forEach$iv$iv$iv.iterator();
        while (var14_34.hasNext()) {
            block37: {
                block40: {
                    block39: {
                        block38: {
                            block36: {
                                block33: {
                                    element$iv$iv = element$iv$iv$iv = var14_34.next();
                                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                    imagePath = (String)element$iv$iv;
                                    $i$a$-mapNotNull-EpubExtractor$getDivinaPages$divinaPages$1 = false;
                                    doc = epub.getManifest().values();
                                    $i$f$firstOrNull = false;
                                    var22_70 = $this$firstOrNull$iv.iterator();
                                    while (var22_70.hasNext()) {
                                        element$iv = var22_70.next();
                                        it = (ManifestItem)element$iv;
                                        $i$a$-firstOrNull-EpubExtractor$getDivinaPages$divinaPages$1$mediaType$1 = false;
                                        if (!Intrinsics.areEqual((Object)OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it.getHref()), (Object)imagePath)) continue;
                                        v18 = element$iv;
                                        break block33;
                                    }
                                    v18 = null;
                                }
                                it = v18;
                                if (it != null && ($this$firstOrNull$iv = it.getMediaType()) != null) break block36;
                                v19 = null;
                                break block37;
                            }
                            mediaType = $this$firstOrNull$iv;
                            zipEntry = epub.getZip().getEntry(imagePath);
                            if (this.contentDetector.isImage(mediaType)) break block38;
                            v19 = null;
                            break block37;
                        }
                        if (!analyzeDimensions) break block39;
                        $i$f$firstOrNull = epub.getZip().getInputStream(zipEntry);
                        var22_70 = null;
                        try {
                            it = (InputStream)$i$f$firstOrNull;
                            $i$a$-use-EpubExtractor$getDivinaPages$divinaPages$1$dimension$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            var23_71 = this.imageAnalyzer.getDimension(it);
                        }
                        catch (Throwable var24_76) {
                            try {
                                var22_70 = var24_76;
                                throw var24_76;
                            }
                            catch (Throwable var24_77) {
                                CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, var22_70);
                                throw var24_77;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, (Throwable)var22_70);
                        v20 = var23_71;
                        break block40;
                    }
                    v20 = null;
                }
                dimension = v20;
                fileSize = zipEntry.getSize() == -1L ? null : Long.valueOf(zipEntry.getSize());
                v19 = new BookPage(imagePath, mediaType, dimension, null, fileSize, 8, null);
            }
            if (v19 == null) continue;
            it$iv$iv = v19;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        divinaPages = (List)destination$iv$iv;
        if (divinaPages.size() != pageCount) {
            EpubExtractorKt.access$getLogger$p().info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getDivinaPages$lambda$32(java.util.List int ), ()Ljava/lang/Object;)((List)divinaPages, (int)pageCount));
            return CollectionsKt.emptyList();
        }
        return divinaPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean isKepub(@NotNull EpubPackage epub, @NotNull List<MediaFile> resources) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = resources;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaFile it = (MediaFile)element$iv$iv;
                boolean bl = false;
                if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List readingOrder = (List)destination$iv$iv;
            Iterable $this$forEach$iv = readingOrder;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Document doc;
                Document document;
                MediaFile mediaFile = (MediaFile)element$iv;
                boolean bl = false;
                InputStream inputStream = ZipFileUtilsKt.getEntryInputStream((ZipFile)epub.getZip(), (String)mediaFile.getFileName());
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        Document document2 = Jsoup.parse((InputStream)it, null, (String)"");
                        document = document2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    document = null;
                }
                Document document3 = doc = document;
                Collection collection = (Collection)(document3 != null ? document3.getElementsByClass("koboSpan") : null);
                if (collection == null || collection.isEmpty()) continue;
                return true;
            }
        }
        catch (Exception e) {
            EpubExtractorKt.access$getLogger$p().warn((Throwable)e, EpubExtractor::isKepub$lambda$36);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int computePageCount(@NotNull EpubPackage epub) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        ZipArchiveEntry it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Elements elements = epub.getOpfDoc().select("*|spine > *|itemref");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$map$iv = (Iterable)elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("idref"));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String idref = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = (ManifestItem)epub.getManifest().get(idref);
            if (object != null && (object = object.getHref()) != null) {
                Object it2 = object;
                boolean bl3 = false;
                string = OpfKt.normalizeHref((Path)epub.getOpfDir(), (String)it2);
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List spine = (List)destination$iv$iv;
        Enumeration enumeration = epub.getZip().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ZipArchiveEntry)element$iv$iv;
            boolean bl = false;
            if (!spine.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it3;
            ZipArchiveEntry $i$f$filterTo2 = (ZipArchiveEntry)e;
            int n2 = n;
            boolean bl = false;
            int n3 = (int)Math.ceil((double)it3.getCompressedSize() / 1024.0);
            n = n2 + n3;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFixedLayout(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        Element element = epub.getOpfDoc().selectFirst("*|metadata > *|meta[property=rendition:layout]");
        if (Intrinsics.areEqual((Object)(element != null ? element.text() : null), (Object)"pre-paginated")) return true;
        Element element2 = epub.getOpfDoc().selectFirst("*|metadata > *|meta[name=fixed-layout]");
        if (!Intrinsics.areEqual((Object)(element2 != null ? element2.attr("content") : null), (Object)"true")) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public List<R2Locator> computePositions(@NotNull EpubPackage epub, @NotNull Path path, @NotNull List<MediaFile> resources, boolean isFixedLayout, boolean isKepub) {
        block26: {
            block25: {
                Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(resources, (String)"resources");
                $this$filter$iv = resources;
                $i$f$filter = false;
                var9_10 = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                var12_14 = $this$filterTo$iv$iv.iterator();
                while (var12_14.hasNext()) {
                    element$iv$iv = var12_14.next();
                    it = (MediaFile)element$iv$iv;
                    $i$a$-filter-EpubExtractor$computePositions$readingOrder$1 = false;
                    if (!(it.getSubType() == MediaFile.SubType.EPUB_PAGE)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                readingOrder = (List)destination$iv$iv /* !! */ ;
                startPosition = 0;
                startPosition = 1;
                if (isFixedLayout) {
                    v0 = MapsKt.emptyMap();
                } else if (isKepub) {
                    v0 = this.computePositionsFromKoboSpan(readingOrder, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computePositions$lambda$44(org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((EpubPackage)epub));
                } else if (this.kepubConverter.isAvailable()) {
                    try {
                        destination$iv$iv /* !! */  = KepubConverter.convertEpubToKepubWithoutChecks$default((KepubConverter)this.kepubConverter, (Path)path, null, (int)2, null);
                        if (destination$iv$iv /* !! */  == null) {
                            throw new IllegalStateException();
                        }
                        it = var12_14 = destination$iv$iv /* !! */ ;
                        $i$a$-also-EpubExtractor$computePositions$koboPositions$kepub$1 = false;
                        it.toFile().deleteOnExit();
                        kepub = var12_14;
                        positions = this.computePositionsFromKoboSpan(readingOrder, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computePositions$lambda$46(java.nio.file.Path java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((Path)kepub));
                        Files.deleteIfExists((Path)kepub);
                        kepub = positions;
                    }
                    catch (Exception <unused var>) {
                        EpubExtractorKt.access$getLogger$p().warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, computePositions$lambda$47(java.nio.file.Path ), ()Ljava/lang/Object;)((Path)path));
                        kepub = MapsKt.emptyMap();
                    }
                    v0 = kepub;
                } else {
                    v0 = koboPositions = MapsKt.emptyMap();
                }
                if (!isFixedLayout) break block25;
                $this$map$iv = readingOrder;
                $i$f$map = false;
                var12_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_24 = (MediaFile)item$iv$iv;
                    var42_22 = destination$iv$iv;
                    $i$a$-map-EpubExtractor$computePositions$positions$1 = false;
                    var19_26 = it.getFileName();
                    v1 = it.getMediaType();
                    if (v1 == null) {
                        v1 = "application/octet-stream";
                    }
                    var20_29 = v1;
                    var21_32 = startPosition;
                    startPosition = var21_32 + 1;
                    var22_34 = new R2Locator.Location(null, Float.valueOf(0.0f), Integer.valueOf(var21_32), null, 9, null);
                    var42_22.add(new R2Locator(var19_26, var20_29, null, (R2Locator.Location)var22_34, null, "kobo.1.1", 20, null));
                }
                v2 = (List)destination$iv$iv;
                break block26;
            }
            $this$flatMap$iv = readingOrder;
            $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                file = (MediaFile)element$iv$iv;
                $i$a$-flatMap-EpubExtractor$computePositions$positions$2 = false;
                var19_27 = 1;
                v3 = file.getFileSize();
                var20_30 = MathKt.roundToInt((double)Math.ceil((double)(v3 != null ? v3 : 0L) / 1024.0));
                positionCount = Math.max(var19_27, var20_30);
                $this$map$iv = (Iterable)RangesKt.until((int)0, (int)positionCount);
                $i$f$map = false;
                var22_34 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var25_37 = $this$mapTo$iv$iv.iterator();
                while (var25_37.hasNext()) {
                    block28: {
                        block27: {
                            var27_39 = item$iv$iv = ((IntIterator)var25_37).nextInt();
                            var28_40 = destination$iv$iv;
                            $i$a$-map-EpubExtractor$computePositions$positions$2$1 = false;
                            progression = (float)p / (float)positionCount;
                            if (positionCount != 1 && p != false) break block27;
                            v4 = "kobo.1.1";
                            break block28;
                        }
                        var31_44 = (List)koboPositions.get(file.getFileName());
                        if (var31_44 == null) ** GOTO lbl-1000
                        var32_45 = var31_44;
                        $i$f$minByOrNull = false;
                        iterator$iv = $this$minByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v5 = null;
                        } else {
                            minElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v5 = minElem$iv;
                            } else {
                                it = (Pair)minElem$iv;
                                $i$a$-minByOrNull-EpubExtractor$computePositions$positions$2$1$koboSpan$1 = false;
                                minValue$iv = Math.abs(progression - ((Number)it.getSecond()).floatValue());
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (Pair)e$iv;
                                    $i$a$-minByOrNull-EpubExtractor$computePositions$positions$2$1$koboSpan$1 = false;
                                    v$iv = Math.abs(progression - ((Number)it.getSecond()).floatValue());
                                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                                    minElem$iv = e$iv;
                                    minValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v5 = minElem$iv;
                            }
                        }
                        var40_56 = v5;
                        if (var40_56 != null) {
                            v4 = (String)var40_56.getFirst();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = null;
                        }
                    }
                    koboSpan = v4;
                    v6 = file.getFileName();
                    v7 = file.getMediaType();
                    if (v7 == null) {
                        v7 = "application/octet-stream";
                    }
                    var31_43 = startPosition;
                    startPosition = var31_43 + 1;
                    var28_40.add(new R2Locator(v6, v7, null, new R2Locator.Location(null, Float.valueOf(progression), Integer.valueOf(var31_43), null, 9, null), null, koboSpan, 20, null));
                }
                list$iv$iv /* !! */  = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv /* !! */ );
            }
            v2 = (List)destination$iv$iv;
        }
        positions = v2;
        $this$map$iv = positions;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv /* !! */  = (R2Locator)item$iv$iv;
            var42_22 = destination$iv$iv;
            $i$a$-map-EpubExtractor$computePositions$1 = false;
            v8 /* !! */  = locator.getLocations();
            if (v8 /* !! */  != null && (v8 /* !! */  = v8 /* !! */ .getPosition()) != null) {
                it = ((Number)v8 /* !! */ ).intValue();
                $i$a$-let-EpubExtractor$computePositions$1$totalProgression$1 = false;
                v9 = Float.valueOf((float)it / (float)positions.size());
            } else {
                v9 = null;
            }
            totalProgression = v9;
            v10 = locator.getLocations();
            var42_22.add(R2Locator.copy$default((R2Locator)locator, null, null, null, (R2Locator.Location)(v10 != null ? R2Locator.Location.copy$default((R2Locator.Location)v10, null, null, null, (Float)totalProgression, (int)7, null) : null), null, null, (int)55, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<Pair<String, Float>>> computePositionsFromKoboSpan(List<MediaFile> readingOrder, Function1<? super String, String> resourceSupplier) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = readingOrder;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            List list;
            Document document;
            Map map = destination$iv$iv;
            MediaFile file = (MediaFile)element$iv$iv;
            boolean bl = false;
            if ((String)resourceSupplier.invoke((Object)file.getFileName()) != null) {
                String resource;
                boolean bl2 = false;
                document = Jsoup.parse((String)resource, (Parser)Parser.htmlParser().setTrackPosition(true));
            } else {
                document = null;
            }
            Document doc = document;
            String string = file.getFileName();
            Document document2 = doc;
            if (document2 != null && (document2 = document2.select("span.koboSpan")) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable2 = (Iterable)document2;
                String string2 = string;
                boolean $i$f$mapNotNull = false;
                void bl2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    String id;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    Element koboSpan = (Element)element$iv$iv2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)koboSpan.id(), (String)"id(...)");
                    if (!StringsKt.isBlank((CharSequence)id)) {
                        float f = koboSpan.sourceRange().endPos();
                        Long l = file.getFileSize();
                        Intrinsics.checkNotNull((Object)l);
                        float progression = f / (float)l.longValue();
                        pair = new Pair((Object)id, (Object)Float.valueOf(progression));
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
                string = string2;
            } else {
                list = null;
            }
            Pair pair = TuplesKt.to((Object)string, list);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public List<EpubTocEntry> getToc(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.TOC);
        }
        ResourceContent resourceContent2 = NcxKt.getNcxResource((EpubPackage)epub);
        if (resourceContent2 != null) {
            ResourceContent it = resourceContent2;
            boolean bl = false;
            return NcxKt.processNcx((ResourceContent)it, (Epub2Nav)Epub2Nav.TOC);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<EpubTocEntry> getPageList(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.PAGELIST);
        }
        ResourceContent resourceContent2 = NcxKt.getNcxResource((EpubPackage)epub);
        if (resourceContent2 != null) {
            ResourceContent it = resourceContent2;
            boolean bl = false;
            return NcxKt.processNcx((ResourceContent)it, (Epub2Nav)Epub2Nav.PAGELIST);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<EpubTocEntry> getLandmarks(@NotNull EpubPackage epub) {
        Intrinsics.checkNotNullParameter((Object)epub, (String)"epub");
        ResourceContent resourceContent = NavKt.getNavResource((EpubPackage)epub);
        if (resourceContent != null) {
            ResourceContent it = resourceContent;
            boolean bl = false;
            return NavKt.processNav((ResourceContent)it, (Epub3Nav)Epub3Nav.LANDMARKS);
        }
        return OpfKt.processOpfGuide((Document)epub.getOpfDoc(), (Path)epub.getOpfDir());
    }

    private static final Object getDivinaPages$lambda$26(List $pagesWithImages, int $pageCount) {
        return "Epub Divina detection failed: book has " + $pagesWithImages.size() + " pages with images, but " + $pageCount + " total pages";
    }

    private static final Object getDivinaPages$lambda$28(List $imagesPath, int $pageCount) {
        return "Epub Divina detection failed: book has " + $imagesPath.size() + " detected images, but " + $pageCount + " total pages";
    }

    private static final Object getDivinaPages$lambda$32(List $divinaPages, int $pageCount) {
        return "Epub Divina detection failed: book has " + $divinaPages.size() + " detected divina pages, but " + $pageCount + " total pages";
    }

    private static final Object isKepub$lambda$36() {
        return "Error while checking if EPUB is KEPUB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final String computePositions$lambda$44(EpubPackage $epub, String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        var2_2 = ZipFileUtilsKt.getEntryInputStream((ZipFile)$epub.getZip(), (String)filename);
        var3_3 = null;
        try {
            it = (InputStream)var2_2;
            $i$a$-use-EpubExtractor$computePositions$koboPositions$1$1 = false;
            v0 = it;
            if (v0 == null) ** GOTO lbl-1000
            v1 = ByteStreamsKt.readBytes((InputStream)v0);
            v0 = v1;
            if (v1 != null) {
                v2 = StringsKt.decodeToString((byte[])v0);
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            var4_4 = v2;
        }
        catch (Throwable var5_6) {
            var3_3 = var5_6;
            throw var5_6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var2_2, (Throwable)var3_3);
        }
        return var4_4;
    }

    private static final String computePositions$lambda$46(Path $kepub, String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return StringsKt.decodeToString((byte[])ZipFileUtilsKt.getZipEntryBytes((Path)$kepub, (String)filename));
    }

    private static final Object computePositions$lambda$47(Path $path) {
        return "Could not convert to Kepub to compute positions: " + $path;
    }
}

