/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.metadata.oneshot;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.BookMetadata;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.MetadataPatchTarget;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.SeriesMetadata;
import org.gotson.komga.domain.model.SeriesMetadataPatch;
import org.gotson.komga.domain.persistence.BookMetadataRepository;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/infrastructure/metadata/oneshot/OneShotSeriesProvider;", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataProvider;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "bookMetadataRepository", "Lorg/gotson/komga/domain/persistence/BookMetadataRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/BookMetadataRepository;)V", "getSeriesMetadata", "Lorg/gotson/komga/domain/model/SeriesMetadataPatch;", "series", "Lorg/gotson/komga/domain/model/Series;", "shouldLibraryHandlePatch", "", "library", "Lorg/gotson/komga/domain/model/Library;", "target", "Lorg/gotson/komga/domain/model/MetadataPatchTarget;", "komga"})
public class OneShotSeriesProvider
implements SeriesMetadataProvider {
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final BookMetadataRepository bookMetadataRepository;

    public OneShotSeriesProvider(@NotNull BookRepository bookRepository, @NotNull BookMetadataRepository bookMetadataRepository) {
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)bookMetadataRepository, (String)"bookMetadataRepository");
        this.bookRepository = bookRepository;
        this.bookMetadataRepository = bookMetadataRepository;
    }

    @Nullable
    public SeriesMetadataPatch getSeriesMetadata(@NotNull Series series) {
        Intrinsics.checkNotNullParameter((Object)series, (String)"series");
        if (!series.getOneshot()) {
            return null;
        }
        BookMetadata bookMetadata = this.bookMetadataRepository.findById((String)CollectionsKt.first((Iterable)this.bookRepository.findAllIdsBySeriesId(series.getId())));
        return new SeriesMetadataPatch(bookMetadata.getTitle(), bookMetadata.getTitle(), SeriesMetadata.Status.ENDED, bookMetadata.getSummary(), null, null, null, null, null, Integer.valueOf(1), SetsKt.emptySet());
    }

    public boolean shouldLibraryHandlePatch(@NotNull Library library, @NotNull MetadataPatchTarget target) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return target == MetadataPatchTarget.SERIES;
    }
}

