/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.gotson.komga.infrastructure.search.MultiLingualAnalyzer;
import org.gotson.komga.infrastructure.search.MultiLingualNGramAnalyzer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u000bH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gotson/komga/infrastructure/search/LuceneConfiguration;", "", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "<init>", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "indexAnalyzer", "Lorg/gotson/komga/infrastructure/search/MultiLingualNGramAnalyzer;", "searchAnalyzer", "Lorg/gotson/komga/infrastructure/search/MultiLingualAnalyzer;", "memoryDirectory", "Lorg/apache/lucene/store/Directory;", "diskDirectory", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "directory", "Lorg/apache/lucene/analysis/Analyzer;", "searcherManager", "Lorg/apache/lucene/search/SearcherManager;", "komga"})
public class LuceneConfiguration {
    @NotNull
    private final KomgaProperties komgaProperties;

    public LuceneConfiguration(@NotNull KomgaProperties komgaProperties) {
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        this.komgaProperties = komgaProperties;
    }

    @Bean
    @NotNull
    public MultiLingualNGramAnalyzer indexAnalyzer() {
        KomgaProperties.Lucene.IndexAnalyzer $this$indexAnalyzer_u24lambda_u240 = this.komgaProperties.getLucene().getIndexAnalyzer();
        boolean bl = false;
        return new MultiLingualNGramAnalyzer($this$indexAnalyzer_u24lambda_u240.getMinGram(), $this$indexAnalyzer_u24lambda_u240.getMaxGram(), $this$indexAnalyzer_u24lambda_u240.getPreserveOriginal());
    }

    @Bean
    @NotNull
    public MultiLingualAnalyzer searchAnalyzer() {
        return new MultiLingualAnalyzer();
    }

    @Bean
    @Profile(value={"test"})
    @NotNull
    public Directory memoryDirectory() {
        return (Directory)new ByteBuffersDirectory();
    }

    @Bean
    @Profile(value={"!test"})
    @NotNull
    public Directory diskDirectory() {
        FSDirectory fSDirectory = FSDirectory.open((Path)Paths.get(this.komgaProperties.getLucene().getDataDirectory(), new String[0]), (LockFactory)((LockFactory)new SingleInstanceLockFactory()));
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"open(...)");
        return (Directory)fSDirectory;
    }

    @Bean
    @NotNull
    public IndexWriter indexWriter(@NotNull Directory directory, @NotNull Analyzer indexAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)indexAnalyzer, (String)"indexAnalyzer");
        return new IndexWriter(directory, new IndexWriterConfig(indexAnalyzer));
    }

    @Bean
    @NotNull
    public SearcherManager searcherManager(@NotNull IndexWriter indexWriter) {
        Intrinsics.checkNotNullParameter((Object)indexWriter, (String)"indexWriter");
        return new SearcherManager(indexWriter, new SearcherFactory());
    }
}

