/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.gotson.komga.infrastructure.search.LuceneCommitter;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.infrastructure.search.LuceneHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0016J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gotson/komga/infrastructure/search/LuceneHelper;", "", "directory", "Lorg/apache/lucene/store/Directory;", "searchAnalyzer", "Lorg/apache/lucene/analysis/Analyzer;", "indexAnalyzer", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "searcherManager", "Lorg/apache/lucene/search/SearcherManager;", "luceneCommitter", "Lorg/gotson/komga/infrastructure/search/LuceneCommitter;", "<init>", "(Lorg/apache/lucene/store/Directory;Lorg/apache/lucene/analysis/Analyzer;Lorg/apache/lucene/analysis/Analyzer;Lorg/apache/lucene/index/IndexWriter;Lorg/apache/lucene/search/SearcherManager;Lorg/gotson/komga/infrastructure/search/LuceneCommitter;)V", "indexExists", "", "setIndexVersion", "", "version", "", "getIndexVersion", "searchEntitiesIds", "", "", "searchTerm", "entity", "Lorg/gotson/komga/infrastructure/search/LuceneEntity;", "upgradeIndex", "addDocument", "doc", "Lorg/apache/lucene/document/Document;", "addDocuments", "docs", "", "updateDocument", "term", "Lorg/apache/lucene/index/Term;", "deleteDocuments", "komga"})
@SourceDebugExtension(value={"SMAP\nLuceneHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneHelper.kt\norg/gotson/komga/infrastructure/search/LuceneHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n11228#2:120\n11563#2,3:121\n11228#2:124\n11563#2,3:125\n*S KotlinDebug\n*F\n+ 1 LuceneHelper.kt\norg/gotson/komga/infrastructure/search/LuceneHelper\n*L\n52#1:120\n52#1:121,3\n80#1:124\n80#1:125,3\n*E\n"})
public class LuceneHelper {
    @NotNull
    private final Directory directory;
    @NotNull
    private final Analyzer searchAnalyzer;
    @NotNull
    private final Analyzer indexAnalyzer;
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final SearcherManager searcherManager;
    @NotNull
    private final LuceneCommitter luceneCommitter;

    public LuceneHelper(@NotNull Directory directory, @NotNull Analyzer searchAnalyzer, @NotNull Analyzer indexAnalyzer, @NotNull IndexWriter indexWriter, @NotNull SearcherManager searcherManager, @NotNull LuceneCommitter luceneCommitter) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)searchAnalyzer, (String)"searchAnalyzer");
        Intrinsics.checkNotNullParameter((Object)indexAnalyzer, (String)"indexAnalyzer");
        Intrinsics.checkNotNullParameter((Object)indexWriter, (String)"indexWriter");
        Intrinsics.checkNotNullParameter((Object)searcherManager, (String)"searcherManager");
        Intrinsics.checkNotNullParameter((Object)luceneCommitter, (String)"luceneCommitter");
        this.directory = directory;
        this.searchAnalyzer = searchAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
        this.indexWriter = indexWriter;
        this.searcherManager = searcherManager;
        this.luceneCommitter = luceneCommitter;
    }

    public boolean indexExists() {
        return DirectoryReader.indexExists((Directory)this.directory);
    }

    public void setIndexVersion(int version) {
        Document document;
        Document $this$setIndexVersion_u24lambda_u240 = document = new Document();
        boolean bl = false;
        $this$setIndexVersion_u24lambda_u240.add((IndexableField)new StringField("index_version", String.valueOf(version), Field.Store.YES));
        $this$setIndexVersion_u24lambda_u240.add((IndexableField)new StringField("type", "index_version", Field.Store.NO));
        Document doc = document;
        this.updateDocument(new Term("type", "index_version"), doc);
        LuceneHelperKt.access$getLogger$p().info(() -> LuceneHelper.setIndexVersion$lambda$1(this));
    }

    /*
     * WARNING - void declaration
     */
    public int getIndexVersion() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        TopDocs topDocs = searcher.search((Query)new TermQuery(new Term("type", "index_version")), 1);
        Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
        Object object = topDocs.scoreDocs;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScoreDoc scoreDoc = (ScoreDoc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(searcher.storedFields().document(it.doc).get("index_version"));
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return string != null && (object = StringsKt.toIntOrNull((String)string)) != null ? (Integer)object : 1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<String> searchEntitiesIds(@Nullable String searchTerm, @NotNull LuceneEntity entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object2 = searchTerm;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            try {
                void $this$mapTo$iv$iv;
                MultiFieldQueryParser multiFieldQueryParser;
                MultiFieldQueryParser $this$searchEntitiesIds_u24lambda_u243 = multiFieldQueryParser = new MultiFieldQueryParser(entity.getDefaultFields(), this.searchAnalyzer);
                boolean bl = false;
                $this$searchEntitiesIds_u24lambda_u243.setDefaultOperator(QueryParser.Operator.AND);
                Query fieldsQuery = multiFieldQueryParser.parse(searchTerm + " *:*");
                TermQuery typeQuery = new TermQuery(new Term("type", entity.getType()));
                BooleanQuery booleanQuery = new BooleanQuery.Builder().add(fieldsQuery, BooleanClause.Occur.MUST).add((Query)typeQuery, BooleanClause.Occur.MUST).build();
                IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
                TopDocs topDocs = searcher.search((Query)booleanQuery, 1000);
                Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
                Object[] $this$map$iv = topDocs.scoreDocs;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ScoreDoc scoreDoc = (ScoreDoc)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(searcher.storedFields().document(it.doc).get(entity.getId()));
                }
                object2 = (List)destination$iv$iv;
            }
            catch (ParseException parseException) {
                object2 = CollectionsKt.emptyList();
            }
            catch (Exception e) {
                LuceneHelperKt.access$getLogger$p().error((Throwable)e, LuceneHelper::searchEntitiesIds$lambda$5);
                object2 = CollectionsKt.emptyList();
            }
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    public void upgradeIndex() {
        new IndexUpgrader(this.directory, new IndexWriterConfig(this.indexAnalyzer), true).upgrade();
        LuceneHelperKt.access$getLogger$p().info(LuceneHelper::upgradeIndex$lambda$6);
    }

    public void addDocument(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.indexWriter.addDocument((Iterable)doc);
        this.luceneCommitter.commitAndMaybeRefresh();
    }

    public void addDocuments(@NotNull Iterable<Document> docs) {
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        this.indexWriter.addDocuments(docs);
        this.luceneCommitter.commitAndMaybeRefresh();
    }

    public void updateDocument(@NotNull Term term, @NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.indexWriter.updateDocument(term, (Iterable)doc);
        this.luceneCommitter.commitAndMaybeRefresh();
    }

    public void deleteDocuments(@NotNull Term term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Term[] termArray = new Term[]{term};
        this.indexWriter.deleteDocuments(termArray);
        this.luceneCommitter.commitAndMaybeRefresh();
    }

    private static final Object setIndexVersion$lambda$1(LuceneHelper this$0) {
        return "Lucene index version: " + this$0.getIndexVersion();
    }

    private static final Object searchEntitiesIds$lambda$5() {
        return "Error fetching entities from index";
    }

    private static final Object upgradeIndex$lambda$6() {
        return "Lucene index upgraded";
    }
}

