/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.gotson.komga.infrastructure.search.MultiLingualAnalyzer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gotson/komga/infrastructure/search/MultiLingualNGramAnalyzer;", "Lorg/gotson/komga/infrastructure/search/MultiLingualAnalyzer;", "minGram", "", "maxGram", "preserveOriginal", "", "<init>", "(IIZ)V", "createComponents", "Lorg/apache/lucene/analysis/Analyzer$TokenStreamComponents;", "fieldName", "", "komga"})
public final class MultiLingualNGramAnalyzer
extends MultiLingualAnalyzer {
    private final int minGram;
    private final int maxGram;
    private final boolean preserveOriginal;

    public MultiLingualNGramAnalyzer(int minGram, int maxGram, boolean preserveOriginal) {
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.preserveOriginal = preserveOriginal;
    }

    @NotNull
    protected Analyzer.TokenStreamComponents createComponents(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Tokenizer source = (Tokenizer)new StandardTokenizer();
        TokenStream filter = (TokenStream)new CJKWidthFilter((TokenStream)source);
        filter = (TokenStream)new LowerCaseFilter(filter);
        filter = (TokenStream)new CJKBigramFilter(filter);
        filter = (TokenStream)new NGramTokenFilter(filter, this.minGram, this.maxGram, this.preserveOriginal);
        filter = (TokenStream)new ASCIIFoldingFilter(filter);
        return new Analyzer.TokenStreamComponents(source, filter);
    }
}

