/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security.session;

import com.github.gotson.spring.session.caffeine.CaffeineIndexedSessionRepository;
import com.github.gotson.spring.session.caffeine.config.annotation.web.http.EnableCaffeineHttpSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.security.session.SmartHttpSessionIdResolver;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;

@EnableCaffeineHttpSession
@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0006\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0017\u00a8\u0006\u0014"}, d2={"Lorg/gotson/komga/infrastructure/security/session/SessionConfiguration;", "", "<init>", "()V", "sessionCookieName", "", "sessionHeaderName", "cookieSerializer", "Lorg/springframework/session/web/http/CookieSerializer;", "httpSessionIdResolver", "Lorg/springframework/session/web/http/HttpSessionIdResolver;", "customizeSessionRepository", "Lorg/springframework/session/config/SessionRepositoryCustomizer;", "Lcom/github/gotson/spring/session/caffeine/CaffeineIndexedSessionRepository;", "serverProperties", "Lorg/springframework/boot/autoconfigure/web/ServerProperties;", "sessionRegistry", "Lorg/springframework/security/core/session/SessionRegistry;", "sessionRepository", "Lorg/springframework/session/FindByIndexNameSessionRepository;", "komga"})
public class SessionConfiguration {
    @Bean
    @NotNull
    public String sessionCookieName() {
        return "KOMGA-SESSION";
    }

    @Bean
    @NotNull
    public String sessionHeaderName() {
        return "X-Auth-Token";
    }

    @Bean
    @NotNull
    public CookieSerializer cookieSerializer(@NotNull String sessionCookieName) {
        DefaultCookieSerializer defaultCookieSerializer;
        Intrinsics.checkNotNullParameter((Object)sessionCookieName, (String)"sessionCookieName");
        DefaultCookieSerializer $this$cookieSerializer_u24lambda_u240 = defaultCookieSerializer = new DefaultCookieSerializer();
        boolean bl = false;
        $this$cookieSerializer_u24lambda_u240.setCookieName(sessionCookieName);
        return (CookieSerializer)defaultCookieSerializer;
    }

    @Bean
    @NotNull
    public HttpSessionIdResolver httpSessionIdResolver(@NotNull String sessionHeaderName, @NotNull CookieSerializer cookieSerializer) {
        Intrinsics.checkNotNullParameter((Object)sessionHeaderName, (String)"sessionHeaderName");
        Intrinsics.checkNotNullParameter((Object)cookieSerializer, (String)"cookieSerializer");
        return (HttpSessionIdResolver)new SmartHttpSessionIdResolver(sessionHeaderName, cookieSerializer);
    }

    @Bean
    @NotNull
    public SessionRepositoryCustomizer<CaffeineIndexedSessionRepository> customizeSessionRepository(@NotNull ServerProperties serverProperties) {
        Intrinsics.checkNotNullParameter((Object)serverProperties, (String)"serverProperties");
        return arg_0 -> SessionConfiguration.customizeSessionRepository$lambda$1(serverProperties, arg_0);
    }

    @Bean
    @NotNull
    public SessionRegistry sessionRegistry(@NotNull FindByIndexNameSessionRepository<?> sessionRepository) {
        Intrinsics.checkNotNullParameter(sessionRepository, (String)"sessionRepository");
        return (SessionRegistry)new SpringSessionBackedSessionRegistry(sessionRepository);
    }

    private static final void customizeSessionRepository$lambda$1(ServerProperties $serverProperties, CaffeineIndexedSessionRepository it) {
        it.setDefaultMaxInactiveInterval(Integer.valueOf((int)$serverProperties.getServlet().getSession().getTimeout().getSeconds()));
    }
}

