/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.web;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0006\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u0006\u0010\u000e\u001a\u00020\u000f\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"toFilePath", "", "Ljava/net/URL;", "filePathToUrl", "filePath", "setCachePrivate", "Lorg/springframework/http/ResponseEntity$BodyBuilder;", "cachePrivate", "Lorg/springframework/http/CacheControl;", "getCachePrivate", "()Lorg/springframework/http/CacheControl;", "getMediaTypeOrDefault", "Lorg/springframework/http/MediaType;", "mediaTypeString", "getCurrentRequest", "Ljakarta/servlet/http/HttpServletRequest;", "komga"})
public final class UtilsKt {
    @NotNull
    private static final CacheControl cachePrivate;

    @NotNull
    public static final String toFilePath(@NotNull URL $this$toFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$toFilePath, (String)"<this>");
        URI uRI = $this$toFilePath.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Path path = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return ((Object)path).toString();
    }

    @NotNull
    public static final URL filePathToUrl(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        URL uRL = Paths.get(filePath, new String[0]).toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public static final ResponseEntity.BodyBuilder setCachePrivate(@NotNull ResponseEntity.BodyBuilder $this$setCachePrivate) {
        Intrinsics.checkNotNullParameter((Object)$this$setCachePrivate, (String)"<this>");
        ResponseEntity.HeadersBuilder headersBuilder = $this$setCachePrivate.cacheControl(cachePrivate);
        Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"cacheControl(...)");
        return (ResponseEntity.BodyBuilder)headersBuilder;
    }

    @NotNull
    public static final CacheControl getCachePrivate() {
        return cachePrivate;
    }

    @NotNull
    public static final MediaType getMediaTypeOrDefault(@Nullable String mediaTypeString) {
        String string = mediaTypeString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            try {
                MediaType mediaType = MediaType.parseMediaType((String)mediaTypeString);
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"parseMediaType(...)");
                return mediaType;
            }
            catch (Exception exception) {
            }
        }
        MediaType mediaType = MediaType.APPLICATION_OCTET_STREAM;
        Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"APPLICATION_OCTET_STREAM");
        return mediaType;
    }

    @NotNull
    public static final HttpServletRequest getCurrentRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null || (servletRequestAttributes = servletRequestAttributes.getRequest()) == null) {
            throw new IllegalStateException("Could not get current request");
        }
        return servletRequestAttributes;
    }

    static {
        CacheControl cacheControl = CacheControl.maxAge((long)0L, (TimeUnit)TimeUnit.SECONDS).cachePrivate().mustRevalidate();
        Intrinsics.checkNotNullExpressionValue((Object)cacheControl, (String)"mustRevalidate(...)");
        cachePrivate = cacheControl;
    }
}

