/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.model.UserRoles;
import org.gotson.komga.domain.service.KomgaUserLifecycle;
import org.gotson.komga.interfaces.api.rest.ClaimController;
import org.gotson.komga.interfaces.api.rest.dto.UserDto;
import org.gotson.komga.interfaces.api.rest.dto.UserDtoKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/claim"}, produces={"application/json"})
@Tag(name="Claim")
@Validated
@SecurityRequirements
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\u001c\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ClaimController;", "", "userDetailsLifecycle", "Lorg/gotson/komga/domain/service/KomgaUserLifecycle;", "<init>", "(Lorg/gotson/komga/domain/service/KomgaUserLifecycle;)V", "getClaimStatus", "Lorg/gotson/komga/interfaces/api/rest/ClaimController$ClaimStatus;", "claimServer", "Lorg/gotson/komga/interfaces/api/rest/dto/UserDto;", "email", "", "password", "ClaimStatus", "komga"})
public class ClaimController {
    @NotNull
    private final KomgaUserLifecycle userDetailsLifecycle;

    public ClaimController(@NotNull KomgaUserLifecycle userDetailsLifecycle) {
        Intrinsics.checkNotNullParameter((Object)userDetailsLifecycle, (String)"userDetailsLifecycle");
        this.userDetailsLifecycle = userDetailsLifecycle;
    }

    @GetMapping
    @Operation(summary="Retrieve claim status", description="Check whether this server has already been claimed.")
    @NotNull
    public ClaimStatus getClaimStatus() {
        return new ClaimStatus(this.userDetailsLifecycle.countUsers() > 0L);
    }

    @PostMapping
    @Operation(summary="Claim server", description="Creates an admin user with the provided credentials.")
    @NotNull
    public UserDto claimServer(@Email(regexp=".+@.+\\..+") @RequestHeader(value="X-Komga-Email") @NotNull String email, @NotBlank @RequestHeader(value="X-Komga-Password") @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (this.userDetailsLifecycle.countUsers() > 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "This server has already been claimed");
        }
        return UserDtoKt.toDto((KomgaUser)this.userDetailsLifecycle.createUser(new KomgaUser(email, password, CollectionsKt.toSet((Iterable)((Iterable)UserRoles.getEntries())), null, false, null, null, null, null, 504, null)));
    }
}

