/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.infrastructure.jooq.main.ClientSettingsDtoDao;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.dto.ClientSettingDto;
import org.gotson.komga.interfaces.api.rest.dto.ClientSettingGlobalUpdateDto;
import org.gotson.komga.interfaces.api.rest.dto.ClientSettingUserUpdateDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/client-settings"}, produces={"application/json"})
@Tag(name="Client settings")
@Validated
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J_\u0010\r\u001a\u00020\u000e2U\b\u0001\u0010\u000f\u001aO\u0012+\u0012)0\b\u00a2\u0006$\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0006\b\u0013\u0012\u0002\b\f\u0012\u0006\b\u0014\u0012\u0002\b\f\u0012\u0006\b\u0015\u0012\u0002\b\f\u0012\u001e\u0012\u001c0\u0016\u00a2\u0006\u0012\b\u0017\u0012\u0006\b\u0014\u0012\u0002\b\f\u0012\u0006\b\u0015\u0012\u0002\b\f\u00a2\u0006\u0002\b\u00180\u0007H\u0017Ji\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\n\u001a\u00020\u000b2U\b\u0001\u0010\u000f\u001aO\u0012+\u0012)0\b\u00a2\u0006$\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0006\b\u0013\u0012\u0002\b\f\u0012\u0006\b\u0014\u0012\u0002\b\f\u0012\u0006\b\u0015\u0012\u0002\b\f\u0012\u001e\u0012\u001c0\u001a\u00a2\u0006\u0012\b\u0017\u0012\u0006\b\u0014\u0012\u0002\b\f\u0012\u0006\b\u0015\u0012\u0002\b\f\u00a2\u0006\u0002\b\u00180\u0007H\u0017J?\u0010\u001b\u001a\u00020\u000e25\b\u0001\u0010\u001c\u001a/\u0012+\u0012)0\b\u00a2\u0006$\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0006\b\u0013\u0012\u0002\b\f\u0012\u0006\b\u0014\u0012\u0002\b\f\u0012\u0006\b\u0015\u0012\u0002\b\f0\u001dH\u0017JI\u0010\u001e\u001a\u00020\u000e2\b\b\u0001\u0010\n\u001a\u00020\u000b25\b\u0001\u0010\u001c\u001a/\u0012+\u0012)0\b\u00a2\u0006$\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0006\b\u0013\u0012\u0002\b\f\u0012\u0006\b\u0014\u0012\u0002\b\f\u0012\u0006\b\u0015\u0012\u0002\b\f0\u001dH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ClientSettingsController;", "", "clientSettingsDtoDao", "Lorg/gotson/komga/infrastructure/jooq/main/ClientSettingsDtoDao;", "<init>", "(Lorg/gotson/komga/infrastructure/jooq/main/ClientSettingsDtoDao;)V", "getGlobalSettings", "", "", "Lorg/gotson/komga/interfaces/api/rest/dto/ClientSettingDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "getUserSettings", "saveGlobalSetting", "", "newSettings", "Ljakarta/validation/constraints/Pattern;", "regexp", "^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$", "flags", "groups", "payload", "Lorg/gotson/komga/interfaces/api/rest/dto/ClientSettingGlobalUpdateDto;", "Ljakarta/validation/constraints/NotNull;", "Ljakarta/validation/Valid;", "saveUserSetting", "Lorg/gotson/komga/interfaces/api/rest/dto/ClientSettingUserUpdateDto;", "deleteGlobalSettings", "keysToDelete", "", "deleteUserSettings", "komga"})
@SourceDebugExtension(value={"SMAP\nClientSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSettingsController.kt\norg/gotson/komga/interfaces/api/rest/ClientSettingsController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n216#2,2:178\n216#2,2:180\n*S KotlinDebug\n*F\n+ 1 ClientSettingsController.kt\norg/gotson/komga/interfaces/api/rest/ClientSettingsController\n*L\n88#1:178,2\n126#1:180,2\n*E\n"})
public class ClientSettingsController {
    @NotNull
    private final ClientSettingsDtoDao clientSettingsDtoDao;

    public ClientSettingsController(@NotNull ClientSettingsDtoDao clientSettingsDtoDao) {
        Intrinsics.checkNotNullParameter((Object)clientSettingsDtoDao, (String)"clientSettingsDtoDao");
        this.clientSettingsDtoDao = clientSettingsDtoDao;
    }

    @GetMapping(value={"global/list"})
    @Operation(summary="Retrieve global client settings", description="For unauthenticated users, only settings with 'allowUnauthorized=true' will be returned.")
    @SecurityRequirements
    @NotNull
    public Map<String, ClientSettingDto> getGlobalSettings(@AuthenticationPrincipal @Nullable KomgaPrincipal principal) {
        return this.clientSettingsDtoDao.findAllGlobal(principal == null);
    }

    @GetMapping(value={"user/list"})
    @Operation(summary="Retrieve user client settings")
    @NotNull
    public Map<String, ClientSettingDto> getUserSettings(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return this.clientSettingsDtoDao.findAllUser(principal.getUser().getId());
    }

    @PatchMapping(value={"global"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Save global settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="{\n              \"application.key1\": {\n                \"value\": \"a string value\",\n                \"allowUnauthorized\": true\n              },\n              \"application.key2\": {\n                \"value\": \"{\\\"json\\\":\\\"object\\\"}\",\n                \"allowUnauthorized\": false\n              }\n            }\n            ")})})
    public void saveGlobalSetting(@RequestBody @NotNull Map<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String, @jakarta.validation.constraints.NotNull @Valid ClientSettingGlobalUpdateDto> newSettings) {
        Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
        Map<String, ClientSettingGlobalUpdateDto> $this$forEach$iv = newSettings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ClientSettingGlobalUpdateDto>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ClientSettingGlobalUpdateDto> element$iv;
            Map.Entry<String, ClientSettingGlobalUpdateDto> entry = element$iv = iterator.next();
            boolean bl = false;
            String key2 = entry.getKey();
            ClientSettingGlobalUpdateDto setting = entry.getValue();
            this.clientSettingsDtoDao.saveGlobal(key2, setting.getValue(), setting.getAllowUnauthorized());
        }
    }

    @PatchMapping(value={"user"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Save user settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="{\n              \"application.key1\": {\n                \"value\": \"a string value\"\n              },\n              \"application.key2\": {\n                \"value\": \"{\\\"json\\\":\\\"object\\\"}\"\n              }\n            }\n            ")})})
    public void saveUserSetting(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull Map<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String, @jakarta.validation.constraints.NotNull @Valid ClientSettingUserUpdateDto> newSettings) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
        Map<String, ClientSettingUserUpdateDto> $this$forEach$iv = newSettings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ClientSettingUserUpdateDto>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ClientSettingUserUpdateDto> element$iv;
            Map.Entry<String, ClientSettingUserUpdateDto> entry = element$iv = iterator.next();
            boolean bl = false;
            String key2 = entry.getKey();
            ClientSettingUserUpdateDto setting = entry.getValue();
            this.clientSettingsDtoDao.saveForUser(principal.getUser().getId(), key2, setting.getValue());
        }
    }

    @DeleteMapping(value={"global"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Delete global settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="[\"application.key1\", \"application.key2\"]")})})
    public void deleteGlobalSettings(@RequestBody @NotNull Set<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String> keysToDelete) {
        Intrinsics.checkNotNullParameter(keysToDelete, (String)"keysToDelete");
        this.clientSettingsDtoDao.deleteGlobalByKeys((Collection)keysToDelete);
    }

    @DeleteMapping(value={"user"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete user settings", description="Setting key should be a valid lowercase namespace string like 'application.domain.key'")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="[\"application.key1\", \"application.key2\"]")})})
    public void deleteUserSettings(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull Set<@Pattern(regexp="^[a-z](?:[a-z0-9_-]*[a-z0-9])*(?:\\.[a-z0-9](?:[a-z0-9_-]*[a-z0-9])*)*$") String> keysToDelete) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter(keysToDelete, (String)"keysToDelete");
        this.clientSettingsDtoDao.deleteByUserIdAndKeys(principal.getUser().getId(), (Collection)keysToDelete);
    }
}

