/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gotson.komga.interfaces.api.rest.DirectoryListingDto;
import org.gotson.komga.interfaces.api.rest.DirectoryRequestDto;
import org.gotson.komga.interfaces.api.rest.FileSystemControllerKt;
import org.gotson.komga.interfaces.api.rest.PathDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/filesystem"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Tag(name="File system")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u0017R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gotson/komga/interfaces/api/rest/FileSystemController;", "", "<init>", "()V", "fs", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "getDirectoryListing", "Lorg/gotson/komga/interfaces/api/rest/DirectoryListingDto;", "request", "Lorg/gotson/komga/interfaces/api/rest/DirectoryRequestDto;", "komga"})
@SourceDebugExtension(value={"SMAP\nFileSystemController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemController.kt\norg/gotson/komga/interfaces/api/rest/FileSystemController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1563#2:92\n1634#2,3:93\n3301#2,10:96\n*S KotlinDebug\n*F\n+ 1 FileSystemController.kt\norg/gotson/komga/interfaces/api/rest/FileSystemController\n*L\n38#1:92\n38#1:93,3\n54#1:96,10\n*E\n"})
public class FileSystemController {
    private final FileSystem fs = FileSystems.getDefault();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @PostMapping
    @Operation(summary="Directory listing", description="List folders and files from the host server's file system. If no request body is passed then the root directories are returned.")
    @NotNull
    public DirectoryListingDto getDirectoryListing(@RequestBody(required=false) @NotNull DirectoryRequestDto request) {
        DirectoryListingDto directoryListingDto;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (((CharSequence)request.getPath()).length() == 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<Path> iterable = this.fs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
            Iterable<Path> iterable2 = iterable;
            String string = null;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(FileSystemControllerKt.toDto((Path)it));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 1;
            List list = CollectionsKt.emptyList();
            List list2 = (List)destination$iv$iv;
            String string2 = string;
            directoryListingDto = new DirectoryListingDto(string2, list2, list, n, defaultConstructorMarker);
        } else {
            Pair pair;
            Path path = this.fs.getPath(request.getPath(), new String[0]);
            if (!path.isAbsolute()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Path must be absolute");
            }
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Path directory = Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : path.getParent();
            try {
                Pair pair2;
                AutoCloseable destination$iv$iv = Files.list(directory);
                Throwable $i$f$mapTo = null;
                try {
                    void $this$partition$iv;
                    Stream dirStream = (Stream)destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)dirStream);
                    Object it = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
                    it = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)dirStream), arg_0 -> FileSystemController.getDirectoryListing$lambda$5$lambda$1(request, arg_0)), (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)), FileSystemController::getDirectoryListing$lambda$5$lambda$3));
                    boolean $i$f$partition = false;
                    ArrayList first$iv = new ArrayList();
                    ArrayList second$iv = new ArrayList();
                    for (Object element$iv : $this$partition$iv) {
                        PathDto it2 = (PathDto)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = Intrinsics.areEqual((Object)it2.getType(), (Object)"directory") ? first$iv.add(element$iv) : second$iv.add(element$iv);
                    }
                    pair2 = new Pair(first$iv, second$iv);
                }
                catch (Throwable throwable) {
                    $i$f$mapTo = throwable;
                    throw throwable;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)destination$iv$iv, (Throwable)$i$f$mapTo);
                }
                pair = pair2;
                List directories = (List)pair.component1();
                List files = (List)pair.component2();
                Path path2 = path.getParent();
                pair = new DirectoryListingDto((path2 != null ? (Comparable)path2 : (Comparable)((Object)"")).toString(), directories, files);
            }
            catch (Exception e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Path does not exist");
            }
            directoryListingDto = pair;
        }
        return directoryListingDto;
    }

    public static /* synthetic */ DirectoryListingDto getDirectoryListing$default(FileSystemController fileSystemController, DirectoryRequestDto directoryRequestDto, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDirectoryListing");
        }
        if ((n & 1) != 0) {
            directoryRequestDto = new DirectoryRequestDto(null, false, 3, null);
        }
        return fileSystemController.getDirectoryListing(directoryRequestDto);
    }

    private static final boolean getDirectoryListing$lambda$5$lambda$1(DirectoryRequestDto $request, Path it) {
        return !Files.isHidden(it) && (!$request.getShowFiles() ? Files.isDirectory(it, new LinkOption[0]) : true);
    }

    private static final PathDto getDirectoryListing$lambda$5$lambda$3(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return FileSystemControllerKt.toDto((Path)it);
    }
}

