/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.infrastructure.openapi.PageableAsQueryParam;
import org.gotson.komga.interfaces.api.persistence.HistoricalEventDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.HistoricalEventDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/history"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Tag(name="History")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gotson/komga/interfaces/api/rest/HistoricalEventController;", "", "historicalEventDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/HistoricalEventDtoRepository;", "<init>", "(Lorg/gotson/komga/interfaces/api/persistence/HistoricalEventDtoRepository;)V", "getHistoricalEvents", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/HistoricalEventDto;", "page", "Lorg/springframework/data/domain/Pageable;", "komga"})
public class HistoricalEventController {
    @NotNull
    private final HistoricalEventDtoRepository historicalEventDtoRepository;

    public HistoricalEventController(@NotNull HistoricalEventDtoRepository historicalEventDtoRepository) {
        Intrinsics.checkNotNullParameter((Object)historicalEventDtoRepository, (String)"historicalEventDtoRepository");
        this.historicalEventDtoRepository = historicalEventDtoRepository;
    }

    @GetMapping
    @PageableAsQueryParam
    @Operation(summary="List historical events")
    @NotNull
    public Page<HistoricalEventDto> getHistoricalEvents(@Parameter(hidden=true) @NotNull Pageable page) {
        Sort sort;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getSort().isSorted()) {
            sort = page.getSort();
        } else {
            Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.desc((String)"timestamp")};
            sort = Sort.by((Sort.Order[])orderArray);
        }
        Sort sort2 = sort;
        Intrinsics.checkNotNull((Object)sort2);
        Sort sort3 = sort2;
        PageRequest pageRequest = PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)sort3);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageRequest2 = pageRequest;
        return this.historicalEventDtoRepository.findAll((Pageable)pageRequest2);
    }
}

