/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.dto.GithubReleaseDto;
import org.gotson.komga.interfaces.api.rest.dto.ReleaseDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriBuilder;

@RestController
@PreAuthorize(value="hasRole('ADMIN')")
@RequestMapping(value={"api/v1/releases"}, produces={"application/json"})
@Tag(name="Releases")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gotson/komga/interfaces/api/rest/ReleaseController;", "", "webClientBuilder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "<init>", "(Lorg/springframework/web/reactive/function/client/WebClient$Builder;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "", "Lorg/gotson/komga/interfaces/api/rest/dto/GithubReleaseDto;", "getReleases", "Lorg/gotson/komga/interfaces/api/rest/dto/ReleaseDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "fetchGitHubReleases", "komga"})
@SourceDebugExtension(value={"SMAP\nReleaseController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseController.kt\norg/gotson/komga/interfaces/api/rest/ReleaseController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1573#2:74\n1604#2,4:75\n*S KotlinDebug\n*F\n+ 1 ReleaseController.kt\norg/gotson/komga/interfaces/api/rest/ReleaseController\n*L\n48#1:74\n48#1:75,4\n*E\n"})
public class ReleaseController {
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final Cache<String, List<GithubReleaseDto>> cache;

    public ReleaseController(@NotNull WebClient.Builder webClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)webClientBuilder, (String)"webClientBuilder");
        WebClient webClient = webClientBuilder.baseUrl("https://api.github.com/repos/gotson/komga/releases").build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        this.webClient = webClient;
        Cache cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="List releases")
    @NotNull
    public List<ReleaseDto> getReleases(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        List list = (List)this.cache.get((Object)"releases", arg_0 -> ReleaseController.getReleases$lambda$1(arg_0 -> ReleaseController.getReleases$lambda$0(this, arg_0), arg_0));
        if (list != null) {
            void $this$mapIndexedTo$iv$iv;
            List releases = list;
            boolean bl = false;
            Iterable $this$mapIndexed$iv = releases;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void ghRel;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                GithubReleaseDto githubReleaseDto = (GithubReleaseDto)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new ReleaseDto(ghRel.getTagName(), ghRel.getPublishedAt(), ghRel.getHtmlUrl(), index == false, ghRel.getPrerelease(), ghRel.getBody()));
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<GithubReleaseDto> fetchGitHubReleases() {
        ResponseEntity response2 = (ResponseEntity)this.webClient.get().uri(ReleaseController::fetchGitHubReleases$lambda$4).retrieve().toEntity((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
        Object object = response2;
        if (object == null || (object = (List)object.getBody()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List getReleases$lambda$0(ReleaseController this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.fetchGitHubReleases();
    }

    private static final List getReleases$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final URI fetchGitHubReleases$lambda$4(UriBuilder it) {
        Object[] objectArray = new Object[]{20};
        return it.queryParam("per_page", objectArray).build(new Object[0]);
    }
}

