/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.persistence.SyncPointRepository;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/syncpoints"}, produces={"application/json"})
@Tag(name="Sync points")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0010\b\u0001\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gotson/komga/interfaces/api/rest/SyncPointController;", "", "syncPointRepository", "Lorg/gotson/komga/domain/persistence/SyncPointRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/SyncPointRepository;)V", "deleteSyncPointsForCurrentUser", "", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "keyIds", "", "", "komga"})
public class SyncPointController {
    @NotNull
    private final SyncPointRepository syncPointRepository;

    public SyncPointController(@NotNull SyncPointRepository syncPointRepository) {
        Intrinsics.checkNotNullParameter((Object)syncPointRepository, (String)"syncPointRepository");
        this.syncPointRepository = syncPointRepository;
    }

    @DeleteMapping(value={"me"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete all sync points", description="If an API Key ID is passed, deletes only the sync points associated with that API Key. Deleting sync points will allow a Kobo to sync from scratch upon the next sync.")
    public void deleteSyncPointsForCurrentUser(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestParam(name="key_id", required=false) @Nullable Collection<String> keyIds) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Collection<String> collection = keyIds;
        if (collection == null || collection.isEmpty()) {
            this.syncPointRepository.deleteByUserId(principal.getUser().getId());
        } else {
            this.syncPointRepository.deleteByUserIdAndApiKeyIds(principal.getUser().getId(), keyIds);
        }
    }
}

