/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.scheduler;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.ReadListRepository;
import org.gotson.komga.domain.persistence.SeriesCollectionRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.SidecarRepository;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0013J\b\u0010'\u001a\u00020$H\u0017J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006*"}, d2={"Lorg/gotson/komga/interfaces/scheduler/MetricsPublisherController;", "", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "collectionRepository", "Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;", "readListRepository", "Lorg/gotson/komga/domain/persistence/ReadListRepository;", "sidecarRepository", "Lorg/gotson/komga/domain/persistence/SidecarRepository;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "<init>", "(Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/SeriesRepository;Lorg/gotson/komga/domain/persistence/SeriesCollectionRepository;Lorg/gotson/komga/domain/persistence/ReadListRepository;Lorg/gotson/komga/domain/persistence/SidecarRepository;Lio/micrometer/core/instrument/MeterRegistry;)V", "entitiesMultiTag", "", "", "entitiesNoTags", "allEntities", "multiGauges", "", "Lio/micrometer/core/instrument/MultiGauge;", "Lkotlin/jvm/internal/EnhancedNullability;", "getMultiGauges", "()Ljava/util/Map;", "noTagGauges", "Ljava/util/concurrent/atomic/AtomicLong;", "getNoTagGauges", "bookFileSizeGauge", "getBookFileSizeGauge", "()Lio/micrometer/core/instrument/MultiGauge;", "pushMetricsOnEvent", "", "event", "Lorg/gotson/komga/domain/model/DomainEvent;", "pushAllMetrics", "pushMetricsCount", "entity", "komga"})
@SourceDebugExtension(value={"SMAP\nMetricsPublisherController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsPublisherController.kt\norg/gotson/komga/interfaces/scheduler/MetricsPublisherController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n1285#2,2:126\n1299#2,4:128\n1285#2,2:132\n1299#2,4:134\n1869#2,2:138\n1869#2,2:140\n1869#2,2:142\n126#3:144\n153#3,3:145\n126#3:148\n153#3,3:149\n126#3:152\n153#3,3:153\n126#3:156\n153#3,3:157\n*S KotlinDebug\n*F\n+ 1 MetricsPublisherController.kt\norg/gotson/komga/interfaces/scheduler/MetricsPublisherController\n*L\n62#1:126,2\n62#1:128,4\n71#1:132,2\n71#1:134,4\n91#1:138,2\n96#1:140,2\n109#1:142,2\n118#1:144\n118#1:145,3\n119#1:148\n119#1:149,3\n120#1:152\n120#1:153,3\n121#1:156\n121#1:157,3\n*E\n"})
public class MetricsPublisherController {
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final SeriesCollectionRepository collectionRepository;
    @NotNull
    private final ReadListRepository readListRepository;
    @NotNull
    private final SidecarRepository sidecarRepository;
    @NotNull
    private final MeterRegistry meterRegistry;
    @NotNull
    private final List<String> entitiesMultiTag;
    @NotNull
    private final List<String> entitiesNoTags;
    @NotNull
    private final List<String> allEntities;
    @NotNull
    private final Map<String, MultiGauge> multiGauges;
    @NotNull
    private final Map<String, AtomicLong> noTagGauges;
    @NotNull
    private final MultiGauge bookFileSizeGauge;

    public MetricsPublisherController(@NotNull LibraryRepository libraryRepository, @NotNull BookRepository bookRepository, @NotNull SeriesRepository seriesRepository, @NotNull SeriesCollectionRepository collectionRepository, @NotNull ReadListRepository readListRepository, @NotNull SidecarRepository sidecarRepository, @NotNull MeterRegistry meterRegistry) {
        Object object;
        String entity;
        Map map;
        Object t;
        Iterable $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)readListRepository, (String)"readListRepository");
        Intrinsics.checkNotNullParameter((Object)sidecarRepository, (String)"sidecarRepository");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.libraryRepository = libraryRepository;
        this.bookRepository = bookRepository;
        this.seriesRepository = seriesRepository;
        this.collectionRepository = collectionRepository;
        this.readListRepository = readListRepository;
        this.sidecarRepository = sidecarRepository;
        this.meterRegistry = meterRegistry;
        Timer.builder((String)"komga.tasks.execution").description("Task execution time").register(this.meterRegistry);
        Counter.builder((String)"komga.tasks.failure").description("Count of failed tasks").register(this.meterRegistry);
        Object object2 = new String[]{"series", "books", "books.filesize", "sidecars"};
        this.entitiesMultiTag = CollectionsKt.listOf((Object[])object2);
        object2 = new String[]{"libraries", "collections", "readlists"};
        this.entitiesNoTags = CollectionsKt.listOf((Object[])object2);
        this.allEntities = CollectionsKt.plus((Collection)this.entitiesMultiTag, (Iterable)this.entitiesNoTags);
        object2 = this.entitiesMultiTag;
        MetricsPublisherController metricsPublisherController = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            object = MultiGauge.builder((String)("komga." + entity)).description("The number of " + entity).baseUnit("count").register(this.meterRegistry);
            map.put(t, object);
        }
        metricsPublisherController.multiGauges = result$iv;
        $this$associateWith$iv = this.entitiesNoTags;
        metricsPublisherController = this;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            AtomicLong atomicLong;
            entity = (String)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            AtomicLong value = atomicLong = new AtomicLong(0L);
            boolean bl2 = false;
            Gauge.builder((String)("komga." + entity), (Object)value, arg_0 -> MetricsPublisherController.noTagGauges$lambda$3$lambda$2$lambda$1(value, arg_0)).description("The number of " + entity).baseUnit("count").register(this.meterRegistry);
            object = atomicLong;
            map.put(t, object);
        }
        metricsPublisherController.noTagGauges = result$iv;
        MultiGauge multiGauge = MultiGauge.builder((String)"komga.books.filesize").description("The cumulated filesize of books").baseUnit("bytes").register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)multiGauge, (String)"register(...)");
        this.bookFileSizeGauge = multiGauge;
    }

    @NotNull
    public Map<String, MultiGauge> getMultiGauges() {
        return this.multiGauges;
    }

    @NotNull
    public Map<String, AtomicLong> getNoTagGauges() {
        return this.noTagGauges;
    }

    @NotNull
    public MultiGauge getBookFileSizeGauge() {
        return this.bookFileSizeGauge;
    }

    @EventListener
    private void pushMetricsOnEvent(DomainEvent event) {
        block5: {
            DomainEvent domainEvent;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    domainEvent = event;
                                    if (!(domainEvent instanceof DomainEvent.LibraryScanned)) break block4;
                                    Iterable $this$forEach$iv = this.entitiesMultiTag;
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        String it = (String)element$iv;
                                        boolean bl = false;
                                        this.pushMetricsCount(it);
                                    }
                                    break block5;
                                }
                                if (!(domainEvent instanceof DomainEvent.LibraryAdded)) break block6;
                                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("libraries");
                                if (atomicLong == null) break block5;
                                atomicLong.incrementAndGet();
                                break block5;
                            }
                            if (!(domainEvent instanceof DomainEvent.LibraryDeleted)) break block7;
                            AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("libraries");
                            if (atomicLong != null) {
                                atomicLong.decrementAndGet();
                            }
                            Iterable $this$forEach$iv = this.entitiesMultiTag;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                this.pushMetricsCount(it);
                            }
                            break block5;
                        }
                        if (!(domainEvent instanceof DomainEvent.CollectionAdded)) break block8;
                        AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("collections");
                        if (atomicLong == null) break block5;
                        atomicLong.incrementAndGet();
                        break block5;
                    }
                    if (!(domainEvent instanceof DomainEvent.CollectionDeleted)) break block9;
                    AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("collections");
                    if (atomicLong == null) break block5;
                    atomicLong.decrementAndGet();
                    break block5;
                }
                if (!(domainEvent instanceof DomainEvent.ReadListAdded)) break block10;
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("readlists");
                if (atomicLong == null) break block5;
                atomicLong.incrementAndGet();
                break block5;
            }
            if (!(domainEvent instanceof DomainEvent.ReadListDeleted)) break block5;
            AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("readlists");
            if (atomicLong != null) {
                atomicLong.decrementAndGet();
            }
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void pushAllMetrics() {
        Iterable $this$forEach$iv = this.allEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.pushMetricsCount(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void pushMetricsCount(String entity) {
        switch (entity) {
            case "libraries": {
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("libraries");
                if (atomicLong != null) {
                    atomicLong.set(this.libraryRepository.count());
                }
                break;
            }
            case "collections": {
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("collections");
                if (atomicLong != null) {
                    atomicLong.set(this.collectionRepository.count());
                }
                break;
            }
            case "readlists": {
                AtomicLong atomicLong = (AtomicLong)this.getNoTagGauges().get("readlists");
                if (atomicLong != null) {
                    atomicLong.set(this.readListRepository.count());
                }
                break;
            }
            case "series": {
                MultiGauge multiGauge = (MultiGauge)this.getMultiGauges().get("series");
                if (multiGauge != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Map map = this.seriesRepository.countGroupedByLibraryId();
                    MultiGauge multiGauge2 = multiGauge;
                    boolean $i$f$map = false;
                    void var6_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                    }
                    multiGauge2.register((Iterable)((List)destination$iv$iv), true);
                }
                break;
            }
            case "books": {
                MultiGauge multiGauge = (MultiGauge)this.getMultiGauges().get("books");
                if (multiGauge != null) {
                    Map $this$map$iv = this.bookRepository.countGroupedByLibraryId();
                    MultiGauge multiGauge3 = multiGauge;
                    boolean $i$f$map2 = false;
                    Map $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo2 = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry item$iv$iv2;
                        Map.Entry it = item$iv$iv2 = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                    }
                    multiGauge3.register((Iterable)((List)destination$iv$iv), true);
                }
                break;
            }
            case "books.filesize": {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map map = this.bookRepository.getFilesizeGroupedByLibraryId();
                MultiGauge multiGauge = this.getBookFileSizeGauge();
                boolean $i$f$map = false;
                void $i$f$map2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator $i$f$mapTo2 = $this$mapTo$iv$iv.entrySet().iterator();
                while ($i$f$mapTo2.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry item$iv$iv2 = item$iv$iv = $i$f$mapTo2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                }
                multiGauge.register((Iterable)((List)destination$iv$iv), true);
                break;
            }
            case "sidecars": {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                MultiGauge multiGauge = (MultiGauge)this.getMultiGauges().get("sidecars");
                if (multiGauge == null) break;
                Map $i$f$map = this.sidecarRepository.countGroupedByLibraryId();
                MultiGauge multiGauge4 = multiGauge;
                boolean $i$f$map3 = false;
                void destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry bl = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(MultiGauge.Row.of((Tags)Tags.of((String)"library", (String)((String)it.getKey())), (Number)((Number)it.getValue())));
                }
                multiGauge4.register((Iterable)((List)destination$iv$iv2), true);
                break;
            }
        }
    }

    private static final double noTagGauges$lambda$3$lambda$2$lambda$1(AtomicLong $value, AtomicLong it) {
        return $value.get();
    }
}

