PRAGMA foreign_keys= OFF;

ALTER TABLE BOOK_METADATA
    RENAME TO _BOOK_METADATA_OLD;

CREATE TABLE BOOK_METADATA
(
    CREATED_DATE       datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    LAST_MODIFIED_DATE datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    NUMBER             varchar  NOT NULL,
    NUMBER_LOCK        boolean  NOT NULL DEFAULT 0,
    NUMBER_SORT        real     NOT NULL,
    NUMBER_SORT_LOCK   boolean  NOT NULL DEFAULT 0,
    RELEASE_DATE       date     NULL,
    RELEASE_DATE_LOCK  boolean  NOT NULL DEFAULT 0,
    SUMMARY            varchar  NOT NULL DEFAULT '',
    SUMMARY_LOCK       boolean  NOT NULL DEFAULT 0,
    TITLE              varchar  NOT NULL,
    TITLE_LOCK         boolean  NOT NULL DEFAULT 0,
    AUTHORS_LOCK       boolean  NOT NULL DEFAULT 0,
    TAGS_LOCK          boolean  NOT NULL DEFAULT 0,
    BOOK_ID            varchar  NOT NULL PRIMARY KEY,
    FOREIGN KEY (BOOK_ID) REFERENCES BOOK (ID)
);

INSERT INTO BOOK_METADATA (CREATED_DATE, LAST_MODIFIED_DATE, NUMBER, NUMBER_LOCK, NUMBER_SORT, NUMBER_SORT_LOCK,
                           RELEASE_DATE, RELEASE_DATE_LOCK, SUMMARY, SUMMARY_LOCK, TITLE, TITLE_LOCK, AUTHORS_LOCK,
                           BOOK_ID)
SELECT CREATED_DATE,
       LAST_MODIFIED_DATE,
       NUMBER,
       NUMBER_LOCK,
       NUMBER_SORT,
       NUMBER_SORT_LOCK,
       RELEASE_DATE,
       RELEASE_DATE_LOCK,
       SUMMARY,
       SUMMARY_LOCK,
       TITLE,
       TITLE_LOCK,
       AUTHORS_LOCK,
       BOOK_ID
FROM _BOOK_METADATA_OLD;

DROP TABLE _BOOK_METADATA_OLD;

PRAGMA foreign_keys= ON;
