ALTER TABLE THUMBNAIL_SERIES RENAME TO TMP_THUMBNAIL_SERIES;

CREATE TABLE THUMBNAIL_SERIES
(
    ID                  varchar  NOT NULL PRIMARY KEY,
    URL                 varchar  NULL DEFAULT NULL,
    SELECTED            boolean  NOT NULL DEFAULT 0,
    THUMBNAIL           blob  NULL DEFAULT NULL,
    TYPE                varchar not null,
    CREATED_DATE        datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    LAST_MODIFIED_DATE  datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    SERIES_ID           varchar  NOT NULL,
    FOREIGN KEY (SERIES_ID) REFERENCES SERIES (ID)
);

INSERT INTO THUMBNAIL_SERIES(ID, URL, SELECTED, CREATED_DATE, LAST_MODIFIED_DATE, SERIES_ID, TYPE)
SELECT ID, URL, SELECTED, CREATED_DATE, LAST_MODIFIED_DATE, SERIES_ID, "SIDECAR" AS TYPE
FROM TMP_THUMBNAIL_SERIES;

DROP TABLE TMP_THUMBNAIL_SERIES;
