# Configuration for Vaultwarden

https://github.com/ViViDboarder/vaultwarden_ldap will send an invitation to any member of the group `vaultwarden`.

Replace `dc=example,dc=com` with your LLDAP configured domain.

`docker-compose.yml` to run `vaultwarden_ldap`
```
version: '3'
services:
  ldap_sync:
    image: vividboarder/vaultwarden_ldap:2.0.2
    volumes:
      - ./config.toml:/config.toml:ro
    environment:
      CONFIG_PATH: /config.toml
    restart: always
```
Configuration to use LDAP in `config.toml`
```toml
vaultwarden_url = "http://your_bitwarden_url:port"
vaultwarden_admin_token = "insert_admin_token_vaultwarden"
ldap_host = "insert_ldap_host"
ldap_port = 3890
ldap_ssl  = false # true if using LDAPS
ldap_bind_dn = "uid=admin,ou=people,dc=example,dc=com"
ldap_bind_password = "insert_admin_pw_ldap"
ldap_search_base_dn = "dc=example,dc=com"
ldap_search_filter = "(&(objectClass=person)(memberOf=uid=vaultwarden,ou=groups,dc=example,dc=com))"
ldap_sync_interval_seconds = 300
```
Will check every 300 seconds your ldap group ```vaultwarden``` and send an invitation by email to any new member of this group.
