#!/usr/bin/bash
#
#   git-lfs.sh - function for handling the download and "extraction" of Git-lfs sources
#
#   Copyright (c) 2020 bartus <git-lfs@bartus.33mail.com>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

function download_git-lfs {
  local url="${1/git-lfs+/git+}" dir
  dir="$SRCDEST/$(get_filename "$url")"
  download_git "$url"
  git -C "$dir" lfs install --worktree
  git -C "$dir" lfs fetch
}

function extract_git-lfs {
  local url="${1/git-lfs+/git+}" dir
  dir="$srcdir/$(get_filename "$url")"
  extract_git "$url"
  git -C "$dir" lfs install --worktree
  git -C "$dir" lfs pull
}

