# @ai-sdk/anthropic

## 3.0.9

### Patch Changes

- de2399b: fix(anthropic): assign type urls in file parts correctly

## 3.0.8

### Patch Changes

- bee4f82: fix(anthropic): enable structured output support for claude-haiku-4-5

  This fixes an issue where the `strict: true` property was not included in the request body when using tools with Claude Haiku 4.5, because `supportsStructuredOutput` was incorrectly set to `false` for this model.

  Claude Haiku 4.5 supports structured outputs, so the `strict` property should be forwarded to the Anthropic API when specified on tools.

## 3.0.7

### Patch Changes

- Updated dependencies [d937c8f]
  - @ai-sdk/provider@3.0.2
  - @ai-sdk/provider-utils@4.0.4

## 3.0.6

### Patch Changes

- 2231e84: fix(anthropic): implement temperature/topP mutual exclusivity

  Resolves the Anthropic API breaking change where sampling parameters must use only `temperature` OR `top_p`, not both. When both parameters are provided:

  - Temperature takes priority and topP is ignored
  - A warning is added to inform users: "topP is not supported when temperature is set. topP is ignored."
  - The validation only runs when thinking mode is not enabled (thinking mode has its own parameter validation)

  See Anthropic migration guide: https://platform.claude.com/docs/en/about-claude/models/migrating-to-claude-4

## 3.0.5

### Patch Changes

- Updated dependencies [0b429d4]
  - @ai-sdk/provider-utils@4.0.3

## 3.0.4

### Patch Changes

- bf39dac: Fix: Use provider tool name in Tool Search Tool results

## 3.0.3

### Patch Changes

- 77b760d: fix(anthropic): support deferred results for web search/fetch tool

## 3.0.2

### Patch Changes

- 863d34f: fix: trigger release to update `@latest`
- Updated dependencies [863d34f]
  - @ai-sdk/provider@3.0.1
  - @ai-sdk/provider-utils@4.0.2

## 3.0.1

### Patch Changes

- Updated dependencies [29264a3]
  - @ai-sdk/provider-utils@4.0.1

## 3.0.0

### Major Changes

- dee8b05: ai SDK 6 beta

### Minor Changes

- 78928cb: release: start 5.1 beta

### Patch Changes

- 0c3b58b: fix(provider): add specificationVersion to ProviderV3
- 0adc679: feat(provider): shared spec v3
- 50b70d6: feat(anthropic): add programmatic tool calling
- b8ea36e: feat(provider/anthropic): Anthropic-native structured outputs
- ed537e1: Add support for pdf file in tool result in anthropic
- 2109385: 'fix(anthropic): Opus 4.5 `maxOutputTokens` bump `32000` -> `64000`'
- 7c4328e: Adds url-based pdf and image support for anthropic tool results
- 8d9e8ad: chore(provider): remove generics from EmbeddingModelV3

  Before

  ```ts
  model.textEmbeddingModel('my-model-id');
  ```

  After

  ```ts
  model.embeddingModel('my-model-id');
  ```

- f33a018: chore: add model ID for Haiku 4.5
- b2dbfbf: add context_management for anthropic
- dce03c4: feat: tool input examples
- 2625a04: feat(openai); update spec for mcp approval
- 11e4abe: feat(provider/anthropic): web search tool updates
- f13958c: chore(antropic): allow custom names for provider-defined tools
- afb00e3: feat(provider/anthropic): add text_editor_20250728 tool support

  Add text_editor_20250728 tool for Claude 4 models (Sonnet 4, Opus 4, Opus 4.1) with optional max_characters parameter and no undo_edit command support.

- 95f65c2: chore: use import \* from zod/v4
- 954c356: feat(openai): allow custom names for provider-defined tools
- 9e35785: fix(anthropic): send {} as tool input when streaming tool calls without arguments
- 544d4e8: chore(specification): rename v3 provider defined tool to provider tool
- a5f77a6: fix(anthropic): remove outdated tool name docs
- ca07285: feat(anthropic): add prompt caching validation
- a5a8db4: chore: add model ID for Sonnet 4.5
- 1742445: Support for custom provider name in google and anthropic providers
- e8109d3: feat: tool execution approval
- 87db851: fix(vertex/anthropic): passing beta header only for structured outputs
- f6603b7: fix(provider/anthropic): correct raw usage information
- ed329cb: feat: `Provider-V3`
- 3bd2689: feat: extended token usage
- 1cad0ab: feat: add provider version to user-agent header
- 2049c5b: Fix handling of error in web fetch tool in anthropic
- 4c5a6be: feat(provider/anthropic): default and limit maxTokens based on model
- 9e1e758: fix(anthropic): use default thinking budget when unspecified
- 589a4ee: fix(anthropic): simplify pulling first chunk
- 8dac895: feat: `LanguageModelV3`
- 6f845b4: Add support for 2025-08-25 code execution tool
- 9354297: feat(provider/anthropic): add support for Agent Skills
- 03849b0: throw 500 error when the first stream chunk is an error
- 0ae783e: feat(anthropic): add the new tool search tools
- 457318b: chore(provider,ai): switch to SharedV3Warning and unified warnings
- eb56fc6: fix(anthropic): pull first chunk without async IIFE
- fa35e95: feat(provider/anthropic): add web fetch tool
- 80894b3: add return `file_id` property for anthropic code-execution-20250825 to download output files.
- 366f50b: chore(provider): add deprecated textEmbeddingModel and textEmbedding aliases
- 81d4308: feat(provider/anthropic): mcp connector support
- 6fc35cb: Retain user-supplied betas.
- f4db7b5: feat(provider/anthropic): expose container from response in provider metadata
- 6c38080: fix(anthropic): support pdf responses in web_fetch_tool_result schema validation
- 4616b86: chore: update zod peer depenedency version
- dedf206: feat(provider/anthropic): expose stop_sequence in provider metadata
- 983e394: chore(provider/anthropic): add missing provider options jsdoc
- 0e38a79: support ANTHROPIC_BASE_URL
- cf4e2a9: Add support for tool calling with structured output
- f4e4a95: feat(provider/anthropic): enable fine grained tool streaming by default
- 21f378c: fix(provider/anthropic): do not limit maxTokens when model id is unknown
- c5440c5: chore(provider/anthropic): update anthropic model ids
- 1d15673: fix(provider/anthropic): clamp temperature to valid 0-1 range with warnings
- 9cff587: chore(provider/anthropic): lazy schema loading
- d129d89: chore(anthropic): remove unnecessary doc
- 3794514: feat: flexible tool output content support
- e1e2821: fix(provider/anthropic): support null title in web fetch tool
- cbf52cd: feat: expose raw finish reason
- 10c1322: fix: moved dependency `@ai-sdk/test-server` to devDependencies
- d08308b: feat(provider/anthropic): memory tool
- 05d5b9a: fix(anthropic): make title field nullable in web_fetch and web_search tool output schemas
- 1bd7d32: feat: tool-specific strict mode
- 83aaad8: Opus 4.5 and `effort` provider option
- Updated dependencies
  - @ai-sdk/provider@3.0.0
  - @ai-sdk/provider-utils@4.0.0

## 3.0.0-beta.98

### Patch Changes

- 2049c5b: Fix handling of error in web fetch tool in anthropic

## 3.0.0-beta.97

### Patch Changes

- Updated dependencies [475189e]
  - @ai-sdk/provider@3.0.0-beta.32
  - @ai-sdk/provider-utils@4.0.0-beta.59

## 3.0.0-beta.96

### Patch Changes

- 2625a04: feat(openai); update spec for mcp approval
- Updated dependencies [2625a04]
  - @ai-sdk/provider@3.0.0-beta.31
  - @ai-sdk/provider-utils@4.0.0-beta.58

## 3.0.0-beta.95

### Patch Changes

- cbf52cd: feat: expose raw finish reason
- Updated dependencies [cbf52cd]
  - @ai-sdk/provider@3.0.0-beta.30
  - @ai-sdk/provider-utils@4.0.0-beta.57

## 3.0.0-beta.94

### Patch Changes

- Updated dependencies [9549c9e]
  - @ai-sdk/provider@3.0.0-beta.29
  - @ai-sdk/provider-utils@4.0.0-beta.56

## 3.0.0-beta.93

### Patch Changes

- 50b70d6: feat(anthropic): add programmatic tool calling
- Updated dependencies [50b70d6]
  - @ai-sdk/provider-utils@4.0.0-beta.55

## 3.0.0-beta.92

### Patch Changes

- Updated dependencies [9061dc0]
  - @ai-sdk/provider-utils@4.0.0-beta.54
  - @ai-sdk/provider@3.0.0-beta.28

## 3.0.0-beta.91

### Patch Changes

- d129d89: chore(anthropic): remove unnecessary doc

## 3.0.0-beta.90

### Patch Changes

- 366f50b: chore(provider): add deprecated textEmbeddingModel and textEmbedding aliases
- Updated dependencies [366f50b]
  - @ai-sdk/provider@3.0.0-beta.27
  - @ai-sdk/provider-utils@4.0.0-beta.53

## 3.0.0-beta.89

### Patch Changes

- Updated dependencies [763d04a]
  - @ai-sdk/provider-utils@4.0.0-beta.52

## 3.0.0-beta.88

### Patch Changes

- 87db851: fix(vertex/anthropic): passing beta header only for structured outputs

## 3.0.0-beta.87

### Patch Changes

- Updated dependencies [c1efac4]
  - @ai-sdk/provider-utils@4.0.0-beta.51

## 3.0.0-beta.86

### Patch Changes

- Updated dependencies [32223c8]
  - @ai-sdk/provider-utils@4.0.0-beta.50

## 3.0.0-beta.85

### Patch Changes

- Updated dependencies [83e5744]
  - @ai-sdk/provider-utils@4.0.0-beta.49

## 3.0.0-beta.84

### Patch Changes

- Updated dependencies [960ec8f]
  - @ai-sdk/provider-utils@4.0.0-beta.48

## 3.0.0-beta.83

### Patch Changes

- 6c38080: fix(anthropic): support pdf responses in web_fetch_tool_result schema validation

## 3.0.0-beta.82

### Patch Changes

- Updated dependencies [e9e157f]
  - @ai-sdk/provider-utils@4.0.0-beta.47

## 3.0.0-beta.81

### Patch Changes

- Updated dependencies [81e29ab]
  - @ai-sdk/provider-utils@4.0.0-beta.46

## 3.0.0-beta.80

### Patch Changes

- 05d5b9a: fix(anthropic): make title field nullable in web_fetch and web_search tool output schemas

## 3.0.0-beta.79

### Patch Changes

- 3bd2689: feat: extended token usage
- Updated dependencies [3bd2689]
  - @ai-sdk/provider@3.0.0-beta.26
  - @ai-sdk/provider-utils@4.0.0-beta.45

## 3.0.0-beta.78

### Patch Changes

- 9e1e758: fix(anthropic): use default thinking budget when unspecified

## 3.0.0-beta.77

### Patch Changes

- b2dbfbf: add context_management for anthropic

## 3.0.0-beta.76

### Patch Changes

- Updated dependencies [53f3368]
  - @ai-sdk/provider@3.0.0-beta.25
  - @ai-sdk/provider-utils@4.0.0-beta.44

## 3.0.0-beta.75

### Patch Changes

- 0ae783e: feat(anthropic): add the new tool search tools

## 3.0.0-beta.74

### Patch Changes

- dce03c4: feat: tool input examples
- Updated dependencies [dce03c4]
  - @ai-sdk/provider-utils@4.0.0-beta.43
  - @ai-sdk/provider@3.0.0-beta.24

## 3.0.0-beta.73

### Patch Changes

- Updated dependencies [3ed5519]
  - @ai-sdk/provider-utils@4.0.0-beta.42

## 3.0.0-beta.72

### Patch Changes

- a5f77a6: fix(anthropic): remove outdated tool name docs

## 3.0.0-beta.71

### Patch Changes

- 1bd7d32: feat: tool-specific strict mode
- Updated dependencies [1bd7d32]
  - @ai-sdk/provider-utils@4.0.0-beta.41
  - @ai-sdk/provider@3.0.0-beta.23

## 3.0.0-beta.70

### Patch Changes

- f13958c: chore(antropic): allow custom names for provider-defined tools

## 3.0.0-beta.69

### Patch Changes

- 589a4ee: fix(anthropic): simplify pulling first chunk

## 3.0.0-beta.68

### Patch Changes

- 9e35785: fix(anthropic): send {} as tool input when streaming tool calls without arguments

## 3.0.0-beta.67

### Patch Changes

- eb56fc6: fix(anthropic): pull first chunk without async IIFE

## 3.0.0-beta.66

### Patch Changes

- 544d4e8: chore(specification): rename v3 provider defined tool to provider tool
- Updated dependencies [544d4e8]
  - @ai-sdk/provider-utils@4.0.0-beta.40
  - @ai-sdk/provider@3.0.0-beta.22

## 3.0.0-beta.65

### Patch Changes

- 954c356: feat(openai): allow custom names for provider-defined tools
- Updated dependencies [954c356]
  - @ai-sdk/provider-utils@4.0.0-beta.39
  - @ai-sdk/provider@3.0.0-beta.21

## 3.0.0-beta.64

### Patch Changes

- 03849b0: throw 500 error when the first stream chunk is an error
- Updated dependencies [03849b0]
  - @ai-sdk/provider-utils@4.0.0-beta.38

## 3.0.0-beta.63

### Patch Changes

- 457318b: chore(provider,ai): switch to SharedV3Warning and unified warnings
- Updated dependencies [457318b]
  - @ai-sdk/provider@3.0.0-beta.20
  - @ai-sdk/provider-utils@4.0.0-beta.37

## 3.0.0-beta.62

### Patch Changes

- 8d9e8ad: chore(provider): remove generics from EmbeddingModelV3

  Before

  ```ts
  model.textEmbeddingModel('my-model-id');
  ```

  After

  ```ts
  model.embeddingModel('my-model-id');
  ```

- Updated dependencies [8d9e8ad]
  - @ai-sdk/provider@3.0.0-beta.19
  - @ai-sdk/provider-utils@4.0.0-beta.36

## 3.0.0-beta.61

### Patch Changes

- Updated dependencies [10d819b]
  - @ai-sdk/provider@3.0.0-beta.18
  - @ai-sdk/provider-utils@4.0.0-beta.35

## 3.0.0-beta.60

### Patch Changes

- 6fc35cb: Retain user-supplied betas.

## 3.0.0-beta.59

### Patch Changes

- 2109385: 'fix(anthropic): Opus 4.5 `maxOutputTokens` bump `32000` -> `64000`'

## 3.0.0-beta.58

### Patch Changes

- 83aaad8: Opus 4.5 and `effort` provider option

## 3.0.0-beta.57

### Patch Changes

- b8ea36e: feat(provider/anthropic): Anthropic-native structured outputs

## 3.0.0-beta.56

### Patch Changes

- 983e394: chore(provider/anthropic): add missing provider options jsdoc

## 3.0.0-beta.55

### Patch Changes

- Updated dependencies [db913bd]
  - @ai-sdk/provider@3.0.0-beta.17
  - @ai-sdk/provider-utils@4.0.0-beta.34

## 3.0.0-beta.54

### Patch Changes

- 1d15673: fix(provider/anthropic): clamp temperature to valid 0-1 range with warnings

## 3.0.0-beta.53

### Patch Changes

- Updated dependencies [b681d7d]
  - @ai-sdk/provider@3.0.0-beta.16
  - @ai-sdk/provider-utils@4.0.0-beta.33

## 3.0.0-beta.52

### Patch Changes

- Updated dependencies [32d8dbb]
  - @ai-sdk/provider-utils@4.0.0-beta.32

## 3.0.0-beta.51

### Patch Changes

- 1742445: Support for custom provider name in google and anthropic providers

## 3.0.0-beta.50

### Patch Changes

- Updated dependencies [bb36798]
  - @ai-sdk/provider@3.0.0-beta.15
  - @ai-sdk/provider-utils@4.0.0-beta.31

## 3.0.0-beta.49

### Patch Changes

- Updated dependencies [4f16c37]
  - @ai-sdk/provider-utils@4.0.0-beta.30

## 3.0.0-beta.48

### Patch Changes

- Updated dependencies [af3780b]
  - @ai-sdk/provider@3.0.0-beta.14
  - @ai-sdk/provider-utils@4.0.0-beta.29

## 3.0.0-beta.47

### Patch Changes

- Updated dependencies [016b111]
  - @ai-sdk/provider-utils@4.0.0-beta.28

## 3.0.0-beta.46

### Patch Changes

- Updated dependencies [37c58a0]
  - @ai-sdk/provider@3.0.0-beta.13
  - @ai-sdk/provider-utils@4.0.0-beta.27

## 3.0.0-beta.45

### Patch Changes

- f4e4a95: feat(provider/anthropic): enable fine grained tool streaming by default

## 3.0.0-beta.44

### Patch Changes

- cf4e2a9: Add support for tool calling with structured output

## 3.0.0-beta.43

### Patch Changes

- Updated dependencies [d1bdadb]
  - @ai-sdk/provider@3.0.0-beta.12
  - @ai-sdk/provider-utils@4.0.0-beta.26

## 3.0.0-beta.42

### Patch Changes

- Updated dependencies [4c44a5b]
  - @ai-sdk/provider@3.0.0-beta.11
  - @ai-sdk/provider-utils@4.0.0-beta.25

## 3.0.0-beta.41

### Patch Changes

- 0c3b58b: fix(provider): add specificationVersion to ProviderV3
- Updated dependencies [0c3b58b]
  - @ai-sdk/provider@3.0.0-beta.10
  - @ai-sdk/provider-utils@4.0.0-beta.24

## 3.0.0-beta.40

### Patch Changes

- Updated dependencies [a755db5]
  - @ai-sdk/provider@3.0.0-beta.9
  - @ai-sdk/provider-utils@4.0.0-beta.23

## 3.0.0-beta.39

### Patch Changes

- Updated dependencies [58920e0]
  - @ai-sdk/provider-utils@4.0.0-beta.22

## 3.0.0-beta.38

### Patch Changes

- Updated dependencies [293a6b7]
  - @ai-sdk/provider-utils@4.0.0-beta.21

## 3.0.0-beta.37

### Patch Changes

- 7c4328e: Adds url-based pdf and image support for anthropic tool results

## 3.0.0-beta.36

### Patch Changes

- 21f378c: fix(provider/anthropic): do not limit maxTokens when model id is unknown

## 3.0.0-beta.35

### Patch Changes

- 80894b3: add return `file_id` property for anthropic code-execution-20250825 to download output files.

## 3.0.0-beta.34

### Patch Changes

- Updated dependencies [fca786b]
  - @ai-sdk/provider-utils@4.0.0-beta.20

## 3.0.0-beta.33

### Patch Changes

- 0e38a79: support ANTHROPIC_BASE_URL

## 3.0.0-beta.32

### Patch Changes

- f4db7b5: feat(provider/anthropic): expose container from response in provider metadata

## 3.0.0-beta.31

### Patch Changes

- ca07285: feat(anthropic): add prompt caching validation

## 3.0.0-beta.30

### Patch Changes

- 9354297: feat(provider/anthropic): add support for Agent Skills

## 3.0.0-beta.29

### Patch Changes

- 3794514: feat: flexible tool output content support
- Updated dependencies [3794514]
  - @ai-sdk/provider-utils@4.0.0-beta.19
  - @ai-sdk/provider@3.0.0-beta.8

## 3.0.0-beta.28

### Patch Changes

- 81d4308: feat(provider/anthropic): mcp connector support
- Updated dependencies [81d4308]
  - @ai-sdk/provider@3.0.0-beta.7
  - @ai-sdk/provider-utils@4.0.0-beta.18

## 3.0.0-beta.27

### Patch Changes

- 4c5a6be: feat(provider/anthropic): default and limit maxTokens based on model

## 3.0.0-beta.26

### Patch Changes

- f33a018: chore: add model ID for Haiku 4.5

## 3.0.0-beta.25

### Patch Changes

- Updated dependencies [703459a]
  - @ai-sdk/provider-utils@4.0.0-beta.17

## 3.0.0-beta.24

### Patch Changes

- d08308b: feat(provider/anthropic): memory tool

## 3.0.0-beta.23

### Patch Changes

- 6f845b4: Add support for 2025-08-25 code execution tool

## 3.0.0-beta.22

### Patch Changes

- ed537e1: Add support for pdf file in tool result in anthropic

## 3.0.0-beta.21

### Patch Changes

- Updated dependencies [6306603]
  - @ai-sdk/provider-utils@4.0.0-beta.16

## 3.0.0-beta.20

### Patch Changes

- Updated dependencies [f0b2157]
  - @ai-sdk/provider-utils@4.0.0-beta.15

## 3.0.0-beta.19

### Patch Changes

- Updated dependencies [3b1d015]
  - @ai-sdk/provider-utils@4.0.0-beta.14

## 3.0.0-beta.18

### Patch Changes

- Updated dependencies [d116b4b]
  - @ai-sdk/provider-utils@4.0.0-beta.13

## 3.0.0-beta.17

### Patch Changes

- Updated dependencies [7e32fea]
  - @ai-sdk/provider-utils@4.0.0-beta.12

## 3.0.0-beta.16

### Patch Changes

- 9cff587: chore(provider/anthropic): lazy schema loading

## 3.0.0-beta.15

### Patch Changes

- 95f65c2: chore: use import \* from zod/v4
- Updated dependencies
  - @ai-sdk/provider-utils@4.0.0-beta.11

## 3.0.0-beta.14

### Major Changes

- dee8b05: ai SDK 6 beta

### Patch Changes

- Updated dependencies [dee8b05]
  - @ai-sdk/provider@3.0.0-beta.6
  - @ai-sdk/provider-utils@4.0.0-beta.10

## 2.1.0-beta.13

### Patch Changes

- Updated dependencies [521c537]
  - @ai-sdk/provider-utils@3.1.0-beta.9

## 2.1.0-beta.12

### Patch Changes

- Updated dependencies [e06565c]
  - @ai-sdk/provider-utils@3.1.0-beta.8

## 2.1.0-beta.11

### Patch Changes

- e8109d3: feat: tool execution approval
- Updated dependencies
  - @ai-sdk/provider@2.1.0-beta.5
  - @ai-sdk/provider-utils@3.1.0-beta.7

## 2.1.0-beta.10

### Patch Changes

- dedf206: feat(provider/anthropic): expose stop_sequence in provider metadata

## 2.1.0-beta.9

### Patch Changes

- 0adc679: feat(provider): shared spec v3
- Updated dependencies
  - @ai-sdk/provider-utils@3.1.0-beta.6
  - @ai-sdk/provider@2.1.0-beta.4

## 2.1.0-beta.8

### Patch Changes

- a5a8db4: chore: add model ID for Sonnet 4.5

## 2.1.0-beta.7

### Patch Changes

- e1e2821: fix(provider/anthropic): support null title in web fetch tool

## 2.1.0-beta.6

### Patch Changes

- 8dac895: feat: `LanguageModelV3`
- 10c1322: fix: moved dependency `@ai-sdk/test-server` to devDependencies
- Updated dependencies [8dac895]
  - @ai-sdk/provider-utils@3.1.0-beta.5
  - @ai-sdk/provider@2.1.0-beta.3

## 2.1.0-beta.5

### Patch Changes

- 11e4abe: feat(provider/anthropic): web search tool updates
- afb00e3: feat(provider/anthropic): add text_editor_20250728 tool support

  Add text_editor_20250728 tool for Claude 4 models (Sonnet 4, Opus 4, Opus 4.1) with optional max_characters parameter and no undo_edit command support.

- f6603b7: fix(provider/anthropic): correct raw usage information
- fa35e95: feat(provider/anthropic): add web fetch tool
- c5440c5: chore(provider/anthropic): update anthropic model ids

## 2.1.0-beta.4

### Patch Changes

- 4616b86: chore: update zod peer depenedency version
- Updated dependencies [4616b86]
  - @ai-sdk/provider-utils@3.1.0-beta.4

## 2.1.0-beta.3

### Patch Changes

- ed329cb: feat: `Provider-V3`
- Updated dependencies
  - @ai-sdk/provider@2.1.0-beta.2
  - @ai-sdk/provider-utils@3.1.0-beta.3

## 2.1.0-beta.2

### Patch Changes

- 1cad0ab: feat: add provider version to user-agent header
- Updated dependencies [0c4822d]
  - @ai-sdk/provider@2.1.0-beta.1
  - @ai-sdk/provider-utils@3.1.0-beta.2

## 2.1.0-beta.1

### Patch Changes

- Updated dependencies
  - @ai-sdk/test-server@1.0.0-beta.0
  - @ai-sdk/provider-utils@3.1.0-beta.1

## 2.1.0-beta.0

### Minor Changes

- 78928cb: release: start 5.1 beta

### Patch Changes

- Updated dependencies [78928cb]
  - @ai-sdk/provider@2.1.0-beta.0
  - @ai-sdk/provider-utils@3.1.0-beta.0

## 2.0.17

### Patch Changes

- da92132: fix(provider/anthorpic): add cacheControl to AnthropicProviderOptions

## 2.0.16

### Patch Changes

- Updated dependencies [0294b58]
  - @ai-sdk/provider-utils@3.0.9

## 2.0.15

### Patch Changes

- c8aab0a: fix (provider/anthropic): revert cd458a8c1667df86e6987a1f2e06159823453864

## 2.0.14

### Patch Changes

- 2338c79: feat (provider/anthropic): update jsdoc of anthropic tools

## 2.0.13

### Patch Changes

- cd458a8: fix(anthropic): reorder tool_result parts to front of combined user messages

  Reorders tool_result content to appear before user text within combined user messages, ensuring Claude API validation requirements are met while preserving the intentional message combining behavior that prevents role alternation errors. Fixes #8318.

## 2.0.12

### Patch Changes

- Updated dependencies [99964ed]
  - @ai-sdk/provider-utils@3.0.8

## 2.0.11

### Patch Changes

- c7fee29: feat(anthropic): handle `pause_turn` as value for `stop_reason`

## 2.0.10

### Patch Changes

- c152ef7: feat(providers/anthropic): map 'refusal' stop reason to 'content-filter' finishReason

## 2.0.9

### Patch Changes

- cdc6b7a: fix(provider/anthropic): disable parallel tool use when using json output tool for structured responses

## 2.0.8

### Patch Changes

- Updated dependencies [886e7cd]
  - @ai-sdk/provider-utils@3.0.7

## 2.0.7

### Patch Changes

- Updated dependencies [1b5a3d3]
  - @ai-sdk/provider-utils@3.0.6

## 2.0.6

### Patch Changes

- Updated dependencies [0857788]
  - @ai-sdk/provider-utils@3.0.5

## 2.0.5

### Patch Changes

- Updated dependencies [68751f9]
  - @ai-sdk/provider-utils@3.0.4

## 2.0.4

### Patch Changes

- ae859ce: Added support for Anthropic provider's server-side code execution tool

## 2.0.3

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@3.0.3

## 2.0.2

### Patch Changes

- Updated dependencies [38ac190]
  - @ai-sdk/provider-utils@3.0.2

## 2.0.1

### Patch Changes

- Updated dependencies [90d212f]
  - @ai-sdk/provider-utils@3.0.1

## 2.0.0

### Major Changes

- d5f588f: AI SDK 5

### Patch Changes

- ad66c0e: feat (provider/anthropic): json response schema support via tool calls
- 8f2854f: feat (provider/anthropic): send web search tool calls
- 5d959e7: refactor: updated openai + anthropic tool use server side
- 8dfcb11: feat(anthropic/citation): text support for citations
- 9f73965: feat (provider/anthropic): parse websearch tool args
- e2aceaf: feat: add raw chunk support
- fdff8a4: fix(provider/anthropic): correct Claude 4 model ID format
- eb173f1: chore (providers): remove model shorthand deprecation warnings
- 4f26d59: feat(provider/anthropic): add disable parallel tool use option
- 25f3454: feat(provider/anthropic): add PDF citation support with document sources for streamText
- a85c85f: fix (provider/anthropic): streaming json output
- 5c9eec4: chore(providers/anthropic): switch to providerOptions
- 2e13791: feat(anthropic): add server-side web search support
- 66962ed: fix(packages): export node10 compatible types
- 075711d: fix (provider/anthropic): return stop finish reason for json output with tool
- 269683f: Add raw Anthropic usage information to provider metadata
- d601ed9: fix (provider/anthropic): send tool call id in tool-input-start chunk
- b9ddcdd: feat(anthropic): add text_editor_20250429 tool for Claude 4 models
- 91715e5: fix (provider/google-vertex): fix anthropic support for image urls in messages
- ca8aac6: feat (providers/anthropic): add claude v4 models
- 61ab528: Add support for URL-based PDF documents in the Anthropic provider
- 84577c8: fix (providers/anthropic): remove fine grained tool streaming beta
- d1a034f: feature: using Zod 4 for internal stuff
- 6392f60: fix(anthropic): resolve web search API validation errors with partial location + provider output
- 205077b: fix: improve Zod compatibility
- ee5a9c0: feat: streamText onChunk raw chunk support
- f418dd7: Added anthropic provider defined tool support to amazon bedrock
- 362b048: add web search tool support
- 399e056: fix: anthropic computer tool
- 0b678b2: feat (provider/anthropic): enable streaming tool calls
- f10304b: feat(tool-calling): don't require the user to have to pass parameters
- a753b3a: feat (provider/anthropic): cache control for tools
- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0
  - @ai-sdk/provider@2.0.0

## 2.0.0-beta.13

### Patch Changes

- Updated dependencies [88a8ee5]
  - @ai-sdk/provider-utils@3.0.0-beta.10

## 2.0.0-beta.12

### Patch Changes

- f418dd7: Added anthropic provider defined tool support to amazon bedrock
- Updated dependencies [27deb4d]
  - @ai-sdk/provider@2.0.0-beta.2
  - @ai-sdk/provider-utils@3.0.0-beta.9

## 2.0.0-beta.11

### Patch Changes

- eb173f1: chore (providers): remove model shorthand deprecation warnings
- Updated dependencies [dd5fd43]
  - @ai-sdk/provider-utils@3.0.0-beta.8

## 2.0.0-beta.10

### Patch Changes

- 269683f: Add raw Anthropic usage information to provider metadata
- Updated dependencies [e7fcc86]
  - @ai-sdk/provider-utils@3.0.0-beta.7

## 2.0.0-beta.9

### Patch Changes

- 4f26d59: feat(provider/anthropic): add disable parallel tool use option
- a753b3a: feat (provider/anthropic): cache control for tools
- Updated dependencies [ac34802]
  - @ai-sdk/provider-utils@3.0.0-beta.6

## 2.0.0-beta.8

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-beta.5

## 2.0.0-beta.7

### Patch Changes

- 205077b: fix: improve Zod compatibility
- Updated dependencies [205077b]
  - @ai-sdk/provider-utils@3.0.0-beta.4

## 2.0.0-beta.6

### Patch Changes

- Updated dependencies [05d2819]
  - @ai-sdk/provider-utils@3.0.0-beta.3

## 2.0.0-beta.5

### Patch Changes

- b9ddcdd: feat(anthropic): add text_editor_20250429 tool for Claude 4 models

## 2.0.0-beta.4

### Patch Changes

- fdff8a4: fix(provider/anthropic): correct Claude 4 model ID format
- 84577c8: fix (providers/anthropic): remove fine grained tool streaming beta

## 2.0.0-beta.3

### Patch Changes

- a85c85f: fix (provider/anthropic): streaming json output
- d1a034f: feature: using Zod 4 for internal stuff
- 0b678b2: feat (provider/anthropic): enable streaming tool calls
- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-beta.2

## 2.0.0-beta.2

### Patch Changes

- d601ed9: fix (provider/anthropic): send tool call id in tool-input-start chunk

## 2.0.0-beta.1

### Patch Changes

- 8f2854f: feat (provider/anthropic): send web search tool calls
- 5d959e7: refactor: updated openai + anthropic tool use server side
- 9f73965: feat (provider/anthropic): parse websearch tool args
- 399e056: fix: anthropic computer tool
- Updated dependencies
  - @ai-sdk/provider@2.0.0-beta.1
  - @ai-sdk/provider-utils@3.0.0-beta.1

## 2.0.0-alpha.15

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@2.0.0-alpha.15
  - @ai-sdk/provider-utils@3.0.0-alpha.15

## 2.0.0-alpha.14

### Patch Changes

- 2e13791: feat(anthropic): add server-side web search support
- 6392f60: fix(anthropic): resolve web search API validation errors with partial location + provider output
- Updated dependencies
  - @ai-sdk/provider@2.0.0-alpha.14
  - @ai-sdk/provider-utils@3.0.0-alpha.14

## 2.0.0-alpha.13

### Patch Changes

- 8dfcb11: feat(anthropic/citation): text support for citations
- ee5a9c0: feat: streamText onChunk raw chunk support
- Updated dependencies [68ecf2f]
  - @ai-sdk/provider@2.0.0-alpha.13
  - @ai-sdk/provider-utils@3.0.0-alpha.13

## 2.0.0-alpha.12

### Patch Changes

- e2aceaf: feat: add raw chunk support
- Updated dependencies [e2aceaf]
  - @ai-sdk/provider@2.0.0-alpha.12
  - @ai-sdk/provider-utils@3.0.0-alpha.12

## 2.0.0-alpha.11

### Patch Changes

- 25f3454: feat(provider/anthropic): add PDF citation support with document sources for streamText
- Updated dependencies [c1e6647]
  - @ai-sdk/provider@2.0.0-alpha.11
  - @ai-sdk/provider-utils@3.0.0-alpha.11

## 2.0.0-alpha.10

### Patch Changes

- Updated dependencies [c4df419]
  - @ai-sdk/provider@2.0.0-alpha.10
  - @ai-sdk/provider-utils@3.0.0-alpha.10

## 2.0.0-alpha.9

### Patch Changes

- 362b048: add web search tool support
- Updated dependencies [811dff3]
  - @ai-sdk/provider@2.0.0-alpha.9
  - @ai-sdk/provider-utils@3.0.0-alpha.9

## 2.0.0-alpha.8

### Patch Changes

- ad66c0e: feat (provider/anthropic): json response schema support via tool calls
- 075711d: fix (provider/anthropic): return stop finish reason for json output with tool
- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-alpha.8
  - @ai-sdk/provider@2.0.0-alpha.8

## 2.0.0-alpha.7

### Patch Changes

- Updated dependencies [5c56081]
  - @ai-sdk/provider@2.0.0-alpha.7
  - @ai-sdk/provider-utils@3.0.0-alpha.7

## 2.0.0-alpha.6

### Patch Changes

- Updated dependencies [0d2c085]
  - @ai-sdk/provider@2.0.0-alpha.6
  - @ai-sdk/provider-utils@3.0.0-alpha.6

## 2.0.0-alpha.4

### Patch Changes

- ca8aac6: feat (providers/anthropic): add claude v4 models
- Updated dependencies [dc714f3]
  - @ai-sdk/provider@2.0.0-alpha.4
  - @ai-sdk/provider-utils@3.0.0-alpha.4

## 2.0.0-alpha.3

### Patch Changes

- Updated dependencies [6b98118]
  - @ai-sdk/provider@2.0.0-alpha.3
  - @ai-sdk/provider-utils@3.0.0-alpha.3

## 2.0.0-alpha.2

### Patch Changes

- Updated dependencies [26535e0]
  - @ai-sdk/provider@2.0.0-alpha.2
  - @ai-sdk/provider-utils@3.0.0-alpha.2

## 2.0.0-alpha.1

### Patch Changes

- Updated dependencies [3f2f00c]
  - @ai-sdk/provider@2.0.0-alpha.1
  - @ai-sdk/provider-utils@3.0.0-alpha.1

## 2.0.0-canary.19

### Patch Changes

- Updated dependencies [faf8446]
  - @ai-sdk/provider-utils@3.0.0-canary.19

## 2.0.0-canary.18

### Patch Changes

- Updated dependencies [40acf9b]
  - @ai-sdk/provider-utils@3.0.0-canary.18

## 2.0.0-canary.17

### Patch Changes

- Updated dependencies [ea7a7c9]
  - @ai-sdk/provider-utils@3.0.0-canary.17

## 2.0.0-canary.16

### Patch Changes

- Updated dependencies [87b828f]
  - @ai-sdk/provider-utils@3.0.0-canary.16

## 2.0.0-canary.15

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-canary.15
  - @ai-sdk/provider@2.0.0-canary.14

## 2.0.0-canary.14

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-canary.14
  - @ai-sdk/provider@2.0.0-canary.13

## 2.0.0-canary.13

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@2.0.0-canary.12
  - @ai-sdk/provider-utils@3.0.0-canary.13

## 2.0.0-canary.12

### Patch Changes

- 5c9eec4: chore(providers/anthropic): switch to providerOptions
- Updated dependencies
  - @ai-sdk/provider@2.0.0-canary.11
  - @ai-sdk/provider-utils@3.0.0-canary.12

## 2.0.0-canary.11

### Patch Changes

- 66962ed: fix(packages): export node10 compatible types
- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-canary.11
  - @ai-sdk/provider@2.0.0-canary.10

## 2.0.0-canary.10

### Patch Changes

- Updated dependencies [e86be6f]
  - @ai-sdk/provider@2.0.0-canary.9
  - @ai-sdk/provider-utils@3.0.0-canary.10

## 2.0.0-canary.9

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@2.0.0-canary.8
  - @ai-sdk/provider-utils@3.0.0-canary.9

## 2.0.0-canary.8

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-canary.8
  - @ai-sdk/provider@2.0.0-canary.7

## 2.0.0-canary.7

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@2.0.0-canary.6
  - @ai-sdk/provider-utils@3.0.0-canary.7

## 2.0.0-canary.6

### Patch Changes

- f10304b: feat(tool-calling): don't require the user to have to pass parameters
- Updated dependencies
  - @ai-sdk/provider@2.0.0-canary.5
  - @ai-sdk/provider-utils@3.0.0-canary.6

## 2.0.0-canary.5

### Patch Changes

- Updated dependencies [6f6bb89]
  - @ai-sdk/provider@2.0.0-canary.4
  - @ai-sdk/provider-utils@3.0.0-canary.5

## 2.0.0-canary.4

### Patch Changes

- Updated dependencies [d1a1aa1]
  - @ai-sdk/provider@2.0.0-canary.3
  - @ai-sdk/provider-utils@3.0.0-canary.4

## 2.0.0-canary.3

### Patch Changes

- 61ab528: Add support for URL-based PDF documents in the Anthropic provider
- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-canary.3
  - @ai-sdk/provider@2.0.0-canary.2

## 2.0.0-canary.2

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@2.0.0-canary.1
  - @ai-sdk/provider-utils@3.0.0-canary.2

## 2.0.0-canary.1

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@3.0.0-canary.1

## 2.0.0-canary.0

### Major Changes

- d5f588f: AI SDK 5

### Patch Changes

- 91715e5: fix (provider/google-vertex): fix anthropic support for image urls in messages
- Updated dependencies [d5f588f]
  - @ai-sdk/provider-utils@3.0.0-canary.0
  - @ai-sdk/provider@2.0.0-canary.0

## 1.2.4

### Patch Changes

- Updated dependencies [28be004]
  - @ai-sdk/provider-utils@2.2.3

## 1.2.3

### Patch Changes

- Updated dependencies [b01120e]
  - @ai-sdk/provider-utils@2.2.2

## 1.2.2

### Patch Changes

- aeaa92b: feat (provider/anthropic): expose type for validating Anthropic responses provider options

## 1.2.1

### Patch Changes

- Updated dependencies [f10f0fa]
  - @ai-sdk/provider-utils@2.2.1

## 1.2.0

### Minor Changes

- 5bc638d: AI SDK 4.2

### Patch Changes

- Updated dependencies [5bc638d]
  - @ai-sdk/provider@1.1.0
  - @ai-sdk/provider-utils@2.2.0

## 1.1.19

### Patch Changes

- Updated dependencies [d0c4659]
  - @ai-sdk/provider-utils@2.1.15

## 1.1.18

### Patch Changes

- Updated dependencies [0bd5bc6]
  - @ai-sdk/provider@1.0.12
  - @ai-sdk/provider-utils@2.1.14

## 1.1.17

### Patch Changes

- Updated dependencies [2e1101a]
  - @ai-sdk/provider@1.0.11
  - @ai-sdk/provider-utils@2.1.13

## 1.1.16

### Patch Changes

- Updated dependencies [1531959]
  - @ai-sdk/provider-utils@2.1.12

## 1.1.15

### Patch Changes

- e1d3d42: feat (ai): expose raw response body in generateText and generateObject
- Updated dependencies [e1d3d42]
  - @ai-sdk/provider@1.0.10
  - @ai-sdk/provider-utils@2.1.11

## 1.1.14

### Patch Changes

- 0e8b66c: feat (provider/anthropic): support image urls

## 1.1.13

### Patch Changes

- 3004b14: feat(provider/anthropic): add bash_20250124 and text_editor_20250124 tools

## 1.1.12

### Patch Changes

- b3e5a15: fix (provider/anthropic): add model setting to allow omitting reasoning content from model requests

## 1.1.11

### Patch Changes

- 00276ae: feat (provider/anthropic): update types for Anthropic computer_20250124 tool
- a4f8714: feat (provider/anthropic): update beta flag for sonnet-3-7 when using new computer-use tool

## 1.1.10

### Patch Changes

- ddf9740: feat (ai): add anthropic reasoning
- Updated dependencies [ddf9740]
  - @ai-sdk/provider@1.0.9
  - @ai-sdk/provider-utils@2.1.10

## 1.1.9

### Patch Changes

- Updated dependencies [2761f06]
  - @ai-sdk/provider@1.0.8
  - @ai-sdk/provider-utils@2.1.9

## 1.1.8

### Patch Changes

- Updated dependencies [2e898b4]
  - @ai-sdk/provider-utils@2.1.8

## 1.1.7

### Patch Changes

- Updated dependencies [3ff4ef8]
  - @ai-sdk/provider-utils@2.1.7

## 1.1.6

### Patch Changes

- Updated dependencies [d89c3b9]
  - @ai-sdk/provider@1.0.7
  - @ai-sdk/provider-utils@2.1.6

## 1.1.5

### Patch Changes

- Updated dependencies [3a602ca]
  - @ai-sdk/provider-utils@2.1.5

## 1.1.4

### Patch Changes

- Updated dependencies [066206e]
  - @ai-sdk/provider-utils@2.1.4

## 1.1.3

### Patch Changes

- Updated dependencies [39e5c1f]
  - @ai-sdk/provider-utils@2.1.3

## 1.1.2

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@2.1.2
  - @ai-sdk/provider@1.0.6

## 1.1.1

### Patch Changes

- 858f934: feat (provider/anthropic): default cache-control on and mark model setting deprecated
- b284e2c: feat (provider/google-vertex): support prompt caching for Anthropic Claude models
- Updated dependencies
  - @ai-sdk/provider-utils@2.1.1
  - @ai-sdk/provider@1.0.5

## 1.1.0

### Minor Changes

- 62ba5ad: release: AI SDK 4.1

### Patch Changes

- Updated dependencies [62ba5ad]
  - @ai-sdk/provider-utils@2.1.0

## 1.0.9

### Patch Changes

- Updated dependencies [00114c5]
  - @ai-sdk/provider-utils@2.0.8

## 1.0.8

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@2.0.7

## 1.0.7

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@1.0.4
  - @ai-sdk/provider-utils@2.0.6

## 1.0.6

### Patch Changes

- 5ed5e45: chore (config): Use ts-library.json tsconfig for no-UI libs.
- Updated dependencies [5ed5e45]
  - @ai-sdk/provider-utils@2.0.5
  - @ai-sdk/provider@1.0.3

## 1.0.5

### Patch Changes

- Updated dependencies [09a9cab]
  - @ai-sdk/provider@1.0.2
  - @ai-sdk/provider-utils@2.0.4

## 1.0.4

### Patch Changes

- bcd892e: feat (provider/google-vertex): Add support for Anthropic models.

## 1.0.3

### Patch Changes

- Updated dependencies [0984f0b]
  - @ai-sdk/provider-utils@2.0.3

## 1.0.2

### Patch Changes

- Updated dependencies [b446ae5]
  - @ai-sdk/provider@1.0.1
  - @ai-sdk/provider-utils@2.0.2

## 1.0.1

### Patch Changes

- Updated dependencies [c3ab5de]
  - @ai-sdk/provider-utils@2.0.1

## 1.0.0

### Major Changes

- 66060f7: chore (release): bump major version to 4.0
- 0d3d3f5: chore (providers): remove baseUrl option
- 8ad0504: chore (provider/anthropic): remove Anthropic facade
- 2f6e8c0: chore (provider/anthropic): remove topK model setting

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@2.0.0
  - @ai-sdk/provider@1.0.0

## 1.0.0-canary.4

### Major Changes

- 2f6e8c0: chore (provider/anthropic): remove topK model setting

## 1.0.0-canary.3

### Patch Changes

- Updated dependencies [8426f55]
  - @ai-sdk/provider-utils@2.0.0-canary.3

## 1.0.0-canary.2

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@2.0.0-canary.2

## 1.0.0-canary.1

### Major Changes

- 0d3d3f5: chore (providers): remove baseUrl option
- 8ad0504: chore (provider/anthropic): remove Anthropic facade

### Patch Changes

- Updated dependencies [b1da952]
  - @ai-sdk/provider-utils@2.0.0-canary.1

## 1.0.0-canary.0

### Major Changes

- 66060f7: chore (release): bump major version to 4.0

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@2.0.0-canary.0
  - @ai-sdk/provider@1.0.0-canary.0

## 0.0.56

### Patch Changes

- e6042b1: feat (provider/anthropic): add haiku 3.5 model ids

## 0.0.55

### Patch Changes

- ac380e3: fix (provider/anthropic): continuation mode with 3+ steps

## 0.0.54

### Patch Changes

- 4d2e53b: feat (provider/anthropic): pdf support
- c8afcb5: feat (provider/anthropic): allow using computer use and cache control at the same time

## 0.0.53

### Patch Changes

- 3b1b69a: feat (provider/anthropic): add computer use tools
- 3b1b69a: feat: provider-defined tools
- 8c222cd: feat (provider/anthropic): update model ids
- 811a317: feat (ai/core): multi-part tool results (incl. images)
- Updated dependencies
  - @ai-sdk/provider-utils@1.0.22
  - @ai-sdk/provider@0.0.26

## 0.0.52

### Patch Changes

- b9b0d7b: feat (ai): access raw request body
- Updated dependencies [b9b0d7b]
  - @ai-sdk/provider@0.0.25
  - @ai-sdk/provider-utils@1.0.21

## 0.0.51

### Patch Changes

- Updated dependencies [d595d0d]
  - @ai-sdk/provider@0.0.24
  - @ai-sdk/provider-utils@1.0.20

## 0.0.50

### Patch Changes

- Updated dependencies [273f696]
  - @ai-sdk/provider-utils@1.0.19

## 0.0.49

### Patch Changes

- 03313cd: feat (ai): expose response id, response model, response timestamp in telemetry and api
- 3be7c1c: fix (provider/anthropic): support prompt caching on assistant messages
- Updated dependencies
  - @ai-sdk/provider-utils@1.0.18
  - @ai-sdk/provider@0.0.23

## 0.0.48

### Patch Changes

- 26515cb: feat (ai/provider): introduce ProviderV1 specification
- Updated dependencies [26515cb]
  - @ai-sdk/provider@0.0.22
  - @ai-sdk/provider-utils@1.0.17

## 0.0.47

### Patch Changes

- Updated dependencies [09f895f]
  - @ai-sdk/provider-utils@1.0.16

## 0.0.46

### Patch Changes

- Updated dependencies [d67fa9c]
  - @ai-sdk/provider-utils@1.0.15

## 0.0.45

### Patch Changes

- 95a53a3: chore (provider/anthropic): remove tool calls beta header

## 0.0.44

### Patch Changes

- Updated dependencies [f2c025e]
  - @ai-sdk/provider@0.0.21
  - @ai-sdk/provider-utils@1.0.14

## 0.0.43

### Patch Changes

- 6ac355e: feat (provider/anthropic): add cache control support
- Updated dependencies [6ac355e]
  - @ai-sdk/provider@0.0.20
  - @ai-sdk/provider-utils@1.0.13

## 0.0.42

### Patch Changes

- dd712ac: fix: use FetchFunction type to prevent self-reference
- Updated dependencies [dd712ac]
  - @ai-sdk/provider-utils@1.0.12

## 0.0.41

### Patch Changes

- 89b18ca: fix (ai/provider): send finish reason 'unknown' by default
- Updated dependencies [dd4a0f5]
  - @ai-sdk/provider@0.0.19
  - @ai-sdk/provider-utils@1.0.11

## 0.0.40

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@1.0.10
  - @ai-sdk/provider@0.0.18

## 0.0.39

### Patch Changes

- Updated dependencies [029af4c]
  - @ai-sdk/provider@0.0.17
  - @ai-sdk/provider-utils@1.0.9

## 0.0.38

### Patch Changes

- Updated dependencies [d58517b]
  - @ai-sdk/provider@0.0.16
  - @ai-sdk/provider-utils@1.0.8

## 0.0.37

### Patch Changes

- Updated dependencies [96aed25]
  - @ai-sdk/provider@0.0.15
  - @ai-sdk/provider-utils@1.0.7

## 0.0.36

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@1.0.6

## 0.0.35

### Patch Changes

- fe2128f0: feat (provider/anthropic): combine sequential assistant messages into one

## 0.0.34

### Patch Changes

- 7d0fd5a8: fix (provider/anthropic): handle error stream chunks

## 0.0.33

### Patch Changes

- a8d1c9e9: feat (ai/core): parallel image download
- Updated dependencies [a8d1c9e9]
  - @ai-sdk/provider-utils@1.0.5
  - @ai-sdk/provider@0.0.14

## 0.0.32

### Patch Changes

- Updated dependencies [4f88248f]
  - @ai-sdk/provider-utils@1.0.4

## 0.0.31

### Patch Changes

- 2b9da0f0: feat (core): support stopSequences setting.
- a5b58845: feat (core): support topK setting
- 4aa8deb3: feat (provider): support responseFormat setting in provider api
- 13b27ec6: chore (ai/core): remove grammar mode
- Updated dependencies
  - @ai-sdk/provider@0.0.13
  - @ai-sdk/provider-utils@1.0.3

## 0.0.30

### Patch Changes

- 4c6b80f7: chore (provider/anthropic): improve object-tool mode

## 0.0.29

### Patch Changes

- Updated dependencies [b7290943]
  - @ai-sdk/provider@0.0.12
  - @ai-sdk/provider-utils@1.0.2

## 0.0.28

### Patch Changes

- Updated dependencies [d481729f]
  - @ai-sdk/provider-utils@1.0.1

## 0.0.27

### Patch Changes

- 7e86b45e: fix (provider/anthropic): automatically trim trailing whitespace on pre-filled assistant responses

## 0.0.26

### Patch Changes

- 5edc6110: feat (ai/core): add custom request header support
- Updated dependencies
  - @ai-sdk/provider@0.0.11
  - @ai-sdk/provider-utils@1.0.0

## 0.0.25

### Patch Changes

- 91dc4296: chore (@ai-sdk/anthropic): remove anthropic-beta header

## 0.0.24

### Patch Changes

- 04800838: fix (@ai-sdk/anthropic): combine tool and user messages, combine system messages

## 0.0.23

### Patch Changes

- Updated dependencies [02f6a088]
  - @ai-sdk/provider-utils@0.0.16

## 0.0.22

### Patch Changes

- 0a22b05b: feat (@ai-sdk/anthropic): add claude-3.5-sonnet model

## 0.0.21

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider-utils@0.0.15

## 0.0.20

### Patch Changes

- 4728c37f: feat (core): add text embedding model support to provider registry
- 7910ae84: feat (providers): support custom fetch implementations
- Updated dependencies [7910ae84]
  - @ai-sdk/provider-utils@0.0.14

## 0.0.19

### Patch Changes

- Updated dependencies [102ca22f]
  - @ai-sdk/provider@0.0.10
  - @ai-sdk/provider-utils@0.0.13

## 0.0.18

### Patch Changes

- 09295e2e: feat (@ai-sdk/anthropic): automatically download image URLs
- Updated dependencies
  - @ai-sdk/provider@0.0.9
  - @ai-sdk/provider-utils@0.0.12

## 0.0.17

### Patch Changes

- f39c0dd2: feat (provider): implement toolChoice support
- Updated dependencies [f39c0dd2]
  - @ai-sdk/provider@0.0.8
  - @ai-sdk/provider-utils@0.0.11

## 0.0.16

### Patch Changes

- 24683b72: fix (providers): Zod is required dependency
- Updated dependencies [8e780288]
  - @ai-sdk/provider@0.0.7
  - @ai-sdk/provider-utils@0.0.10

## 0.0.15

### Patch Changes

- Updated dependencies
  - @ai-sdk/provider@0.0.6
  - @ai-sdk/provider-utils@0.0.9

## 0.0.14

### Patch Changes

- 06e3934: feat (provider/anthropic): streaming tool calls

## 0.0.13

### Patch Changes

- Updated dependencies [0f6bc4e]
  - @ai-sdk/provider@0.0.5
  - @ai-sdk/provider-utils@0.0.8

## 0.0.12

### Patch Changes

- Updated dependencies [325ca55]
  - @ai-sdk/provider@0.0.4
  - @ai-sdk/provider-utils@0.0.7

## 0.0.11

### Patch Changes

- 5b01c13: feat (ai/core): add system message support in messages list

## 0.0.10

### Patch Changes

- Updated dependencies [276f22b]
  - @ai-sdk/provider-utils@0.0.6

## 0.0.9

### Patch Changes

- Updated dependencies [41d5736]
  - @ai-sdk/provider@0.0.3
  - @ai-sdk/provider-utils@0.0.5

## 0.0.8

### Patch Changes

- Updated dependencies [56ef84a]
  - @ai-sdk/provider-utils@0.0.4

## 0.0.7

### Patch Changes

- 25f3350: ai/core: add support for getting raw response headers.
- Updated dependencies
  - @ai-sdk/provider@0.0.2
  - @ai-sdk/provider-utils@0.0.3

## 0.0.6

### Patch Changes

- eb150a6: ai/core: remove scaling of setting values (breaking change). If you were using the temperature, frequency penalty, or presence penalty settings, you need to update the providers and adjust the setting values.
- Updated dependencies [eb150a6]
  - @ai-sdk/provider-utils@0.0.2
  - @ai-sdk/provider@0.0.1

## 0.0.5

### Patch Changes

- c6fc35b: Add custom header support.

## 0.0.4

### Patch Changes

- ab60b18: Simplified model construction by directly calling provider functions. Add create... functions to create provider instances.

## 0.0.3

### Patch Changes

- 587240b: Standardize providers to offer .chat() method

## 0.0.2

### Patch Changes

- 2bff460: Fix build for release.

## 0.0.1

### Patch Changes

- 7b8791d: Rename baseUrl to baseURL. Automatically remove trailing slashes.
- Updated dependencies [7b8791d]
  - @ai-sdk/provider-utils@0.0.1
