"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  VERSION: () => VERSION,
  azure: () => azure,
  createAzure: () => createAzure
});
module.exports = __toCommonJS(src_exports);

// src/azure-openai-provider.ts
var import_internal2 = require("@ai-sdk/openai/internal");
var import_provider_utils = require("@ai-sdk/provider-utils");

// src/azure-openai-tools.ts
var import_internal = require("@ai-sdk/openai/internal");
var azureOpenaiTools = {
  codeInterpreter: import_internal.codeInterpreter,
  fileSearch: import_internal.fileSearch,
  imageGeneration: import_internal.imageGeneration,
  webSearchPreview: import_internal.webSearchPreview
};

// src/version.ts
var VERSION = true ? "3.0.7" : "0.0.0-test";

// src/azure-openai-provider.ts
function createAzure(options = {}) {
  var _a;
  const getHeaders = () => {
    const baseHeaders = {
      "api-key": (0, import_provider_utils.loadApiKey)({
        apiKey: options.apiKey,
        environmentVariableName: "AZURE_API_KEY",
        description: "Azure OpenAI"
      }),
      ...options.headers
    };
    return (0, import_provider_utils.withUserAgentSuffix)(baseHeaders, `ai-sdk/azure/${VERSION}`);
  };
  const getResourceName = () => (0, import_provider_utils.loadSetting)({
    settingValue: options.resourceName,
    settingName: "resourceName",
    environmentVariableName: "AZURE_RESOURCE_NAME",
    description: "Azure OpenAI resource name"
  });
  const apiVersion = (_a = options.apiVersion) != null ? _a : "v1";
  const url = ({ path, modelId }) => {
    var _a2;
    const baseUrlPrefix = (_a2 = options.baseURL) != null ? _a2 : `https://${getResourceName()}.openai.azure.com/openai`;
    let fullUrl;
    if (options.useDeploymentBasedUrls) {
      fullUrl = new URL(`${baseUrlPrefix}/deployments/${modelId}${path}`);
    } else {
      fullUrl = new URL(`${baseUrlPrefix}/v1${path}`);
    }
    fullUrl.searchParams.set("api-version", apiVersion);
    return fullUrl.toString();
  };
  const createChatModel = (deploymentName) => new import_internal2.OpenAIChatLanguageModel(deploymentName, {
    provider: "azure.chat",
    url,
    headers: getHeaders,
    fetch: options.fetch
  });
  const createCompletionModel = (modelId) => new import_internal2.OpenAICompletionLanguageModel(modelId, {
    provider: "azure.completion",
    url,
    headers: getHeaders,
    fetch: options.fetch
  });
  const createEmbeddingModel = (modelId) => new import_internal2.OpenAIEmbeddingModel(modelId, {
    provider: "azure.embeddings",
    headers: getHeaders,
    url,
    fetch: options.fetch
  });
  const createResponsesModel = (modelId) => new import_internal2.OpenAIResponsesLanguageModel(modelId, {
    provider: "azure.responses",
    url,
    headers: getHeaders,
    fetch: options.fetch,
    fileIdPrefixes: ["assistant-"]
  });
  const createImageModel = (modelId) => new import_internal2.OpenAIImageModel(modelId, {
    provider: "azure.image",
    url,
    headers: getHeaders,
    fetch: options.fetch
  });
  const createTranscriptionModel = (modelId) => new import_internal2.OpenAITranscriptionModel(modelId, {
    provider: "azure.transcription",
    url,
    headers: getHeaders,
    fetch: options.fetch
  });
  const createSpeechModel = (modelId) => new import_internal2.OpenAISpeechModel(modelId, {
    provider: "azure.speech",
    url,
    headers: getHeaders,
    fetch: options.fetch
  });
  const provider = function(deploymentId) {
    if (new.target) {
      throw new Error(
        "The Azure OpenAI model function cannot be called with the new keyword."
      );
    }
    return createResponsesModel(deploymentId);
  };
  provider.specificationVersion = "v3";
  provider.languageModel = createResponsesModel;
  provider.chat = createChatModel;
  provider.completion = createCompletionModel;
  provider.embedding = createEmbeddingModel;
  provider.embeddingModel = createEmbeddingModel;
  provider.textEmbedding = createEmbeddingModel;
  provider.textEmbeddingModel = createEmbeddingModel;
  provider.image = createImageModel;
  provider.imageModel = createImageModel;
  provider.responses = createResponsesModel;
  provider.transcription = createTranscriptionModel;
  provider.speech = createSpeechModel;
  provider.tools = azureOpenaiTools;
  return provider;
}
var azure = createAzure();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  VERSION,
  azure,
  createAzure
});
//# sourceMappingURL=index.js.map