import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { AdminConfirmSignUp$ } from "../schemas/schemas_0";
export { $Command };
export class AdminConfirmSignUpCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "AdminConfirmSignUp", {})
    .n("CognitoIdentityProviderClient", "AdminConfirmSignUpCommand")
    .sc(AdminConfirmSignUp$)
    .build() {
}
