import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ConfirmForgotPassword$ } from "../schemas/schemas_0";
export { $Command };
export class ConfirmForgotPasswordCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "ConfirmForgotPassword", {})
    .n("CognitoIdentityProviderClient", "ConfirmForgotPasswordCommand")
    .sc(ConfirmForgotPassword$)
    .build() {
}
