import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateResourceServer$ } from "../schemas/schemas_0";
export { $Command };
export class CreateResourceServerCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "CreateResourceServer", {})
    .n("CognitoIdentityProviderClient", "CreateResourceServerCommand")
    .sc(CreateResourceServer$)
    .build() {
}
