import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateUserImportJob$ } from "../schemas/schemas_0";
export { $Command };
export class CreateUserImportJobCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "CreateUserImportJob", {})
    .n("CognitoIdentityProviderClient", "CreateUserImportJobCommand")
    .sc(CreateUserImportJob$)
    .build() {
}
