import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateUserPoolClient$ } from "../schemas/schemas_0";
export { $Command };
export class CreateUserPoolClientCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "CreateUserPoolClient", {})
    .n("CognitoIdentityProviderClient", "CreateUserPoolClientCommand")
    .sc(CreateUserPoolClient$)
    .build() {
}
