import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DeleteIdentityProvider$ } from "../schemas/schemas_0";
export { $Command };
export class DeleteIdentityProviderCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "DeleteIdentityProvider", {})
    .n("CognitoIdentityProviderClient", "DeleteIdentityProviderCommand")
    .sc(DeleteIdentityProvider$)
    .build() {
}
