import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetDevice$ } from "../schemas/schemas_0";
export { $Command };
export class GetDeviceCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "GetDevice", {})
    .n("CognitoIdentityProviderClient", "GetDeviceCommand")
    .sc(GetDevice$)
    .build() {
}
