import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetUserAttributeVerificationCode$ } from "../schemas/schemas_0";
export { $Command };
export class GetUserAttributeVerificationCodeCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "GetUserAttributeVerificationCode", {})
    .n("CognitoIdentityProviderClient", "GetUserAttributeVerificationCodeCommand")
    .sc(GetUserAttributeVerificationCode$)
    .build() {
}
