import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { InitiateAuth$ } from "../schemas/schemas_0";
export { $Command };
export class InitiateAuthCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "InitiateAuth", {})
    .n("CognitoIdentityProviderClient", "InitiateAuthCommand")
    .sc(InitiateAuth$)
    .build() {
}
