import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListResourceServers$ } from "../schemas/schemas_0";
export { $Command };
export class ListResourceServersCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "ListResourceServers", {})
    .n("CognitoIdentityProviderClient", "ListResourceServersCommand")
    .sc(ListResourceServers$)
    .build() {
}
