import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListUserPoolClients$ } from "../schemas/schemas_0";
export { $Command };
export class ListUserPoolClientsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "ListUserPoolClients", {})
    .n("CognitoIdentityProviderClient", "ListUserPoolClientsCommand")
    .sc(ListUserPoolClients$)
    .build() {
}
