import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListUserPools$ } from "../schemas/schemas_0";
export { $Command };
export class ListUserPoolsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "ListUserPools", {})
    .n("CognitoIdentityProviderClient", "ListUserPoolsCommand")
    .sc(ListUserPools$)
    .build() {
}
