import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ResendConfirmationCode$ } from "../schemas/schemas_0";
export { $Command };
export class ResendConfirmationCodeCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "ResendConfirmationCode", {})
    .n("CognitoIdentityProviderClient", "ResendConfirmationCodeCommand")
    .sc(ResendConfirmationCode$)
    .build() {
}
