import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SetLogDeliveryConfiguration$ } from "../schemas/schemas_0";
export { $Command };
export class SetLogDeliveryConfigurationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "SetLogDeliveryConfiguration", {})
    .n("CognitoIdentityProviderClient", "SetLogDeliveryConfigurationCommand")
    .sc(SetLogDeliveryConfiguration$)
    .build() {
}
