import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SetRiskConfiguration$ } from "../schemas/schemas_0";
export { $Command };
export class SetRiskConfigurationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "SetRiskConfiguration", {})
    .n("CognitoIdentityProviderClient", "SetRiskConfigurationCommand")
    .sc(SetRiskConfiguration$)
    .build() {
}
