import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SetUICustomization$ } from "../schemas/schemas_0";
export { $Command };
export class SetUICustomizationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "SetUICustomization", {})
    .n("CognitoIdentityProviderClient", "SetUICustomizationCommand")
    .sc(SetUICustomization$)
    .build() {
}
