import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SetUserSettings$ } from "../schemas/schemas_0";
export { $Command };
export class SetUserSettingsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSCognitoIdentityProviderService", "SetUserSettings", {})
    .n("CognitoIdentityProviderClient", "SetUserSettingsCommand")
    .sc(SetUserSettings$)
    .build() {
}
