/**
 * @public
 * @enum
 */
export declare const RecoveryOptionNameType: {
    readonly ADMIN_ONLY: "admin_only";
    readonly VERIFIED_EMAIL: "verified_email";
    readonly VERIFIED_PHONE_NUMBER: "verified_phone_number";
};
/**
 * @public
 */
export type RecoveryOptionNameType = (typeof RecoveryOptionNameType)[keyof typeof RecoveryOptionNameType];
/**
 * @public
 * @enum
 */
export declare const AccountTakeoverEventActionType: {
    readonly BLOCK: "BLOCK";
    readonly MFA_IF_CONFIGURED: "MFA_IF_CONFIGURED";
    readonly MFA_REQUIRED: "MFA_REQUIRED";
    readonly NO_ACTION: "NO_ACTION";
};
/**
 * @public
 */
export type AccountTakeoverEventActionType = (typeof AccountTakeoverEventActionType)[keyof typeof AccountTakeoverEventActionType];
/**
 * @public
 * @enum
 */
export declare const AttributeDataType: {
    readonly BOOLEAN: "Boolean";
    readonly DATETIME: "DateTime";
    readonly NUMBER: "Number";
    readonly STRING: "String";
};
/**
 * @public
 */
export type AttributeDataType = (typeof AttributeDataType)[keyof typeof AttributeDataType];
/**
 * @public
 * @enum
 */
export declare const DeliveryMediumType: {
    readonly EMAIL: "EMAIL";
    readonly SMS: "SMS";
};
/**
 * @public
 */
export type DeliveryMediumType = (typeof DeliveryMediumType)[keyof typeof DeliveryMediumType];
/**
 * @public
 * @enum
 */
export declare const MessageActionType: {
    readonly RESEND: "RESEND";
    readonly SUPPRESS: "SUPPRESS";
};
/**
 * @public
 */
export type MessageActionType = (typeof MessageActionType)[keyof typeof MessageActionType];
/**
 * @public
 * @enum
 */
export declare const UserStatusType: {
    readonly ARCHIVED: "ARCHIVED";
    readonly COMPROMISED: "COMPROMISED";
    readonly CONFIRMED: "CONFIRMED";
    readonly EXTERNAL_PROVIDER: "EXTERNAL_PROVIDER";
    readonly FORCE_CHANGE_PASSWORD: "FORCE_CHANGE_PASSWORD";
    readonly RESET_REQUIRED: "RESET_REQUIRED";
    readonly UNCONFIRMED: "UNCONFIRMED";
    readonly UNKNOWN: "UNKNOWN";
};
/**
 * @public
 */
export type UserStatusType = (typeof UserStatusType)[keyof typeof UserStatusType];
/**
 * @public
 * @enum
 */
export declare const AuthFlowType: {
    readonly ADMIN_NO_SRP_AUTH: "ADMIN_NO_SRP_AUTH";
    readonly ADMIN_USER_PASSWORD_AUTH: "ADMIN_USER_PASSWORD_AUTH";
    readonly CUSTOM_AUTH: "CUSTOM_AUTH";
    readonly REFRESH_TOKEN: "REFRESH_TOKEN";
    readonly REFRESH_TOKEN_AUTH: "REFRESH_TOKEN_AUTH";
    readonly USER_AUTH: "USER_AUTH";
    readonly USER_PASSWORD_AUTH: "USER_PASSWORD_AUTH";
    readonly USER_SRP_AUTH: "USER_SRP_AUTH";
};
/**
 * @public
 */
export type AuthFlowType = (typeof AuthFlowType)[keyof typeof AuthFlowType];
/**
 * @public
 * @enum
 */
export declare const ChallengeNameType: {
    readonly ADMIN_NO_SRP_AUTH: "ADMIN_NO_SRP_AUTH";
    readonly CUSTOM_CHALLENGE: "CUSTOM_CHALLENGE";
    readonly DEVICE_PASSWORD_VERIFIER: "DEVICE_PASSWORD_VERIFIER";
    readonly DEVICE_SRP_AUTH: "DEVICE_SRP_AUTH";
    readonly EMAIL_OTP: "EMAIL_OTP";
    readonly MFA_SETUP: "MFA_SETUP";
    readonly NEW_PASSWORD_REQUIRED: "NEW_PASSWORD_REQUIRED";
    readonly PASSWORD: "PASSWORD";
    readonly PASSWORD_SRP: "PASSWORD_SRP";
    readonly PASSWORD_VERIFIER: "PASSWORD_VERIFIER";
    readonly SELECT_CHALLENGE: "SELECT_CHALLENGE";
    readonly SELECT_MFA_TYPE: "SELECT_MFA_TYPE";
    readonly SMS_MFA: "SMS_MFA";
    readonly SMS_OTP: "SMS_OTP";
    readonly SOFTWARE_TOKEN_MFA: "SOFTWARE_TOKEN_MFA";
    readonly WEB_AUTHN: "WEB_AUTHN";
};
/**
 * @public
 */
export type ChallengeNameType = (typeof ChallengeNameType)[keyof typeof ChallengeNameType];
/**
 * @public
 * @enum
 */
export declare const ChallengeName: {
    readonly Mfa: "Mfa";
    readonly Password: "Password";
};
/**
 * @public
 */
export type ChallengeName = (typeof ChallengeName)[keyof typeof ChallengeName];
/**
 * @public
 * @enum
 */
export declare const ChallengeResponse: {
    readonly Failure: "Failure";
    readonly Success: "Success";
};
/**
 * @public
 */
export type ChallengeResponse = (typeof ChallengeResponse)[keyof typeof ChallengeResponse];
/**
 * @public
 * @enum
 */
export declare const FeedbackValueType: {
    readonly INVALID: "Invalid";
    readonly VALID: "Valid";
};
/**
 * @public
 */
export type FeedbackValueType = (typeof FeedbackValueType)[keyof typeof FeedbackValueType];
/**
 * @public
 * @enum
 */
export declare const EventResponseType: {
    readonly Fail: "Fail";
    readonly InProgress: "InProgress";
    readonly Pass: "Pass";
};
/**
 * @public
 */
export type EventResponseType = (typeof EventResponseType)[keyof typeof EventResponseType];
/**
 * @public
 * @enum
 */
export declare const RiskDecisionType: {
    readonly AccountTakeover: "AccountTakeover";
    readonly Block: "Block";
    readonly NoRisk: "NoRisk";
};
/**
 * @public
 */
export type RiskDecisionType = (typeof RiskDecisionType)[keyof typeof RiskDecisionType];
/**
 * @public
 * @enum
 */
export declare const RiskLevelType: {
    readonly High: "High";
    readonly Low: "Low";
    readonly Medium: "Medium";
};
/**
 * @public
 */
export type RiskLevelType = (typeof RiskLevelType)[keyof typeof RiskLevelType];
/**
 * @public
 * @enum
 */
export declare const EventType: {
    readonly ForgotPassword: "ForgotPassword";
    readonly PasswordChange: "PasswordChange";
    readonly ResendCode: "ResendCode";
    readonly SignIn: "SignIn";
    readonly SignUp: "SignUp";
};
/**
 * @public
 */
export type EventType = (typeof EventType)[keyof typeof EventType];
/**
 * @public
 * @enum
 */
export declare const DeviceRememberedStatusType: {
    readonly NOT_REMEMBERED: "not_remembered";
    readonly REMEMBERED: "remembered";
};
/**
 * @public
 */
export type DeviceRememberedStatusType = (typeof DeviceRememberedStatusType)[keyof typeof DeviceRememberedStatusType];
/**
 * @public
 * @enum
 */
export declare const AdvancedSecurityEnabledModeType: {
    readonly AUDIT: "AUDIT";
    readonly ENFORCED: "ENFORCED";
};
/**
 * @public
 */
export type AdvancedSecurityEnabledModeType = (typeof AdvancedSecurityEnabledModeType)[keyof typeof AdvancedSecurityEnabledModeType];
/**
 * @public
 * @enum
 */
export declare const AdvancedSecurityModeType: {
    readonly AUDIT: "AUDIT";
    readonly ENFORCED: "ENFORCED";
    readonly OFF: "OFF";
};
/**
 * @public
 */
export type AdvancedSecurityModeType = (typeof AdvancedSecurityModeType)[keyof typeof AdvancedSecurityModeType];
/**
 * @public
 * @enum
 */
export declare const AliasAttributeType: {
    readonly EMAIL: "email";
    readonly PHONE_NUMBER: "phone_number";
    readonly PREFERRED_USERNAME: "preferred_username";
};
/**
 * @public
 */
export type AliasAttributeType = (typeof AliasAttributeType)[keyof typeof AliasAttributeType];
/**
 * @public
 * @enum
 */
export declare const AuthFactorType: {
    readonly EMAIL_OTP: "EMAIL_OTP";
    readonly PASSWORD: "PASSWORD";
    readonly SMS_OTP: "SMS_OTP";
    readonly WEB_AUTHN: "WEB_AUTHN";
};
/**
 * @public
 */
export type AuthFactorType = (typeof AuthFactorType)[keyof typeof AuthFactorType];
/**
 * @public
 * @enum
 */
export declare const AssetCategoryType: {
    readonly AUTH_APP_GRAPHIC: "AUTH_APP_GRAPHIC";
    readonly EMAIL_GRAPHIC: "EMAIL_GRAPHIC";
    readonly FAVICON_ICO: "FAVICON_ICO";
    readonly FAVICON_SVG: "FAVICON_SVG";
    readonly FORM_BACKGROUND: "FORM_BACKGROUND";
    readonly FORM_LOGO: "FORM_LOGO";
    readonly IDP_BUTTON_ICON: "IDP_BUTTON_ICON";
    readonly PAGE_BACKGROUND: "PAGE_BACKGROUND";
    readonly PAGE_FOOTER_BACKGROUND: "PAGE_FOOTER_BACKGROUND";
    readonly PAGE_FOOTER_LOGO: "PAGE_FOOTER_LOGO";
    readonly PAGE_HEADER_BACKGROUND: "PAGE_HEADER_BACKGROUND";
    readonly PAGE_HEADER_LOGO: "PAGE_HEADER_LOGO";
    readonly PASSKEY_GRAPHIC: "PASSKEY_GRAPHIC";
    readonly PASSWORD_GRAPHIC: "PASSWORD_GRAPHIC";
    readonly SMS_GRAPHIC: "SMS_GRAPHIC";
};
/**
 * @public
 */
export type AssetCategoryType = (typeof AssetCategoryType)[keyof typeof AssetCategoryType];
/**
 * @public
 * @enum
 */
export declare const AssetExtensionType: {
    readonly ICO: "ICO";
    readonly JPEG: "JPEG";
    readonly PNG: "PNG";
    readonly SVG: "SVG";
    readonly WEBP: "WEBP";
};
/**
 * @public
 */
export type AssetExtensionType = (typeof AssetExtensionType)[keyof typeof AssetExtensionType];
/**
 * @public
 * @enum
 */
export declare const ColorSchemeModeType: {
    readonly DARK: "DARK";
    readonly DYNAMIC: "DYNAMIC";
    readonly LIGHT: "LIGHT";
};
/**
 * @public
 */
export type ColorSchemeModeType = (typeof ColorSchemeModeType)[keyof typeof ColorSchemeModeType];
/**
 * @public
 * @enum
 */
export declare const VerifiedAttributeType: {
    readonly EMAIL: "email";
    readonly PHONE_NUMBER: "phone_number";
};
/**
 * @public
 */
export type VerifiedAttributeType = (typeof VerifiedAttributeType)[keyof typeof VerifiedAttributeType];
/**
 * @public
 * @enum
 */
export declare const IdentityProviderTypeType: {
    readonly Facebook: "Facebook";
    readonly Google: "Google";
    readonly LoginWithAmazon: "LoginWithAmazon";
    readonly OIDC: "OIDC";
    readonly SAML: "SAML";
    readonly SignInWithApple: "SignInWithApple";
};
/**
 * @public
 */
export type IdentityProviderTypeType = (typeof IdentityProviderTypeType)[keyof typeof IdentityProviderTypeType];
/**
 * @public
 * @enum
 */
export declare const TermsEnforcementType: {
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type TermsEnforcementType = (typeof TermsEnforcementType)[keyof typeof TermsEnforcementType];
/**
 * @public
 * @enum
 */
export declare const TermsSourceType: {
    readonly LINK: "LINK";
};
/**
 * @public
 */
export type TermsSourceType = (typeof TermsSourceType)[keyof typeof TermsSourceType];
/**
 * @public
 * @enum
 */
export declare const UserImportJobStatusType: {
    readonly Created: "Created";
    readonly Expired: "Expired";
    readonly Failed: "Failed";
    readonly InProgress: "InProgress";
    readonly Pending: "Pending";
    readonly Stopped: "Stopped";
    readonly Stopping: "Stopping";
    readonly Succeeded: "Succeeded";
};
/**
 * @public
 */
export type UserImportJobStatusType = (typeof UserImportJobStatusType)[keyof typeof UserImportJobStatusType];
/**
 * @public
 * @enum
 */
export declare const DeletionProtectionType: {
    readonly ACTIVE: "ACTIVE";
    readonly INACTIVE: "INACTIVE";
};
/**
 * @public
 */
export type DeletionProtectionType = (typeof DeletionProtectionType)[keyof typeof DeletionProtectionType];
/**
 * @public
 * @enum
 */
export declare const EmailSendingAccountType: {
    readonly COGNITO_DEFAULT: "COGNITO_DEFAULT";
    readonly DEVELOPER: "DEVELOPER";
};
/**
 * @public
 */
export type EmailSendingAccountType = (typeof EmailSendingAccountType)[keyof typeof EmailSendingAccountType];
/**
 * @public
 * @enum
 */
export declare const CustomEmailSenderLambdaVersionType: {
    readonly V1_0: "V1_0";
};
/**
 * @public
 */
export type CustomEmailSenderLambdaVersionType = (typeof CustomEmailSenderLambdaVersionType)[keyof typeof CustomEmailSenderLambdaVersionType];
/**
 * @public
 * @enum
 */
export declare const CustomSMSSenderLambdaVersionType: {
    readonly V1_0: "V1_0";
};
/**
 * @public
 */
export type CustomSMSSenderLambdaVersionType = (typeof CustomSMSSenderLambdaVersionType)[keyof typeof CustomSMSSenderLambdaVersionType];
/**
 * @public
 * @enum
 */
export declare const PreTokenGenerationLambdaVersionType: {
    readonly V1_0: "V1_0";
    readonly V2_0: "V2_0";
    readonly V3_0: "V3_0";
};
/**
 * @public
 */
export type PreTokenGenerationLambdaVersionType = (typeof PreTokenGenerationLambdaVersionType)[keyof typeof PreTokenGenerationLambdaVersionType];
/**
 * @public
 * @enum
 */
export declare const UserPoolMfaType: {
    readonly OFF: "OFF";
    readonly ON: "ON";
    readonly OPTIONAL: "OPTIONAL";
};
/**
 * @public
 */
export type UserPoolMfaType = (typeof UserPoolMfaType)[keyof typeof UserPoolMfaType];
/**
 * @public
 * @enum
 */
export declare const UsernameAttributeType: {
    readonly EMAIL: "email";
    readonly PHONE_NUMBER: "phone_number";
};
/**
 * @public
 */
export type UsernameAttributeType = (typeof UsernameAttributeType)[keyof typeof UsernameAttributeType];
/**
 * @public
 * @enum
 */
export declare const UserPoolTierType: {
    readonly ESSENTIALS: "ESSENTIALS";
    readonly LITE: "LITE";
    readonly PLUS: "PLUS";
};
/**
 * @public
 */
export type UserPoolTierType = (typeof UserPoolTierType)[keyof typeof UserPoolTierType];
/**
 * @public
 * @enum
 */
export declare const DefaultEmailOptionType: {
    readonly CONFIRM_WITH_CODE: "CONFIRM_WITH_CODE";
    readonly CONFIRM_WITH_LINK: "CONFIRM_WITH_LINK";
};
/**
 * @public
 */
export type DefaultEmailOptionType = (typeof DefaultEmailOptionType)[keyof typeof DefaultEmailOptionType];
/**
 * @public
 * @enum
 */
export declare const StatusType: {
    readonly Disabled: "Disabled";
    readonly Enabled: "Enabled";
};
/**
 * @public
 */
export type StatusType = (typeof StatusType)[keyof typeof StatusType];
/**
 * @public
 * @enum
 */
export declare const OAuthFlowType: {
    readonly client_credentials: "client_credentials";
    readonly code: "code";
    readonly implicit: "implicit";
};
/**
 * @public
 */
export type OAuthFlowType = (typeof OAuthFlowType)[keyof typeof OAuthFlowType];
/**
 * @public
 * @enum
 */
export declare const ExplicitAuthFlowsType: {
    readonly ADMIN_NO_SRP_AUTH: "ADMIN_NO_SRP_AUTH";
    readonly ALLOW_ADMIN_USER_PASSWORD_AUTH: "ALLOW_ADMIN_USER_PASSWORD_AUTH";
    readonly ALLOW_CUSTOM_AUTH: "ALLOW_CUSTOM_AUTH";
    readonly ALLOW_REFRESH_TOKEN_AUTH: "ALLOW_REFRESH_TOKEN_AUTH";
    readonly ALLOW_USER_AUTH: "ALLOW_USER_AUTH";
    readonly ALLOW_USER_PASSWORD_AUTH: "ALLOW_USER_PASSWORD_AUTH";
    readonly ALLOW_USER_SRP_AUTH: "ALLOW_USER_SRP_AUTH";
    readonly CUSTOM_AUTH_FLOW_ONLY: "CUSTOM_AUTH_FLOW_ONLY";
    readonly USER_PASSWORD_AUTH: "USER_PASSWORD_AUTH";
};
/**
 * @public
 */
export type ExplicitAuthFlowsType = (typeof ExplicitAuthFlowsType)[keyof typeof ExplicitAuthFlowsType];
/**
 * @public
 * @enum
 */
export declare const PreventUserExistenceErrorTypes: {
    readonly ENABLED: "ENABLED";
    readonly LEGACY: "LEGACY";
};
/**
 * @public
 */
export type PreventUserExistenceErrorTypes = (typeof PreventUserExistenceErrorTypes)[keyof typeof PreventUserExistenceErrorTypes];
/**
 * @public
 * @enum
 */
export declare const FeatureType: {
    readonly DISABLED: "DISABLED";
    readonly ENABLED: "ENABLED";
};
/**
 * @public
 */
export type FeatureType = (typeof FeatureType)[keyof typeof FeatureType];
/**
 * @public
 * @enum
 */
export declare const TimeUnitsType: {
    readonly DAYS: "days";
    readonly HOURS: "hours";
    readonly MINUTES: "minutes";
    readonly SECONDS: "seconds";
};
/**
 * @public
 */
export type TimeUnitsType = (typeof TimeUnitsType)[keyof typeof TimeUnitsType];
/**
 * @public
 * @enum
 */
export declare const CompromisedCredentialsEventActionType: {
    readonly BLOCK: "BLOCK";
    readonly NO_ACTION: "NO_ACTION";
};
/**
 * @public
 */
export type CompromisedCredentialsEventActionType = (typeof CompromisedCredentialsEventActionType)[keyof typeof CompromisedCredentialsEventActionType];
/**
 * @public
 * @enum
 */
export declare const EventFilterType: {
    readonly PASSWORD_CHANGE: "PASSWORD_CHANGE";
    readonly SIGN_IN: "SIGN_IN";
    readonly SIGN_UP: "SIGN_UP";
};
/**
 * @public
 */
export type EventFilterType = (typeof EventFilterType)[keyof typeof EventFilterType];
/**
 * @public
 * @enum
 */
export declare const DomainStatusType: {
    readonly ACTIVE: "ACTIVE";
    readonly CREATING: "CREATING";
    readonly DELETING: "DELETING";
    readonly FAILED: "FAILED";
    readonly UPDATING: "UPDATING";
};
/**
 * @public
 */
export type DomainStatusType = (typeof DomainStatusType)[keyof typeof DomainStatusType];
/**
 * @public
 * @enum
 */
export declare const EventSourceName: {
    readonly USER_AUTH_EVENTS: "userAuthEvents";
    readonly USER_NOTIFICATION: "userNotification";
};
/**
 * @public
 */
export type EventSourceName = (typeof EventSourceName)[keyof typeof EventSourceName];
/**
 * @public
 * @enum
 */
export declare const LogLevel: {
    readonly ERROR: "ERROR";
    readonly INFO: "INFO";
};
/**
 * @public
 */
export type LogLevel = (typeof LogLevel)[keyof typeof LogLevel];
/**
 * @public
 * @enum
 */
export declare const UserVerificationType: {
    readonly PREFERRED: "preferred";
    readonly REQUIRED: "required";
};
/**
 * @public
 */
export type UserVerificationType = (typeof UserVerificationType)[keyof typeof UserVerificationType];
/**
 * @public
 * @enum
 */
export declare const VerifySoftwareTokenResponseType: {
    readonly ERROR: "ERROR";
    readonly SUCCESS: "SUCCESS";
};
/**
 * @public
 */
export type VerifySoftwareTokenResponseType = (typeof VerifySoftwareTokenResponseType)[keyof typeof VerifySoftwareTokenResponseType];
