import { DocumentType as __DocumentType } from "@smithy/types";
import {
  AccountTakeoverEventActionType,
  AdvancedSecurityEnabledModeType,
  AdvancedSecurityModeType,
  AliasAttributeType,
  AssetCategoryType,
  AssetExtensionType,
  AttributeDataType,
  AuthFactorType,
  AuthFlowType,
  ChallengeName,
  ChallengeNameType,
  ChallengeResponse,
  ColorSchemeModeType,
  CompromisedCredentialsEventActionType,
  CustomEmailSenderLambdaVersionType,
  CustomSMSSenderLambdaVersionType,
  DefaultEmailOptionType,
  DeletionProtectionType,
  DeliveryMediumType,
  DeviceRememberedStatusType,
  DomainStatusType,
  EmailSendingAccountType,
  EventFilterType,
  EventResponseType,
  EventSourceName,
  EventType,
  ExplicitAuthFlowsType,
  FeatureType,
  FeedbackValueType,
  IdentityProviderTypeType,
  LogLevel,
  MessageActionType,
  OAuthFlowType,
  PreTokenGenerationLambdaVersionType,
  PreventUserExistenceErrorTypes,
  RecoveryOptionNameType,
  RiskDecisionType,
  RiskLevelType,
  StatusType,
  TermsEnforcementType,
  TermsSourceType,
  TimeUnitsType,
  UserImportJobStatusType,
  UsernameAttributeType,
  UserPoolMfaType,
  UserPoolTierType,
  UserStatusType,
  UserVerificationType,
  VerifiedAttributeType,
} from "./enums";
export interface RecoveryOptionType {
  Priority: number | undefined;
  Name: RecoveryOptionNameType | undefined;
}
export interface AccountRecoverySettingType {
  RecoveryMechanisms?: RecoveryOptionType[] | undefined;
}
export interface AccountTakeoverActionType {
  Notify: boolean | undefined;
  EventAction: AccountTakeoverEventActionType | undefined;
}
export interface AccountTakeoverActionsType {
  LowAction?: AccountTakeoverActionType | undefined;
  MediumAction?: AccountTakeoverActionType | undefined;
  HighAction?: AccountTakeoverActionType | undefined;
}
export interface NotifyEmailType {
  Subject: string | undefined;
  HtmlBody?: string | undefined;
  TextBody?: string | undefined;
}
export interface NotifyConfigurationType {
  From?: string | undefined;
  ReplyTo?: string | undefined;
  SourceArn: string | undefined;
  BlockEmail?: NotifyEmailType | undefined;
  NoActionEmail?: NotifyEmailType | undefined;
  MfaEmail?: NotifyEmailType | undefined;
}
export interface AccountTakeoverRiskConfigurationType {
  NotifyConfiguration?: NotifyConfigurationType | undefined;
  Actions: AccountTakeoverActionsType | undefined;
}
export interface NumberAttributeConstraintsType {
  MinValue?: string | undefined;
  MaxValue?: string | undefined;
}
export interface StringAttributeConstraintsType {
  MinLength?: string | undefined;
  MaxLength?: string | undefined;
}
export interface SchemaAttributeType {
  Name?: string | undefined;
  AttributeDataType?: AttributeDataType | undefined;
  DeveloperOnlyAttribute?: boolean | undefined;
  Mutable?: boolean | undefined;
  Required?: boolean | undefined;
  NumberAttributeConstraints?: NumberAttributeConstraintsType | undefined;
  StringAttributeConstraints?: StringAttributeConstraintsType | undefined;
}
export interface AddCustomAttributesRequest {
  UserPoolId: string | undefined;
  CustomAttributes: SchemaAttributeType[] | undefined;
}
export interface AddCustomAttributesResponse {}
export interface AdminAddUserToGroupRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  GroupName: string | undefined;
}
export interface AdminConfirmSignUpRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface AdminConfirmSignUpResponse {}
export interface AttributeType {
  Name: string | undefined;
  Value?: string | undefined;
}
export interface AdminCreateUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  UserAttributes?: AttributeType[] | undefined;
  ValidationData?: AttributeType[] | undefined;
  TemporaryPassword?: string | undefined;
  ForceAliasCreation?: boolean | undefined;
  MessageAction?: MessageActionType | undefined;
  DesiredDeliveryMediums?: DeliveryMediumType[] | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface MFAOptionType {
  DeliveryMedium?: DeliveryMediumType | undefined;
  AttributeName?: string | undefined;
}
export interface UserType {
  Username?: string | undefined;
  Attributes?: AttributeType[] | undefined;
  UserCreateDate?: Date | undefined;
  UserLastModifiedDate?: Date | undefined;
  Enabled?: boolean | undefined;
  UserStatus?: UserStatusType | undefined;
  MFAOptions?: MFAOptionType[] | undefined;
}
export interface AdminCreateUserResponse {
  User?: UserType | undefined;
}
export interface MessageTemplateType {
  SMSMessage?: string | undefined;
  EmailMessage?: string | undefined;
  EmailSubject?: string | undefined;
}
export interface AdminCreateUserConfigType {
  AllowAdminCreateUserOnly?: boolean | undefined;
  UnusedAccountValidityDays?: number | undefined;
  InviteMessageTemplate?: MessageTemplateType | undefined;
}
export interface AdminDeleteUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminDeleteUserAttributesRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  UserAttributeNames: string[] | undefined;
}
export interface AdminDeleteUserAttributesResponse {}
export interface ProviderUserIdentifierType {
  ProviderName?: string | undefined;
  ProviderAttributeName?: string | undefined;
  ProviderAttributeValue?: string | undefined;
}
export interface AdminDisableProviderForUserRequest {
  UserPoolId: string | undefined;
  User: ProviderUserIdentifierType | undefined;
}
export interface AdminDisableProviderForUserResponse {}
export interface AdminDisableUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminDisableUserResponse {}
export interface AdminEnableUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminEnableUserResponse {}
export interface AdminForgetDeviceRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  DeviceKey: string | undefined;
}
export interface AdminGetDeviceRequest {
  DeviceKey: string | undefined;
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface DeviceType {
  DeviceKey?: string | undefined;
  DeviceAttributes?: AttributeType[] | undefined;
  DeviceCreateDate?: Date | undefined;
  DeviceLastModifiedDate?: Date | undefined;
  DeviceLastAuthenticatedDate?: Date | undefined;
}
export interface AdminGetDeviceResponse {
  Device: DeviceType | undefined;
}
export interface AdminGetUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminGetUserResponse {
  Username: string | undefined;
  UserAttributes?: AttributeType[] | undefined;
  UserCreateDate?: Date | undefined;
  UserLastModifiedDate?: Date | undefined;
  Enabled?: boolean | undefined;
  UserStatus?: UserStatusType | undefined;
  MFAOptions?: MFAOptionType[] | undefined;
  PreferredMfaSetting?: string | undefined;
  UserMFASettingList?: string[] | undefined;
}
export interface AnalyticsMetadataType {
  AnalyticsEndpointId?: string | undefined;
}
export interface HttpHeader {
  headerName?: string | undefined;
  headerValue?: string | undefined;
}
export interface ContextDataType {
  IpAddress: string | undefined;
  ServerName: string | undefined;
  ServerPath: string | undefined;
  HttpHeaders: HttpHeader[] | undefined;
  EncodedData?: string | undefined;
}
export interface AdminInitiateAuthRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  AuthFlow: AuthFlowType | undefined;
  AuthParameters?: Record<string, string> | undefined;
  ClientMetadata?: Record<string, string> | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  ContextData?: ContextDataType | undefined;
  Session?: string | undefined;
}
export interface NewDeviceMetadataType {
  DeviceKey?: string | undefined;
  DeviceGroupKey?: string | undefined;
}
export interface AuthenticationResultType {
  AccessToken?: string | undefined;
  ExpiresIn?: number | undefined;
  TokenType?: string | undefined;
  RefreshToken?: string | undefined;
  IdToken?: string | undefined;
  NewDeviceMetadata?: NewDeviceMetadataType | undefined;
}
export interface AdminInitiateAuthResponse {
  ChallengeName?: ChallengeNameType | undefined;
  Session?: string | undefined;
  ChallengeParameters?: Record<string, string> | undefined;
  AuthenticationResult?: AuthenticationResultType | undefined;
  AvailableChallenges?: ChallengeNameType[] | undefined;
}
export interface AdminLinkProviderForUserRequest {
  UserPoolId: string | undefined;
  DestinationUser: ProviderUserIdentifierType | undefined;
  SourceUser: ProviderUserIdentifierType | undefined;
}
export interface AdminLinkProviderForUserResponse {}
export interface AdminListDevicesRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  Limit?: number | undefined;
  PaginationToken?: string | undefined;
}
export interface AdminListDevicesResponse {
  Devices?: DeviceType[] | undefined;
  PaginationToken?: string | undefined;
}
export interface AdminListGroupsForUserRequest {
  Username: string | undefined;
  UserPoolId: string | undefined;
  Limit?: number | undefined;
  NextToken?: string | undefined;
}
export interface GroupType {
  GroupName?: string | undefined;
  UserPoolId?: string | undefined;
  Description?: string | undefined;
  RoleArn?: string | undefined;
  Precedence?: number | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
}
export interface AdminListGroupsForUserResponse {
  Groups?: GroupType[] | undefined;
  NextToken?: string | undefined;
}
export interface AdminListUserAuthEventsRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ChallengeResponseType {
  ChallengeName?: ChallengeName | undefined;
  ChallengeResponse?: ChallengeResponse | undefined;
}
export interface EventContextDataType {
  IpAddress?: string | undefined;
  DeviceName?: string | undefined;
  Timezone?: string | undefined;
  City?: string | undefined;
  Country?: string | undefined;
}
export interface EventFeedbackType {
  FeedbackValue: FeedbackValueType | undefined;
  Provider: string | undefined;
  FeedbackDate?: Date | undefined;
}
export interface EventRiskType {
  RiskDecision?: RiskDecisionType | undefined;
  RiskLevel?: RiskLevelType | undefined;
  CompromisedCredentialsDetected?: boolean | undefined;
}
export interface AuthEventType {
  EventId?: string | undefined;
  EventType?: EventType | undefined;
  CreationDate?: Date | undefined;
  EventResponse?: EventResponseType | undefined;
  EventRisk?: EventRiskType | undefined;
  ChallengeResponses?: ChallengeResponseType[] | undefined;
  EventContextData?: EventContextDataType | undefined;
  EventFeedback?: EventFeedbackType | undefined;
}
export interface AdminListUserAuthEventsResponse {
  AuthEvents?: AuthEventType[] | undefined;
  NextToken?: string | undefined;
}
export interface AdminRemoveUserFromGroupRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  GroupName: string | undefined;
}
export interface AdminResetUserPasswordRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface AdminResetUserPasswordResponse {}
export interface AdminRespondToAuthChallengeRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  ChallengeName: ChallengeNameType | undefined;
  ChallengeResponses?: Record<string, string> | undefined;
  Session?: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  ContextData?: ContextDataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface AdminRespondToAuthChallengeResponse {
  ChallengeName?: ChallengeNameType | undefined;
  Session?: string | undefined;
  ChallengeParameters?: Record<string, string> | undefined;
  AuthenticationResult?: AuthenticationResultType | undefined;
}
export interface EmailMfaSettingsType {
  Enabled?: boolean | undefined;
  PreferredMfa?: boolean | undefined;
}
export interface SMSMfaSettingsType {
  Enabled?: boolean | undefined;
  PreferredMfa?: boolean | undefined;
}
export interface SoftwareTokenMfaSettingsType {
  Enabled?: boolean | undefined;
  PreferredMfa?: boolean | undefined;
}
export interface AdminSetUserMFAPreferenceRequest {
  SMSMfaSettings?: SMSMfaSettingsType | undefined;
  SoftwareTokenMfaSettings?: SoftwareTokenMfaSettingsType | undefined;
  EmailMfaSettings?: EmailMfaSettingsType | undefined;
  Username: string | undefined;
  UserPoolId: string | undefined;
}
export interface AdminSetUserMFAPreferenceResponse {}
export interface AdminSetUserPasswordRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  Password: string | undefined;
  Permanent?: boolean | undefined;
}
export interface AdminSetUserPasswordResponse {}
export interface AdminSetUserSettingsRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  MFAOptions: MFAOptionType[] | undefined;
}
export interface AdminSetUserSettingsResponse {}
export interface AdminUpdateAuthEventFeedbackRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  EventId: string | undefined;
  FeedbackValue: FeedbackValueType | undefined;
}
export interface AdminUpdateAuthEventFeedbackResponse {}
export interface AdminUpdateDeviceStatusRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  DeviceKey: string | undefined;
  DeviceRememberedStatus?: DeviceRememberedStatusType | undefined;
}
export interface AdminUpdateDeviceStatusResponse {}
export interface AdminUpdateUserAttributesRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  UserAttributes: AttributeType[] | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface AdminUpdateUserAttributesResponse {}
export interface AdminUserGlobalSignOutRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminUserGlobalSignOutResponse {}
export interface AdvancedSecurityAdditionalFlowsType {
  CustomAuthMode?: AdvancedSecurityEnabledModeType | undefined;
}
export interface AnalyticsConfigurationType {
  ApplicationId?: string | undefined;
  ApplicationArn?: string | undefined;
  RoleArn?: string | undefined;
  ExternalId?: string | undefined;
  UserDataShared?: boolean | undefined;
}
export interface AssetType {
  Category: AssetCategoryType | undefined;
  ColorMode: ColorSchemeModeType | undefined;
  Extension: AssetExtensionType | undefined;
  Bytes?: Uint8Array | undefined;
  ResourceId?: string | undefined;
}
export interface AssociateSoftwareTokenRequest {
  AccessToken?: string | undefined;
  Session?: string | undefined;
}
export interface AssociateSoftwareTokenResponse {
  SecretCode?: string | undefined;
  Session?: string | undefined;
}
export interface ChangePasswordRequest {
  PreviousPassword?: string | undefined;
  ProposedPassword: string | undefined;
  AccessToken: string | undefined;
}
export interface ChangePasswordResponse {}
export interface CompleteWebAuthnRegistrationRequest {
  AccessToken: string | undefined;
  Credential: __DocumentType | undefined;
}
export interface CompleteWebAuthnRegistrationResponse {}
export interface DeviceSecretVerifierConfigType {
  PasswordVerifier?: string | undefined;
  Salt?: string | undefined;
}
export interface ConfirmDeviceRequest {
  AccessToken: string | undefined;
  DeviceKey: string | undefined;
  DeviceSecretVerifierConfig?: DeviceSecretVerifierConfigType | undefined;
  DeviceName?: string | undefined;
}
export interface ConfirmDeviceResponse {
  UserConfirmationNecessary?: boolean | undefined;
}
export interface UserContextDataType {
  IpAddress?: string | undefined;
  EncodedData?: string | undefined;
}
export interface ConfirmForgotPasswordRequest {
  ClientId: string | undefined;
  SecretHash?: string | undefined;
  Username: string | undefined;
  ConfirmationCode: string | undefined;
  Password: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  UserContextData?: UserContextDataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface ConfirmForgotPasswordResponse {}
export interface ConfirmSignUpRequest {
  ClientId: string | undefined;
  SecretHash?: string | undefined;
  Username: string | undefined;
  ConfirmationCode: string | undefined;
  ForceAliasCreation?: boolean | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  UserContextData?: UserContextDataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
  Session?: string | undefined;
}
export interface ConfirmSignUpResponse {
  Session?: string | undefined;
}
export interface CreateGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
  Description?: string | undefined;
  RoleArn?: string | undefined;
  Precedence?: number | undefined;
}
export interface CreateGroupResponse {
  Group?: GroupType | undefined;
}
export interface CreateIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
  ProviderType: IdentityProviderTypeType | undefined;
  ProviderDetails: Record<string, string> | undefined;
  AttributeMapping?: Record<string, string> | undefined;
  IdpIdentifiers?: string[] | undefined;
}
export interface IdentityProviderType {
  UserPoolId?: string | undefined;
  ProviderName?: string | undefined;
  ProviderType?: IdentityProviderTypeType | undefined;
  ProviderDetails?: Record<string, string> | undefined;
  AttributeMapping?: Record<string, string> | undefined;
  IdpIdentifiers?: string[] | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
}
export interface CreateIdentityProviderResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface CreateManagedLoginBrandingRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  UseCognitoProvidedValues?: boolean | undefined;
  Settings?: __DocumentType | undefined;
  Assets?: AssetType[] | undefined;
}
export interface ManagedLoginBrandingType {
  ManagedLoginBrandingId?: string | undefined;
  UserPoolId?: string | undefined;
  UseCognitoProvidedValues?: boolean | undefined;
  Settings?: __DocumentType | undefined;
  Assets?: AssetType[] | undefined;
  CreationDate?: Date | undefined;
  LastModifiedDate?: Date | undefined;
}
export interface CreateManagedLoginBrandingResponse {
  ManagedLoginBranding?: ManagedLoginBrandingType | undefined;
}
export interface ResourceServerScopeType {
  ScopeName: string | undefined;
  ScopeDescription: string | undefined;
}
export interface CreateResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
  Name: string | undefined;
  Scopes?: ResourceServerScopeType[] | undefined;
}
export interface ResourceServerType {
  UserPoolId?: string | undefined;
  Identifier?: string | undefined;
  Name?: string | undefined;
  Scopes?: ResourceServerScopeType[] | undefined;
}
export interface CreateResourceServerResponse {
  ResourceServer: ResourceServerType | undefined;
}
export interface CreateTermsRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  TermsName: string | undefined;
  TermsSource: TermsSourceType | undefined;
  Enforcement: TermsEnforcementType | undefined;
  Links?: Record<string, string> | undefined;
}
export interface TermsType {
  TermsId: string | undefined;
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  TermsName: string | undefined;
  TermsSource: TermsSourceType | undefined;
  Enforcement: TermsEnforcementType | undefined;
  Links: Record<string, string> | undefined;
  CreationDate: Date | undefined;
  LastModifiedDate: Date | undefined;
}
export interface CreateTermsResponse {
  Terms?: TermsType | undefined;
}
export interface CreateUserImportJobRequest {
  JobName: string | undefined;
  UserPoolId: string | undefined;
  CloudWatchLogsRoleArn: string | undefined;
}
export interface UserImportJobType {
  JobName?: string | undefined;
  JobId?: string | undefined;
  UserPoolId?: string | undefined;
  PreSignedUrl?: string | undefined;
  CreationDate?: Date | undefined;
  StartDate?: Date | undefined;
  CompletionDate?: Date | undefined;
  Status?: UserImportJobStatusType | undefined;
  CloudWatchLogsRoleArn?: string | undefined;
  ImportedUsers?: number | undefined;
  SkippedUsers?: number | undefined;
  FailedUsers?: number | undefined;
  CompletionMessage?: string | undefined;
}
export interface CreateUserImportJobResponse {
  UserImportJob?: UserImportJobType | undefined;
}
export interface DeviceConfigurationType {
  ChallengeRequiredOnNewDevice?: boolean | undefined;
  DeviceOnlyRememberedOnUserPrompt?: boolean | undefined;
}
export interface EmailConfigurationType {
  SourceArn?: string | undefined;
  ReplyToEmailAddress?: string | undefined;
  EmailSendingAccount?: EmailSendingAccountType | undefined;
  From?: string | undefined;
  ConfigurationSet?: string | undefined;
}
export interface CustomEmailLambdaVersionConfigType {
  LambdaVersion: CustomEmailSenderLambdaVersionType | undefined;
  LambdaArn: string | undefined;
}
export interface CustomSMSLambdaVersionConfigType {
  LambdaVersion: CustomSMSSenderLambdaVersionType | undefined;
  LambdaArn: string | undefined;
}
export interface PreTokenGenerationVersionConfigType {
  LambdaVersion: PreTokenGenerationLambdaVersionType | undefined;
  LambdaArn: string | undefined;
}
export interface LambdaConfigType {
  PreSignUp?: string | undefined;
  CustomMessage?: string | undefined;
  PostConfirmation?: string | undefined;
  PreAuthentication?: string | undefined;
  PostAuthentication?: string | undefined;
  DefineAuthChallenge?: string | undefined;
  CreateAuthChallenge?: string | undefined;
  VerifyAuthChallengeResponse?: string | undefined;
  PreTokenGeneration?: string | undefined;
  UserMigration?: string | undefined;
  PreTokenGenerationConfig?: PreTokenGenerationVersionConfigType | undefined;
  CustomSMSSender?: CustomSMSLambdaVersionConfigType | undefined;
  CustomEmailSender?: CustomEmailLambdaVersionConfigType | undefined;
  KMSKeyID?: string | undefined;
}
export interface PasswordPolicyType {
  MinimumLength?: number | undefined;
  RequireUppercase?: boolean | undefined;
  RequireLowercase?: boolean | undefined;
  RequireNumbers?: boolean | undefined;
  RequireSymbols?: boolean | undefined;
  PasswordHistorySize?: number | undefined;
  TemporaryPasswordValidityDays?: number | undefined;
}
export interface SignInPolicyType {
  AllowedFirstAuthFactors?: AuthFactorType[] | undefined;
}
export interface UserPoolPolicyType {
  PasswordPolicy?: PasswordPolicyType | undefined;
  SignInPolicy?: SignInPolicyType | undefined;
}
export interface SmsConfigurationType {
  SnsCallerArn: string | undefined;
  ExternalId?: string | undefined;
  SnsRegion?: string | undefined;
}
export interface UserAttributeUpdateSettingsType {
  AttributesRequireVerificationBeforeUpdate?:
    | VerifiedAttributeType[]
    | undefined;
}
export interface UsernameConfigurationType {
  CaseSensitive: boolean | undefined;
}
export interface UserPoolAddOnsType {
  AdvancedSecurityMode: AdvancedSecurityModeType | undefined;
  AdvancedSecurityAdditionalFlows?:
    | AdvancedSecurityAdditionalFlowsType
    | undefined;
}
export interface VerificationMessageTemplateType {
  SmsMessage?: string | undefined;
  EmailMessage?: string | undefined;
  EmailSubject?: string | undefined;
  EmailMessageByLink?: string | undefined;
  EmailSubjectByLink?: string | undefined;
  DefaultEmailOption?: DefaultEmailOptionType | undefined;
}
export interface CreateUserPoolRequest {
  PoolName: string | undefined;
  Policies?: UserPoolPolicyType | undefined;
  DeletionProtection?: DeletionProtectionType | undefined;
  LambdaConfig?: LambdaConfigType | undefined;
  AutoVerifiedAttributes?: VerifiedAttributeType[] | undefined;
  AliasAttributes?: AliasAttributeType[] | undefined;
  UsernameAttributes?: UsernameAttributeType[] | undefined;
  SmsVerificationMessage?: string | undefined;
  EmailVerificationMessage?: string | undefined;
  EmailVerificationSubject?: string | undefined;
  VerificationMessageTemplate?: VerificationMessageTemplateType | undefined;
  SmsAuthenticationMessage?: string | undefined;
  MfaConfiguration?: UserPoolMfaType | undefined;
  UserAttributeUpdateSettings?: UserAttributeUpdateSettingsType | undefined;
  DeviceConfiguration?: DeviceConfigurationType | undefined;
  EmailConfiguration?: EmailConfigurationType | undefined;
  SmsConfiguration?: SmsConfigurationType | undefined;
  UserPoolTags?: Record<string, string> | undefined;
  AdminCreateUserConfig?: AdminCreateUserConfigType | undefined;
  Schema?: SchemaAttributeType[] | undefined;
  UserPoolAddOns?: UserPoolAddOnsType | undefined;
  UsernameConfiguration?: UsernameConfigurationType | undefined;
  AccountRecoverySetting?: AccountRecoverySettingType | undefined;
  UserPoolTier?: UserPoolTierType | undefined;
}
export interface UserPoolType {
  Id?: string | undefined;
  Name?: string | undefined;
  Policies?: UserPoolPolicyType | undefined;
  DeletionProtection?: DeletionProtectionType | undefined;
  LambdaConfig?: LambdaConfigType | undefined;
  Status?: StatusType | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
  SchemaAttributes?: SchemaAttributeType[] | undefined;
  AutoVerifiedAttributes?: VerifiedAttributeType[] | undefined;
  AliasAttributes?: AliasAttributeType[] | undefined;
  UsernameAttributes?: UsernameAttributeType[] | undefined;
  SmsVerificationMessage?: string | undefined;
  EmailVerificationMessage?: string | undefined;
  EmailVerificationSubject?: string | undefined;
  VerificationMessageTemplate?: VerificationMessageTemplateType | undefined;
  SmsAuthenticationMessage?: string | undefined;
  UserAttributeUpdateSettings?: UserAttributeUpdateSettingsType | undefined;
  MfaConfiguration?: UserPoolMfaType | undefined;
  DeviceConfiguration?: DeviceConfigurationType | undefined;
  EstimatedNumberOfUsers?: number | undefined;
  EmailConfiguration?: EmailConfigurationType | undefined;
  SmsConfiguration?: SmsConfigurationType | undefined;
  UserPoolTags?: Record<string, string> | undefined;
  SmsConfigurationFailure?: string | undefined;
  EmailConfigurationFailure?: string | undefined;
  Domain?: string | undefined;
  CustomDomain?: string | undefined;
  AdminCreateUserConfig?: AdminCreateUserConfigType | undefined;
  UserPoolAddOns?: UserPoolAddOnsType | undefined;
  UsernameConfiguration?: UsernameConfigurationType | undefined;
  Arn?: string | undefined;
  AccountRecoverySetting?: AccountRecoverySettingType | undefined;
  UserPoolTier?: UserPoolTierType | undefined;
}
export interface CreateUserPoolResponse {
  UserPool?: UserPoolType | undefined;
}
export interface RefreshTokenRotationType {
  Feature: FeatureType | undefined;
  RetryGracePeriodSeconds?: number | undefined;
}
export interface TokenValidityUnitsType {
  AccessToken?: TimeUnitsType | undefined;
  IdToken?: TimeUnitsType | undefined;
  RefreshToken?: TimeUnitsType | undefined;
}
export interface CreateUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientName: string | undefined;
  GenerateSecret?: boolean | undefined;
  RefreshTokenValidity?: number | undefined;
  AccessTokenValidity?: number | undefined;
  IdTokenValidity?: number | undefined;
  TokenValidityUnits?: TokenValidityUnitsType | undefined;
  ReadAttributes?: string[] | undefined;
  WriteAttributes?: string[] | undefined;
  ExplicitAuthFlows?: ExplicitAuthFlowsType[] | undefined;
  SupportedIdentityProviders?: string[] | undefined;
  CallbackURLs?: string[] | undefined;
  LogoutURLs?: string[] | undefined;
  DefaultRedirectURI?: string | undefined;
  AllowedOAuthFlows?: OAuthFlowType[] | undefined;
  AllowedOAuthScopes?: string[] | undefined;
  AllowedOAuthFlowsUserPoolClient?: boolean | undefined;
  AnalyticsConfiguration?: AnalyticsConfigurationType | undefined;
  PreventUserExistenceErrors?: PreventUserExistenceErrorTypes | undefined;
  EnableTokenRevocation?: boolean | undefined;
  EnablePropagateAdditionalUserContextData?: boolean | undefined;
  AuthSessionValidity?: number | undefined;
  RefreshTokenRotation?: RefreshTokenRotationType | undefined;
}
export interface UserPoolClientType {
  UserPoolId?: string | undefined;
  ClientName?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
  RefreshTokenValidity?: number | undefined;
  AccessTokenValidity?: number | undefined;
  IdTokenValidity?: number | undefined;
  TokenValidityUnits?: TokenValidityUnitsType | undefined;
  ReadAttributes?: string[] | undefined;
  WriteAttributes?: string[] | undefined;
  ExplicitAuthFlows?: ExplicitAuthFlowsType[] | undefined;
  SupportedIdentityProviders?: string[] | undefined;
  CallbackURLs?: string[] | undefined;
  LogoutURLs?: string[] | undefined;
  DefaultRedirectURI?: string | undefined;
  AllowedOAuthFlows?: OAuthFlowType[] | undefined;
  AllowedOAuthScopes?: string[] | undefined;
  AllowedOAuthFlowsUserPoolClient?: boolean | undefined;
  AnalyticsConfiguration?: AnalyticsConfigurationType | undefined;
  PreventUserExistenceErrors?: PreventUserExistenceErrorTypes | undefined;
  EnableTokenRevocation?: boolean | undefined;
  EnablePropagateAdditionalUserContextData?: boolean | undefined;
  AuthSessionValidity?: number | undefined;
  RefreshTokenRotation?: RefreshTokenRotationType | undefined;
}
export interface CreateUserPoolClientResponse {
  UserPoolClient?: UserPoolClientType | undefined;
}
export interface CustomDomainConfigType {
  CertificateArn: string | undefined;
}
export interface CreateUserPoolDomainRequest {
  Domain: string | undefined;
  UserPoolId: string | undefined;
  ManagedLoginVersion?: number | undefined;
  CustomDomainConfig?: CustomDomainConfigType | undefined;
}
export interface CreateUserPoolDomainResponse {
  ManagedLoginVersion?: number | undefined;
  CloudFrontDomain?: string | undefined;
}
export interface DeleteGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
}
export interface DeleteIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
}
export interface DeleteManagedLoginBrandingRequest {
  ManagedLoginBrandingId: string | undefined;
  UserPoolId: string | undefined;
}
export interface DeleteResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
}
export interface DeleteTermsRequest {
  TermsId: string | undefined;
  UserPoolId: string | undefined;
}
export interface DeleteUserRequest {
  AccessToken: string | undefined;
}
export interface DeleteUserAttributesRequest {
  UserAttributeNames: string[] | undefined;
  AccessToken: string | undefined;
}
export interface DeleteUserAttributesResponse {}
export interface DeleteUserPoolRequest {
  UserPoolId: string | undefined;
}
export interface DeleteUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
}
export interface DeleteUserPoolDomainRequest {
  Domain: string | undefined;
  UserPoolId: string | undefined;
}
export interface DeleteUserPoolDomainResponse {}
export interface DeleteWebAuthnCredentialRequest {
  AccessToken: string | undefined;
  CredentialId: string | undefined;
}
export interface DeleteWebAuthnCredentialResponse {}
export interface DescribeIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
}
export interface DescribeIdentityProviderResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface DescribeManagedLoginBrandingRequest {
  UserPoolId: string | undefined;
  ManagedLoginBrandingId: string | undefined;
  ReturnMergedResources?: boolean | undefined;
}
export interface DescribeManagedLoginBrandingResponse {
  ManagedLoginBranding?: ManagedLoginBrandingType | undefined;
}
export interface DescribeManagedLoginBrandingByClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  ReturnMergedResources?: boolean | undefined;
}
export interface DescribeManagedLoginBrandingByClientResponse {
  ManagedLoginBranding?: ManagedLoginBrandingType | undefined;
}
export interface DescribeResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
}
export interface DescribeResourceServerResponse {
  ResourceServer: ResourceServerType | undefined;
}
export interface DescribeRiskConfigurationRequest {
  UserPoolId: string | undefined;
  ClientId?: string | undefined;
}
export interface CompromisedCredentialsActionsType {
  EventAction: CompromisedCredentialsEventActionType | undefined;
}
export interface CompromisedCredentialsRiskConfigurationType {
  EventFilter?: EventFilterType[] | undefined;
  Actions: CompromisedCredentialsActionsType | undefined;
}
export interface RiskExceptionConfigurationType {
  BlockedIPRangeList?: string[] | undefined;
  SkippedIPRangeList?: string[] | undefined;
}
export interface RiskConfigurationType {
  UserPoolId?: string | undefined;
  ClientId?: string | undefined;
  CompromisedCredentialsRiskConfiguration?:
    | CompromisedCredentialsRiskConfigurationType
    | undefined;
  AccountTakeoverRiskConfiguration?:
    | AccountTakeoverRiskConfigurationType
    | undefined;
  RiskExceptionConfiguration?: RiskExceptionConfigurationType | undefined;
  LastModifiedDate?: Date | undefined;
}
export interface DescribeRiskConfigurationResponse {
  RiskConfiguration: RiskConfigurationType | undefined;
}
export interface DescribeTermsRequest {
  TermsId: string | undefined;
  UserPoolId: string | undefined;
}
export interface DescribeTermsResponse {
  Terms?: TermsType | undefined;
}
export interface DescribeUserImportJobRequest {
  UserPoolId: string | undefined;
  JobId: string | undefined;
}
export interface DescribeUserImportJobResponse {
  UserImportJob?: UserImportJobType | undefined;
}
export interface DescribeUserPoolRequest {
  UserPoolId: string | undefined;
}
export interface DescribeUserPoolResponse {
  UserPool?: UserPoolType | undefined;
}
export interface DescribeUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
}
export interface DescribeUserPoolClientResponse {
  UserPoolClient?: UserPoolClientType | undefined;
}
export interface DescribeUserPoolDomainRequest {
  Domain: string | undefined;
}
export interface DomainDescriptionType {
  UserPoolId?: string | undefined;
  AWSAccountId?: string | undefined;
  Domain?: string | undefined;
  S3Bucket?: string | undefined;
  CloudFrontDistribution?: string | undefined;
  Version?: string | undefined;
  Status?: DomainStatusType | undefined;
  CustomDomainConfig?: CustomDomainConfigType | undefined;
  ManagedLoginVersion?: number | undefined;
}
export interface DescribeUserPoolDomainResponse {
  DomainDescription?: DomainDescriptionType | undefined;
}
export interface ForgetDeviceRequest {
  AccessToken?: string | undefined;
  DeviceKey: string | undefined;
}
export interface ForgotPasswordRequest {
  ClientId: string | undefined;
  SecretHash?: string | undefined;
  UserContextData?: UserContextDataType | undefined;
  Username: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface CodeDeliveryDetailsType {
  Destination?: string | undefined;
  DeliveryMedium?: DeliveryMediumType | undefined;
  AttributeName?: string | undefined;
}
export interface ForgotPasswordResponse {
  CodeDeliveryDetails?: CodeDeliveryDetailsType | undefined;
}
export interface GetCSVHeaderRequest {
  UserPoolId: string | undefined;
}
export interface GetCSVHeaderResponse {
  UserPoolId?: string | undefined;
  CSVHeader?: string[] | undefined;
}
export interface GetDeviceRequest {
  DeviceKey: string | undefined;
  AccessToken?: string | undefined;
}
export interface GetDeviceResponse {
  Device: DeviceType | undefined;
}
export interface GetGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
}
export interface GetGroupResponse {
  Group?: GroupType | undefined;
}
export interface GetIdentityProviderByIdentifierRequest {
  UserPoolId: string | undefined;
  IdpIdentifier: string | undefined;
}
export interface GetIdentityProviderByIdentifierResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface GetLogDeliveryConfigurationRequest {
  UserPoolId: string | undefined;
}
export interface CloudWatchLogsConfigurationType {
  LogGroupArn?: string | undefined;
}
export interface FirehoseConfigurationType {
  StreamArn?: string | undefined;
}
export interface S3ConfigurationType {
  BucketArn?: string | undefined;
}
export interface LogConfigurationType {
  LogLevel: LogLevel | undefined;
  EventSource: EventSourceName | undefined;
  CloudWatchLogsConfiguration?: CloudWatchLogsConfigurationType | undefined;
  S3Configuration?: S3ConfigurationType | undefined;
  FirehoseConfiguration?: FirehoseConfigurationType | undefined;
}
export interface LogDeliveryConfigurationType {
  UserPoolId: string | undefined;
  LogConfigurations: LogConfigurationType[] | undefined;
}
export interface GetLogDeliveryConfigurationResponse {
  LogDeliveryConfiguration?: LogDeliveryConfigurationType | undefined;
}
export interface GetSigningCertificateRequest {
  UserPoolId: string | undefined;
}
export interface GetSigningCertificateResponse {
  Certificate?: string | undefined;
}
export interface GetTokensFromRefreshTokenRequest {
  RefreshToken: string | undefined;
  ClientId: string | undefined;
  ClientSecret?: string | undefined;
  DeviceKey?: string | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface GetTokensFromRefreshTokenResponse {
  AuthenticationResult?: AuthenticationResultType | undefined;
}
export interface GetUICustomizationRequest {
  UserPoolId: string | undefined;
  ClientId?: string | undefined;
}
export interface UICustomizationType {
  UserPoolId?: string | undefined;
  ClientId?: string | undefined;
  ImageUrl?: string | undefined;
  CSS?: string | undefined;
  CSSVersion?: string | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
}
export interface GetUICustomizationResponse {
  UICustomization: UICustomizationType | undefined;
}
export interface GetUserRequest {
  AccessToken: string | undefined;
}
export interface GetUserResponse {
  Username: string | undefined;
  UserAttributes: AttributeType[] | undefined;
  MFAOptions?: MFAOptionType[] | undefined;
  PreferredMfaSetting?: string | undefined;
  UserMFASettingList?: string[] | undefined;
}
export interface GetUserAttributeVerificationCodeRequest {
  AccessToken: string | undefined;
  AttributeName: string | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface GetUserAttributeVerificationCodeResponse {
  CodeDeliveryDetails?: CodeDeliveryDetailsType | undefined;
}
export interface GetUserAuthFactorsRequest {
  AccessToken: string | undefined;
}
export interface GetUserAuthFactorsResponse {
  Username: string | undefined;
  PreferredMfaSetting?: string | undefined;
  UserMFASettingList?: string[] | undefined;
  ConfiguredUserAuthFactors?: AuthFactorType[] | undefined;
}
export interface GetUserPoolMfaConfigRequest {
  UserPoolId: string | undefined;
}
export interface EmailMfaConfigType {
  Message?: string | undefined;
  Subject?: string | undefined;
}
export interface SmsMfaConfigType {
  SmsAuthenticationMessage?: string | undefined;
  SmsConfiguration?: SmsConfigurationType | undefined;
}
export interface SoftwareTokenMfaConfigType {
  Enabled?: boolean | undefined;
}
export interface WebAuthnConfigurationType {
  RelyingPartyId?: string | undefined;
  UserVerification?: UserVerificationType | undefined;
}
export interface GetUserPoolMfaConfigResponse {
  SmsMfaConfiguration?: SmsMfaConfigType | undefined;
  SoftwareTokenMfaConfiguration?: SoftwareTokenMfaConfigType | undefined;
  EmailMfaConfiguration?: EmailMfaConfigType | undefined;
  MfaConfiguration?: UserPoolMfaType | undefined;
  WebAuthnConfiguration?: WebAuthnConfigurationType | undefined;
}
export interface GlobalSignOutRequest {
  AccessToken: string | undefined;
}
export interface GlobalSignOutResponse {}
export interface InitiateAuthRequest {
  AuthFlow: AuthFlowType | undefined;
  AuthParameters?: Record<string, string> | undefined;
  ClientMetadata?: Record<string, string> | undefined;
  ClientId: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  UserContextData?: UserContextDataType | undefined;
  Session?: string | undefined;
}
export interface InitiateAuthResponse {
  ChallengeName?: ChallengeNameType | undefined;
  Session?: string | undefined;
  ChallengeParameters?: Record<string, string> | undefined;
  AuthenticationResult?: AuthenticationResultType | undefined;
  AvailableChallenges?: ChallengeNameType[] | undefined;
}
export interface ListDevicesRequest {
  AccessToken: string | undefined;
  Limit?: number | undefined;
  PaginationToken?: string | undefined;
}
export interface ListDevicesResponse {
  Devices?: DeviceType[] | undefined;
  PaginationToken?: string | undefined;
}
export interface ListGroupsRequest {
  UserPoolId: string | undefined;
  Limit?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListGroupsResponse {
  Groups?: GroupType[] | undefined;
  NextToken?: string | undefined;
}
export interface ListIdentityProvidersRequest {
  UserPoolId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ProviderDescription {
  ProviderName?: string | undefined;
  ProviderType?: IdentityProviderTypeType | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
}
export interface ListIdentityProvidersResponse {
  Providers: ProviderDescription[] | undefined;
  NextToken?: string | undefined;
}
export interface ListResourceServersRequest {
  UserPoolId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListResourceServersResponse {
  ResourceServers: ResourceServerType[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTagsForResourceRequest {
  ResourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Record<string, string> | undefined;
}
export interface ListTermsRequest {
  UserPoolId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface TermsDescriptionType {
  TermsId: string | undefined;
  TermsName: string | undefined;
  Enforcement: TermsEnforcementType | undefined;
  CreationDate: Date | undefined;
  LastModifiedDate: Date | undefined;
}
export interface ListTermsResponse {
  Terms: TermsDescriptionType[] | undefined;
  NextToken?: string | undefined;
}
export interface ListUserImportJobsRequest {
  UserPoolId: string | undefined;
  MaxResults: number | undefined;
  PaginationToken?: string | undefined;
}
export interface ListUserImportJobsResponse {
  UserImportJobs?: UserImportJobType[] | undefined;
  PaginationToken?: string | undefined;
}
export interface ListUserPoolClientsRequest {
  UserPoolId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface UserPoolClientDescription {
  ClientId?: string | undefined;
  UserPoolId?: string | undefined;
  ClientName?: string | undefined;
}
export interface ListUserPoolClientsResponse {
  UserPoolClients?: UserPoolClientDescription[] | undefined;
  NextToken?: string | undefined;
}
export interface ListUserPoolsRequest {
  NextToken?: string | undefined;
  MaxResults: number | undefined;
}
export interface UserPoolDescriptionType {
  Id?: string | undefined;
  Name?: string | undefined;
  LambdaConfig?: LambdaConfigType | undefined;
  Status?: StatusType | undefined;
  LastModifiedDate?: Date | undefined;
  CreationDate?: Date | undefined;
}
export interface ListUserPoolsResponse {
  UserPools?: UserPoolDescriptionType[] | undefined;
  NextToken?: string | undefined;
}
export interface ListUsersRequest {
  UserPoolId: string | undefined;
  AttributesToGet?: string[] | undefined;
  Limit?: number | undefined;
  PaginationToken?: string | undefined;
  Filter?: string | undefined;
}
export interface ListUsersResponse {
  Users?: UserType[] | undefined;
  PaginationToken?: string | undefined;
}
export interface ListUsersInGroupRequest {
  UserPoolId: string | undefined;
  GroupName: string | undefined;
  Limit?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListUsersInGroupResponse {
  Users?: UserType[] | undefined;
  NextToken?: string | undefined;
}
export interface ListWebAuthnCredentialsRequest {
  AccessToken: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface WebAuthnCredentialDescription {
  CredentialId: string | undefined;
  FriendlyCredentialName: string | undefined;
  RelyingPartyId: string | undefined;
  AuthenticatorAttachment?: string | undefined;
  AuthenticatorTransports: string[] | undefined;
  CreatedAt: Date | undefined;
}
export interface ListWebAuthnCredentialsResponse {
  Credentials: WebAuthnCredentialDescription[] | undefined;
  NextToken?: string | undefined;
}
export interface ResendConfirmationCodeRequest {
  ClientId: string | undefined;
  SecretHash?: string | undefined;
  UserContextData?: UserContextDataType | undefined;
  Username: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface ResendConfirmationCodeResponse {
  CodeDeliveryDetails?: CodeDeliveryDetailsType | undefined;
}
export interface RespondToAuthChallengeRequest {
  ClientId: string | undefined;
  ChallengeName: ChallengeNameType | undefined;
  Session?: string | undefined;
  ChallengeResponses?: Record<string, string> | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  UserContextData?: UserContextDataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface RespondToAuthChallengeResponse {
  ChallengeName?: ChallengeNameType | undefined;
  Session?: string | undefined;
  ChallengeParameters?: Record<string, string> | undefined;
  AuthenticationResult?: AuthenticationResultType | undefined;
}
export interface RevokeTokenRequest {
  Token: string | undefined;
  ClientId: string | undefined;
  ClientSecret?: string | undefined;
}
export interface RevokeTokenResponse {}
export interface SetLogDeliveryConfigurationRequest {
  UserPoolId: string | undefined;
  LogConfigurations: LogConfigurationType[] | undefined;
}
export interface SetLogDeliveryConfigurationResponse {
  LogDeliveryConfiguration?: LogDeliveryConfigurationType | undefined;
}
export interface SetRiskConfigurationRequest {
  UserPoolId: string | undefined;
  ClientId?: string | undefined;
  CompromisedCredentialsRiskConfiguration?:
    | CompromisedCredentialsRiskConfigurationType
    | undefined;
  AccountTakeoverRiskConfiguration?:
    | AccountTakeoverRiskConfigurationType
    | undefined;
  RiskExceptionConfiguration?: RiskExceptionConfigurationType | undefined;
}
export interface SetRiskConfigurationResponse {
  RiskConfiguration: RiskConfigurationType | undefined;
}
export interface SetUICustomizationRequest {
  UserPoolId: string | undefined;
  ClientId?: string | undefined;
  CSS?: string | undefined;
  ImageFile?: Uint8Array | undefined;
}
export interface SetUICustomizationResponse {
  UICustomization: UICustomizationType | undefined;
}
export interface SetUserMFAPreferenceRequest {
  SMSMfaSettings?: SMSMfaSettingsType | undefined;
  SoftwareTokenMfaSettings?: SoftwareTokenMfaSettingsType | undefined;
  EmailMfaSettings?: EmailMfaSettingsType | undefined;
  AccessToken: string | undefined;
}
export interface SetUserMFAPreferenceResponse {}
export interface SetUserPoolMfaConfigRequest {
  UserPoolId: string | undefined;
  SmsMfaConfiguration?: SmsMfaConfigType | undefined;
  SoftwareTokenMfaConfiguration?: SoftwareTokenMfaConfigType | undefined;
  EmailMfaConfiguration?: EmailMfaConfigType | undefined;
  MfaConfiguration?: UserPoolMfaType | undefined;
  WebAuthnConfiguration?: WebAuthnConfigurationType | undefined;
}
export interface SetUserPoolMfaConfigResponse {
  SmsMfaConfiguration?: SmsMfaConfigType | undefined;
  SoftwareTokenMfaConfiguration?: SoftwareTokenMfaConfigType | undefined;
  EmailMfaConfiguration?: EmailMfaConfigType | undefined;
  MfaConfiguration?: UserPoolMfaType | undefined;
  WebAuthnConfiguration?: WebAuthnConfigurationType | undefined;
}
export interface SetUserSettingsRequest {
  AccessToken: string | undefined;
  MFAOptions: MFAOptionType[] | undefined;
}
export interface SetUserSettingsResponse {}
export interface SignUpRequest {
  ClientId: string | undefined;
  SecretHash?: string | undefined;
  Username: string | undefined;
  Password?: string | undefined;
  UserAttributes?: AttributeType[] | undefined;
  ValidationData?: AttributeType[] | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType | undefined;
  UserContextData?: UserContextDataType | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface SignUpResponse {
  UserConfirmed: boolean | undefined;
  CodeDeliveryDetails?: CodeDeliveryDetailsType | undefined;
  UserSub: string | undefined;
  Session?: string | undefined;
}
export interface StartUserImportJobRequest {
  UserPoolId: string | undefined;
  JobId: string | undefined;
}
export interface StartUserImportJobResponse {
  UserImportJob?: UserImportJobType | undefined;
}
export interface StartWebAuthnRegistrationRequest {
  AccessToken: string | undefined;
}
export interface StartWebAuthnRegistrationResponse {
  CredentialCreationOptions: __DocumentType | undefined;
}
export interface StopUserImportJobRequest {
  UserPoolId: string | undefined;
  JobId: string | undefined;
}
export interface StopUserImportJobResponse {
  UserImportJob?: UserImportJobType | undefined;
}
export interface TagResourceRequest {
  ResourceArn: string | undefined;
  Tags: Record<string, string> | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface UpdateAuthEventFeedbackRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  EventId: string | undefined;
  FeedbackToken: string | undefined;
  FeedbackValue: FeedbackValueType | undefined;
}
export interface UpdateAuthEventFeedbackResponse {}
export interface UpdateDeviceStatusRequest {
  AccessToken: string | undefined;
  DeviceKey: string | undefined;
  DeviceRememberedStatus?: DeviceRememberedStatusType | undefined;
}
export interface UpdateDeviceStatusResponse {}
export interface UpdateGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
  Description?: string | undefined;
  RoleArn?: string | undefined;
  Precedence?: number | undefined;
}
export interface UpdateGroupResponse {
  Group?: GroupType | undefined;
}
export interface UpdateIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
  ProviderDetails?: Record<string, string> | undefined;
  AttributeMapping?: Record<string, string> | undefined;
  IdpIdentifiers?: string[] | undefined;
}
export interface UpdateIdentityProviderResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface UpdateManagedLoginBrandingRequest {
  UserPoolId?: string | undefined;
  ManagedLoginBrandingId?: string | undefined;
  UseCognitoProvidedValues?: boolean | undefined;
  Settings?: __DocumentType | undefined;
  Assets?: AssetType[] | undefined;
}
export interface UpdateManagedLoginBrandingResponse {
  ManagedLoginBranding?: ManagedLoginBrandingType | undefined;
}
export interface UpdateResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
  Name: string | undefined;
  Scopes?: ResourceServerScopeType[] | undefined;
}
export interface UpdateResourceServerResponse {
  ResourceServer: ResourceServerType | undefined;
}
export interface UpdateTermsRequest {
  TermsId: string | undefined;
  UserPoolId: string | undefined;
  TermsName?: string | undefined;
  TermsSource?: TermsSourceType | undefined;
  Enforcement?: TermsEnforcementType | undefined;
  Links?: Record<string, string> | undefined;
}
export interface UpdateTermsResponse {
  Terms?: TermsType | undefined;
}
export interface UpdateUserAttributesRequest {
  UserAttributes: AttributeType[] | undefined;
  AccessToken: string | undefined;
  ClientMetadata?: Record<string, string> | undefined;
}
export interface UpdateUserAttributesResponse {
  CodeDeliveryDetailsList?: CodeDeliveryDetailsType[] | undefined;
}
export interface UpdateUserPoolRequest {
  UserPoolId: string | undefined;
  Policies?: UserPoolPolicyType | undefined;
  DeletionProtection?: DeletionProtectionType | undefined;
  LambdaConfig?: LambdaConfigType | undefined;
  AutoVerifiedAttributes?: VerifiedAttributeType[] | undefined;
  SmsVerificationMessage?: string | undefined;
  EmailVerificationMessage?: string | undefined;
  EmailVerificationSubject?: string | undefined;
  VerificationMessageTemplate?: VerificationMessageTemplateType | undefined;
  SmsAuthenticationMessage?: string | undefined;
  UserAttributeUpdateSettings?: UserAttributeUpdateSettingsType | undefined;
  MfaConfiguration?: UserPoolMfaType | undefined;
  DeviceConfiguration?: DeviceConfigurationType | undefined;
  EmailConfiguration?: EmailConfigurationType | undefined;
  SmsConfiguration?: SmsConfigurationType | undefined;
  UserPoolTags?: Record<string, string> | undefined;
  AdminCreateUserConfig?: AdminCreateUserConfigType | undefined;
  UserPoolAddOns?: UserPoolAddOnsType | undefined;
  AccountRecoverySetting?: AccountRecoverySettingType | undefined;
  PoolName?: string | undefined;
  UserPoolTier?: UserPoolTierType | undefined;
}
export interface UpdateUserPoolResponse {}
export interface UpdateUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  ClientName?: string | undefined;
  RefreshTokenValidity?: number | undefined;
  AccessTokenValidity?: number | undefined;
  IdTokenValidity?: number | undefined;
  TokenValidityUnits?: TokenValidityUnitsType | undefined;
  ReadAttributes?: string[] | undefined;
  WriteAttributes?: string[] | undefined;
  ExplicitAuthFlows?: ExplicitAuthFlowsType[] | undefined;
  SupportedIdentityProviders?: string[] | undefined;
  CallbackURLs?: string[] | undefined;
  LogoutURLs?: string[] | undefined;
  DefaultRedirectURI?: string | undefined;
  AllowedOAuthFlows?: OAuthFlowType[] | undefined;
  AllowedOAuthScopes?: string[] | undefined;
  AllowedOAuthFlowsUserPoolClient?: boolean | undefined;
  AnalyticsConfiguration?: AnalyticsConfigurationType | undefined;
  PreventUserExistenceErrors?: PreventUserExistenceErrorTypes | undefined;
  EnableTokenRevocation?: boolean | undefined;
  EnablePropagateAdditionalUserContextData?: boolean | undefined;
  AuthSessionValidity?: number | undefined;
  RefreshTokenRotation?: RefreshTokenRotationType | undefined;
}
