import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { AddTagsToStream$ } from "../schemas/schemas_0";
export { $Command };
export class AddTagsToStreamCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    StreamARN: { type: "contextParams", name: "StreamARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "AddTagsToStream", {})
    .n("KinesisClient", "AddTagsToStreamCommand")
    .sc(AddTagsToStream$)
    .build() {
}
