import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DeregisterStreamConsumer$ } from "../schemas/schemas_0";
export { $Command };
export class DeregisterStreamConsumerCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    ConsumerARN: { type: "contextParams", name: "ConsumerARN" },
    StreamARN: { type: "contextParams", name: "StreamARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "DeregisterStreamConsumer", {})
    .n("KinesisClient", "DeregisterStreamConsumerCommand")
    .sc(DeregisterStreamConsumer$)
    .build() {
}
