import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeStreamConsumer$ } from "../schemas/schemas_0";
export { $Command };
export class DescribeStreamConsumerCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    ConsumerARN: { type: "contextParams", name: "ConsumerARN" },
    StreamARN: { type: "contextParams", name: "StreamARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "DescribeStreamConsumer", {})
    .n("KinesisClient", "DescribeStreamConsumerCommand")
    .sc(DescribeStreamConsumer$)
    .build() {
}
